/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShowObjectPropertyHierarchyController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ShowObjectPropertyHierarchyController.class.getName());
    private static final String TEMPLATE_NAME = "siteAdmin-objectPropHierarchy.ftl";
    private int MAXDEPTH = 5;
    private ObjectPropertyDao opDao = null;
    private ObjectPropertyDao opDaoLangNeut = null;
    private VClassDao vcDao = null;
    private VClassDao vcDaoLangNeut = null;
    private PropertyGroupDao pgDao = null;
    private int previous_posn = 0;

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.EDIT_ONTOLOGY.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            String displayOption = "";
            displayOption = vreq.getParameter("displayOption") != null ? vreq.getParameter("displayOption") : "hierarchy";
            body.put("displayOption", displayOption);
            if (displayOption.equals("all")) {
                body.put("pageTitle", "All Object Properties");
            } else {
                body.put("pageTitle", "Object Property Hierarchy");
            }
            body.put("propertyType", "object");
            this.opDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getObjectPropertyDao();
            this.opDaoLangNeut = vreq.getLanguageNeutralWebappDaoFactory().getObjectPropertyDao();
            this.vcDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getVClassDao();
            this.vcDaoLangNeut = vreq.getLanguageNeutralWebappDaoFactory().getVClassDao();
            this.pgDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getPropertyGroupDao();
            String json = new String();
            String ontologyUri = vreq.getParameter("ontologyUri");
            String startPropertyUri = vreq.getParameter("propertyUri");
            List<Object> roots = null;
            if (startPropertyUri != null) {
                roots = new LinkedList();
                ObjectProperty op = this.opDao.getObjectPropertyByURI(startPropertyUri);
                if (op == null) {
                    op = new ObjectProperty();
                    op.setURI(startPropertyUri);
                }
                roots.add(op);
            } else {
                roots = this.opDao.getRootObjectProperties();
                if (roots != null) {
                    Collections.sort(roots, new ObjectPropertyAlphaComparator(vreq));
                }
            }
            int counter = 0;
            if (roots != null) {
                Iterator<Object> rootIt = roots.iterator();
                if (!rootIt.hasNext()) {
                    ObjectProperty op = new ObjectProperty();
                    op.setURI(ontologyUri + "fake");
                    String notFoundMessage = "<strong>No object properties found.</strong>";
                    op.setDomainPublic(notFoundMessage);
                    json = json + this.addObjectPropertyDataToResultsList(op, 0, ontologyUri, counter);
                } else {
                    while (rootIt.hasNext()) {
                        ObjectProperty root = (ObjectProperty)rootIt.next();
                        if (ontologyUri != null && (ontologyUri == null || root.getNamespace() == null || !ontologyUri.equals(root.getNamespace()))) continue;
                        json = json + this.addChildren(root, 0, ontologyUri, counter);
                        ++counter;
                    }
                    int length = json.length();
                    if (length > 0) {
                        json = json + " }";
                    }
                }
            }
            body.put("jsonTree", json);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private String addChildren(ObjectProperty parent, int position, String ontologyUri, int counter) {
        String details = this.addObjectPropertyDataToResultsList(parent, position, ontologyUri, counter);
        int length = details.length();
        String leaves = "";
        leaves = leaves + details;
        List<String> childURIstrs = this.opDao.getSubPropertyURIs(parent.getURI());
        if (childURIstrs.size() > 0 && position < this.MAXDEPTH) {
            ObjectProperty child;
            ArrayList<ObjectProperty> childProps = new ArrayList<ObjectProperty>();
            for (String URIstr : childURIstrs) {
                child = this.opDao.getObjectPropertyByURI(URIstr);
                childProps.add(child);
            }
            Collections.sort(childProps);
            Iterator childPropIt = childProps.iterator();
            while (childPropIt.hasNext()) {
                child = (ObjectProperty)childPropIt.next();
                leaves = leaves + this.addChildren(child, position + 1, ontologyUri, counter);
                if (childPropIt.hasNext()) continue;
                if (ontologyUri == null) {
                    leaves = leaves + " }] ";
                    continue;
                }
                if (ontologyUri == null || length <= 0) continue;
                String ending = leaves.substring(leaves.length() - 2, leaves.length());
                if (ending.equals("] ")) {
                    leaves = leaves + "}]";
                    continue;
                }
                if (ending.equals(" [")) {
                    leaves = leaves + "] ";
                    continue;
                }
                leaves = leaves + "}]";
            }
        } else if (ontologyUri == null) {
            leaves = leaves + "] ";
        } else if (ontologyUri != null && length > 0) {
            leaves = leaves + "] ";
        }
        return leaves;
    }

    private String addObjectPropertyDataToResultsList(ObjectProperty op, int position, String ontologyUri, int counter) {
        String tempString = "";
        if (ontologyUri == null || op.getNamespace() != null && op.getNamespace().equals(ontologyUri)) {
            if (counter < 1 && position < 1) {
                tempString = tempString + "{ \"name\": ";
            } else if (position == this.previous_posn) {
                tempString = tempString + "}, { \"name\": ";
            } else if (position > this.previous_posn) {
                tempString = tempString + " { \"name\": ";
            } else if (position < this.previous_posn) {
                tempString = tempString + "}, { \"name\": ";
            }
            String nameStr = ShowObjectPropertyHierarchyController.getDisplayLabel(op) == null ? "(no name)" : ShowObjectPropertyHierarchyController.getDisplayLabel(op);
            tempString = tempString + JacksonUtils.quote("<a href='propertyEdit?uri=" + URLEncoder.encode(op.getURI()) + "'>" + nameStr + "</a>") + ", ";
            tempString = tempString + "\"data\": { \"internalName\": " + JacksonUtils.quote(op.getLocalNameWithPrefix()) + ", ";
            ObjectProperty opLangNeut = this.opDaoLangNeut.getObjectPropertyByURI(op.getURI());
            if (opLangNeut == null) {
                opLangNeut = op;
            }
            String domainStr = this.getVClassNameFromURI(opLangNeut.getDomainVClassURI(), this.vcDao, this.vcDaoLangNeut);
            String rangeStr = this.getVClassNameFromURI(opLangNeut.getRangeVClassURI(), this.vcDao, this.vcDaoLangNeut);
            try {
                tempString = tempString + "\"domainVClass\": " + JacksonUtils.quote(domainStr) + ", ";
            }
            catch (NullPointerException e) {
                tempString = tempString + "\"domainVClass\": \"\",";
            }
            try {
                tempString = tempString + "\"rangeVClass\": " + JacksonUtils.quote(rangeStr) + ", ";
            }
            catch (NullPointerException e) {
                tempString = tempString + "\"rangeVClass\": \"\",";
            }
            if (op.getGroupURI() != null) {
                PropertyGroup pGroup = this.pgDao.getGroupByURI(op.getGroupURI());
                tempString = tempString + "\"group\": " + JacksonUtils.quote(pGroup == null ? "unknown group" : pGroup.getName());
            } else {
                tempString = tempString + "\"group\": \"unspecified\"";
            }
            tempString = tempString + "}, \"children\": [";
            this.previous_posn = position;
        }
        return tempString;
    }

    private String getVClassNameFromURI(String vclassURI, VClassDao vcDao, VClassDao vcDaoLangNeut) {
        if (vclassURI == null) {
            return "";
        }
        VClass vclass = vcDaoLangNeut.getVClassByURI(vclassURI);
        if (vclass == null) {
            return "";
        }
        if (vclass.isAnonymous()) {
            return vclass.getPickListName();
        }
        VClass vclassWLang = vcDao.getVClassByURI(vclassURI);
        return vclassWLang != null ? vclassWLang.getPickListName() : vclass.getPickListName();
    }

    public static String getDisplayLabel(ObjectProperty op) {
        String displayLabel = op.getPickListName();
        displayLabel = displayLabel != null && displayLabel.length() > 0 ? displayLabel : op.getLocalName();
        return displayLabel != null ? displayLabel : "[object property]";
    }

    public static class ObjectPropertyAlphaComparator
    implements Comparator<ObjectProperty> {
        Collator collator;

        public ObjectPropertyAlphaComparator(VitroRequest vreq) {
            this.collator = vreq.getCollator();
        }

        @Override
        public int compare(ObjectProperty op1, ObjectProperty op2) {
            if (op1 == null) {
                return 1;
            }
            if (op2 == null) {
                return -1;
            }
            String propLabel1 = op1.getPickListName();
            String propLabel2 = op2.getPickListName();
            if (propLabel1 == null) {
                return 1;
            }
            if (propLabel2 == null) {
                return -1;
            }
            return this.collator.compare(propLabel1, propLabel2);
        }
    }
}

