/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RdfResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.jena.ExtendedLinkedDataUtils;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaOutputUtils;
import edu.cornell.mannlib.vitro.webapp.web.ContentType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

@Deprecated
public class ExtendedRdfAssembler {
    private static final Log log = LogFactory.getLog(ExtendedRdfAssembler.class);
    private static final String RICH_EXPORT_ROOT = "/WEB-INF/rich-export/";
    private static final String PERSON_CLASS_URI = "http://xmlns.com/foaf/0.1/Person";
    private static final String INCLUDE_ALL = "all";
    private static final Map<String, String> namespaces = new HashMap<String, String>(){
        {
            this.put("display", "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#");
            this.put("vitro", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#");
            this.put("vitroPublic", "http://vitro.mannlib.cornell.edu/ns/vitro/public#");
        }
    };
    private static final Property extendedLinkedDataProperty = ResourceFactory.createProperty((String)(namespaces.get("vitro") + "extendedLinkedData"));
    private static final Literal xsdTrue = ResourceFactory.createTypedLiteral((String)"true", (RDFDatatype)XSDDatatype.XSDboolean);
    private final VitroRequest vreq;
    private final ServletContext ctx;
    private final Individual individual;
    private final ContentType rdfFormat;

    public ExtendedRdfAssembler(VitroRequest vreq, Individual individual, ContentType rdfFormat) {
        this.vreq = vreq;
        this.ctx = vreq.getSession().getServletContext();
        this.individual = individual;
        this.rdfFormat = rdfFormat;
    }

    public ResponseValues assembleRdf() {
        OntModel ontModel = this.vreq.getJenaOntModel();
        String[] includes = this.vreq.getParameterValues("include");
        Model newModel = this.getRDF(this.individual, ontModel, ModelFactory.createDefaultModel(), 0, includes);
        JenaOutputUtils.setNameSpacePrefixes(newModel, this.vreq.getWebappDaoFactory());
        return new RdfResponseValues(this.rdfFormat, newModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getRDF(Individual entity, OntModel contextModel, Model newModel, int recurseDepth, String[] includes) {
        Resource subj = newModel.getResource(entity.getURI());
        List<DataPropertyStatement> dstates = entity.getDataPropertyStatements();
        TypeMapper typeMapper = TypeMapper.getInstance();
        for (DataPropertyStatement ds : dstates) {
            Property dp = newModel.getProperty(ds.getDatapropURI());
            Literal lit = null;
            lit = ds.getLanguage() != null && ds.getLanguage().length() > 0 ? newModel.createLiteral(ds.getData(), ds.getLanguage()) : (ds.getDatatypeURI() != null && ds.getDatatypeURI().length() > 0 ? newModel.createTypedLiteral(ds.getData(), typeMapper.getSafeTypeByName(ds.getDatatypeURI())) : newModel.createLiteral(ds.getData()));
            newModel.add(newModel.createStatement(subj, dp, (RDFNode)lit));
        }
        if (recurseDepth < 5) {
            List<ObjectPropertyStatement> ostates = entity.getObjectPropertyStatements();
            for (ObjectPropertyStatement os : ostates) {
                Property prop = newModel.getProperty(os.getPropertyURI());
                Resource obj = newModel.getResource(os.getObjectURI());
                newModel.add(newModel.createStatement(subj, prop, (RDFNode)obj));
                if (ExtendedRdfAssembler.includeInLinkedData(obj, (Model)contextModel)) {
                    newModel.add(this.getRDF(os.getObject(), contextModel, newModel, recurseDepth + 1, includes));
                    continue;
                }
                contextModel.enterCriticalSection(true);
                try {
                    newModel.add(contextModel.listStatements(obj, RDFS.label, (RDFNode)null));
                }
                finally {
                    contextModel.leaveCriticalSection();
                }
            }
        }
        newModel = this.getLabelAndTypes(entity, (Model)contextModel, newModel);
        newModel = this.getStatementsWithUntypedProperties(subj, contextModel, ModelAccess.on((HttpServletRequest)this.vreq).getOntModel("vitro:baseOntModel", new ModelAccess.LanguageOption[0]), newModel);
        if (recurseDepth == 0 && includes != null && entity.isVClass(PERSON_CLASS_URI)) {
            for (String include : includes) {
                String rootDir = null;
                rootDir = INCLUDE_ALL.equals(include) ? RICH_EXPORT_ROOT : RICH_EXPORT_ROOT + include + "/";
                long start = System.currentTimeMillis();
                Model extendedModel = ExtendedLinkedDataUtils.createModelFromQueries(this.ctx, rootDir, contextModel, entity.getURI());
                long elapsedTimeMillis = System.currentTimeMillis() - start;
                log.info((Object)("Time to create rich export model: msecs = " + elapsedTimeMillis));
                newModel.add(extendedModel);
            }
        }
        return newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean includeInLinkedData(Resource object, Model contextModel) {
        boolean retval = false;
        contextModel.enterCriticalSection(true);
        try {
            StmtIterator iter = contextModel.listStatements(object, RDF.type, (RDFNode)null);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                if (!stmt.getObject().isResource() || !contextModel.contains(stmt.getObject().asResource(), extendedLinkedDataProperty, (RDFNode)xsdTrue)) continue;
                retval = true;
                break;
            }
        }
        finally {
            contextModel.leaveCriticalSection();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getLabelAndTypes(Individual entity, Model ontModel, Model newModel) {
        for (VClass vclass : entity.getVClasses()) {
            newModel.add(newModel.getResource(entity.getURI()), RDF.type, (RDFNode)newModel.getResource(vclass.getURI()));
        }
        ontModel.enterCriticalSection(true);
        try {
            newModel.add(ontModel.listStatements(ontModel.getResource(entity.getURI()), RDFS.label, (RDFNode)null));
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getStatementsWithUntypedProperties(Resource subject, OntModel contextModel, OntModel assertionsModel, Model newModel) {
        contextModel.enterCriticalSection(true);
        try {
            StmtIterator iter = contextModel.listStatements(subject, (Property)null, (RDFNode)null);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                Property property = stmt.getPredicate();
                assertionsModel.enterCriticalSection(true);
                try {
                    if (assertionsModel.contains((Resource)property, RDF.type) || newModel.contains(stmt)) continue;
                    newModel.add(stmt);
                }
                finally {
                    assertionsModel.leaveCriticalSection();
                }
            }
        }
        finally {
            contextModel.leaveCriticalSection();
        }
        return newModel;
    }
}

