/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryConfig;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SimpleOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class JenaModelUtils {
    private static final Log log = LogFactory.getLog((String)JenaModelUtils.class.getName());
    private static final Set<String> nonIndividualTypeURIs = new HashSet<String>();
    private final OntModelSpec DEFAULT_ONT_MODEL_SPEC = OntModelSpec.OWL_MEM;
    private final boolean NORMAL = false;
    private final boolean AGGRESSIVE = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OntModel[] makeClassGroupsFromRootClasses(WebappDaoFactory wadf, Model tboxModel) {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)tboxModel);
        OntModel modelForClassgroups = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntModel modelForClassgroupAnnotations = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        SimpleOntModelSelector oms = new SimpleOntModelSelector();
        oms.setTBoxModel(ontModel);
        oms.setApplicationMetadataModel(modelForClassgroups);
        WebappDaoFactoryConfig config = new WebappDaoFactoryConfig();
        config.setDefaultNamespace(wadf.getDefaultNamespace());
        WebappDaoFactoryJena myWebappDaoFactory = new WebappDaoFactoryJena(new SimpleOntModelSelector(ontModel), config, null);
        Resource classGroupClass = ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#ClassGroup");
        Property inClassGroupProperty = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup");
        ontModel.enterCriticalSection(true);
        try {
            try {
                List<VClass> rootClasses = myWebappDaoFactory.getVClassDao().getRootClasses();
                for (VClass rootClass : rootClasses) {
                    Individual classGroup = modelForClassgroups.createIndividual(wadf.getDefaultNamespace() + "vitroClassGroup" + rootClass.getLocalName(), classGroupClass);
                    classGroup.setLabel(rootClass.getName(), null);
                    Resource rootClassRes = modelForClassgroupAnnotations.getResource(rootClass.getURI());
                    modelForClassgroupAnnotations.add(rootClassRes, inClassGroupProperty, (RDFNode)classGroup);
                    for (String childURI : myWebappDaoFactory.getVClassDao().getAllSubClassURIs(rootClass.getURI())) {
                        Resource childClass = modelForClassgroupAnnotations.getResource(childURI);
                        if (modelForClassgroupAnnotations.contains(childClass, inClassGroupProperty, (RDFNode)null)) continue;
                        childClass.addProperty(inClassGroupProperty, (RDFNode)classGroup);
                    }
                }
            }
            catch (Exception e) {
                String errMsg = "Unable to create class groups automatically based on class hierarchy";
                log.error((Object)errMsg, (Throwable)e);
                throw new RuntimeException(errMsg, e);
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        OntModel[] resultArray = new OntModel[]{modelForClassgroups, modelForClassgroupAnnotations};
        return resultArray;
    }

    public OntModel extractTBox(Model inputModel) {
        return this.extractTBox(inputModel, null);
    }

    public OntModel extractTBox(Model inputModel, boolean MODE) {
        Dataset dataset = DatasetFactory.create((Model)inputModel);
        return this.extractTBox(dataset, null, null, MODE);
    }

    public OntModel extractTBox(Model inputModel, String namespace) {
        Dataset dataset = DatasetFactory.create((Model)inputModel);
        return this.extractTBox(dataset, namespace, null, false);
    }

    public OntModel extractTBox(Dataset dataset, String namespace, String graphURI) {
        return this.extractTBox(dataset, namespace, graphURI, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OntModel extractTBox(Dataset dataset, String namespace, String graphURI, boolean mode) {
        OntModel tboxModel = ModelFactory.createOntologyModel((OntModelSpec)this.DEFAULT_ONT_MODEL_SPEC);
        LinkedList<String> queryStrList = new LinkedList<String>();
        queryStrList.add(this.makeDescribeQueryStr(OWL.Class.getURI(), namespace, graphURI));
        queryStrList.add(this.makeDescribeQueryStr(OWL.Restriction.getURI(), namespace, graphURI));
        queryStrList.add(this.makeDescribeQueryStr(OWL.ObjectProperty.getURI(), namespace, graphURI));
        queryStrList.add(this.makeDescribeQueryStr(OWL.DatatypeProperty.getURI(), namespace, graphURI));
        queryStrList.add(this.makeDescribeQueryStr(OWL.AnnotationProperty.getURI(), namespace, graphURI));
        if (namespace != null && namespace.endsWith("#")) {
            queryStrList.add(this.makeDescribeQueryStr(OWL.Ontology.getURI(), namespace.substring(0, namespace.length() - 1), graphURI));
        } else {
            queryStrList.add(this.makeDescribeQueryStr(OWL.Ontology.getURI(), namespace, graphURI));
        }
        for (String queryStr : queryStrList) {
            Query tboxSparqlQuery = QueryFactory.create((String)queryStr);
            QueryExecution qe = QueryExecutionFactory.create((Query)tboxSparqlQuery, (Dataset)dataset);
            try {
                dataset.getLock().enterCriticalSection(true);
                qe.execDescribe((Model)tboxModel);
            }
            finally {
                dataset.getLock().leaveCriticalSection();
            }
        }
        if (mode) {
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)RDFS.subClassOf));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)RDFS.subPropertyOf));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.equivalentClass));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.unionOf));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.intersectionOf));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.complementOf));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.onProperty));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.allValuesFrom));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.someValuesFrom));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.hasValue));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.minCardinality));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.maxCardinality));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.cardinality));
            tboxModel.add(this.construct(dataset, namespace, graphURI, (Resource)OWL.disjointWith));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayLimitAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayRankAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inPropertyGroupAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#prohibitedFromUpdateBelowRoleLevelAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromDisplayBelowRoleLevelAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromPublishBelowRoleLevelAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#descriptionAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/IAO_0000115")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/IAO_0000112")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#extendedLinkedData")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#offerCreateNewOptionAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#collateBySubclassAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customListViewAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customDisplayViewAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customEntryFormAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customSearchViewAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customShortViewAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#individualSortDirectionAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#individualSortFieldAnnot")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#objectIndividualSortProperty")));
            tboxModel.add(this.construct(dataset, namespace, graphURI, ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#selectFromExistingAnnot")));
        }
        return tboxModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model construct(Dataset dataset, String namespace, String graphURI, Resource property) {
        dataset.getLock().enterCriticalSection(true);
        try {
            Model model;
            StringBuffer buff = new StringBuffer();
            buff.append("PREFIX afn: <http://jena.apache.org/ARQ/function#> \n").append("CONSTRUCT { \n").append("  ?res <" + property.getURI() + "> ?o } WHERE { \n");
            if (graphURI != null) {
                buff.append("    GRAPH " + graphURI + " { \n");
            }
            buff.append("      ?res <" + property.getURI() + "> ?o \n");
            buff.append(this.getNamespaceFilter(namespace));
            if (graphURI != null) {
                buff.append("    } \n");
            }
            buff.append("}");
            Query constructProp = QueryFactory.create((String)buff.toString());
            QueryExecution qe = QueryExecutionFactory.create((Query)constructProp, (Dataset)dataset);
            try {
                model = qe.execConstruct();
            }
            catch (Throwable throwable) {
                qe.close();
                throw throwable;
            }
            qe.close();
            return model;
        }
        finally {
            dataset.getLock().leaveCriticalSection();
        }
    }

    private String makeDescribeQueryStr(String typeURI, String namespace) {
        return this.makeDescribeQueryStr(typeURI, namespace, null);
    }

    private String makeDescribeQueryStr(String typeURI, String namespace, String graphURI) {
        StringBuffer describeQueryStrBuff = new StringBuffer().append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \n").append("PREFIX afn: <http://jena.apache.org/ARQ/function#> \n").append("DESCRIBE ?res WHERE { \n");
        if (graphURI != null) {
            describeQueryStrBuff.append("GRAPH " + graphURI + "{ \n");
        }
        describeQueryStrBuff.append("    ?res rdf:type <").append(typeURI).append("> . \n");
        describeQueryStrBuff.append("    FILTER (!isBlank(?res)) \n").append(this.getNamespaceFilter(namespace));
        if (graphURI != null) {
            describeQueryStrBuff.append("} \n");
        }
        describeQueryStrBuff.append("} \n");
        return describeQueryStrBuff.toString();
    }

    private String getNamespaceFilter(String namespace) {
        StringBuffer buff = new StringBuffer();
        if (namespace == null) {
            buff.append("    FILTER (afn:namespace(?res) != \"").append("http://www.w3.org/2002/07/owl#").append("\") \n").append("    FILTER (?res != <").append("http://www.w3.org/2002/07/owl").append(">) \n");
        } else {
            buff.append("    FILTER (regex(str(?res), \"^").append(namespace).append("\")) \n");
        }
        return buff.toString();
    }

    public Model extractABox(Model inputModel) {
        Dataset dataset = DatasetFactory.create((Model)inputModel);
        return this.extractABox(dataset, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model extractABox(Dataset unionDataset, Dataset baseOrInfDataset, String graphURI) {
        Model aboxModel = ModelFactory.createDefaultModel();
        OntModel ontModel = this.extractTBox(unionDataset, null, graphURI);
        try {
            ontModel.enterCriticalSection(true);
            ExtendedIterator classIt = ontModel.listNamedClasses();
            QueryExecution qe = null;
            while (classIt.hasNext()) {
                OntClass ontClass = (OntClass)classIt.next();
                if (ontClass.getNameSpace().startsWith(OWL.getURI())) continue;
                String queryStr = this.makeDescribeQueryStr(ontClass.getURI(), null, graphURI);
                Query aboxSparqlQuery = QueryFactory.create((String)queryStr);
                qe = baseOrInfDataset != null ? QueryExecutionFactory.create((Query)aboxSparqlQuery, (Dataset)baseOrInfDataset) : QueryExecutionFactory.create((Query)aboxSparqlQuery, (Dataset)unionDataset);
                if (baseOrInfDataset != null) {
                    try {
                        baseOrInfDataset.getLock().enterCriticalSection(true);
                        qe.execDescribe(aboxModel);
                        continue;
                    }
                    finally {
                        baseOrInfDataset.getLock().leaveCriticalSection();
                        continue;
                    }
                }
                try {
                    unionDataset.getLock().enterCriticalSection(true);
                    qe.execDescribe(aboxModel);
                }
                finally {
                    unionDataset.getLock().leaveCriticalSection();
                }
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return aboxModel;
    }

    static {
        nonIndividualTypeURIs.add(OWL.Class.getURI());
        nonIndividualTypeURIs.add(OWL.Restriction.getURI());
        nonIndividualTypeURIs.add(OWL.ObjectProperty.getURI());
        nonIndividualTypeURIs.add(OWL.DatatypeProperty.getURI());
        nonIndividualTypeURIs.add(OWL.AnnotationProperty.getURI());
        nonIndividualTypeURIs.add(OWL.Ontology.getURI());
        nonIndividualTypeURIs.add(RDFS.Class.getURI());
        nonIndividualTypeURIs.add(RDF.Property.getURI());
    }
}

