/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public class PropertyGroupDaoJena
extends JenaBaseDao
implements PropertyGroupDao {
    private static final Log log = LogFactory.getLog((String)PropertyGroupDaoJena.class.getName());

    public PropertyGroupDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getApplicationMetadataModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePropertyGroup(PropertyGroup group) {
        this.getOntModel().enterCriticalSection(false);
        try {
            Individual groupInd = this.getOntModel().getIndividual(group.getURI());
            if (groupInd != null) {
                groupInd.remove();
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        OntModel tboxModel = this.getOntModelSelector().getTBoxModel();
        tboxModel.enterCriticalSection(false);
        try {
            Resource groupRes = ResourceFactory.createResource((String)group.getURI());
            tboxModel.removeAll(groupRes, null, null);
            tboxModel.removeAll(null, null, (RDFNode)groupRes);
        }
        finally {
            tboxModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyGroup getGroupByURI(String uri) {
        if (uri == null) {
            return null;
        }
        this.getOntModel().enterCriticalSection(true);
        try {
            Individual group = this.getOntModel().getIndividual(uri);
            PropertyGroup propertyGroup = this.groupFromGroupIndividual(group);
            return propertyGroup;
        }
        catch (IllegalArgumentException ex) {
            PropertyGroup propertyGroup = null;
            return propertyGroup;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyGroup> getPublicGroups(boolean withProperties) {
        ObjectPropertyDao opDao = this.getWebappDaoFactory().getObjectPropertyDao();
        DataPropertyDao dpDao = this.getWebappDaoFactory().getDataPropertyDao();
        ArrayList<PropertyGroup> groups = new ArrayList<PropertyGroup>();
        this.getOntModel().enterCriticalSection(true);
        try (ExtendedIterator groupIt = this.getOntModel().listIndividuals((Resource)this.PROPERTYGROUP);){
            while (groupIt.hasNext()) {
                Individual grp = (Individual)groupIt.next();
                PropertyGroup pgrp = this.groupFromGroupIndividual(grp);
                if (pgrp == null) continue;
                groups.add(pgrp);
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        if (withProperties) {
            OntModel tboxModel = this.getOntModelSelector().getTBoxModel();
            tboxModel.enterCriticalSection(true);
            try {
                for (PropertyGroup pgrp : groups) {
                    ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Property> properties = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Property>();
                    try (StmtIterator closeIt = tboxModel.listStatements(null, (Property)this.PROPERTY_INPROPERTYGROUPANNOT, (RDFNode)tboxModel.getResource(pgrp.getURI()));){
                        StmtIterator stmtIt = closeIt;
                        while (stmtIt.hasNext()) {
                            Statement stmt = (Statement)stmtIt.next();
                            Resource subjRes = stmt.getSubject();
                            if (subjRes.canAs(ObjectProperty.class)) {
                                properties.add(opDao.getObjectPropertyByURI(subjRes.getURI()));
                                continue;
                            }
                            if (!subjRes.canAs(DatatypeProperty.class)) continue;
                            properties.add(dpDao.getDataPropertyByURI(subjRes.getURI()));
                        }
                    }
                    pgrp.setPropertyList(properties);
                }
            }
            finally {
                tboxModel.leaveCriticalSection();
            }
        }
        Collections.sort(groups);
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String insertNewPropertyGroup(PropertyGroup group) {
        IndividualImpl groupInd = new IndividualImpl();
        groupInd.setNamespace(this.DEFAULT_NAMESPACE + "vitroPropertyGroup");
        groupInd.setName(group.getName());
        groupInd.setVClassURI(this.PROPERTYGROUP.getURI());
        groupInd.setURI(group.getURI());
        String groupURI = null;
        OntModel unionForURIGeneration = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)ModelFactory.createUnion((Model)this.getOntModelSelector().getApplicationMetadataModel(), (Model)this.getOntModelSelector().getFullModel()));
        try (WebappDaoFactory wadfForURIGeneration = null;){
            wadfForURIGeneration = new WebappDaoFactoryJena(unionForURIGeneration);
            groupURI = wadfForURIGeneration.getIndividualDao().insertNewIndividual(groupInd);
        }
        if (groupURI != null) {
            this.getOntModel().enterCriticalSection(false);
            try {
                Individual groupJenaInd = this.getOntModel().getIndividual(groupURI);
                try {
                    groupJenaInd.addProperty((Property)this.DISPLAY_RANK, Integer.toString(group.getDisplayRank()), (RDFDatatype)XSDDatatype.XSDint);
                }
                catch (Exception e) {
                    log.error((Object)("error setting displayRank for " + groupInd.getURI()));
                }
                if (group.getPublicDescription() == null || group.getPublicDescription().length() <= 0) return groupURI;
                try {
                    groupJenaInd.addProperty((Property)this.PUBLIC_DESCRIPTION_ANNOT, group.getPublicDescription(), (RDFDatatype)XSDDatatype.XSDstring);
                    return groupURI;
                }
                catch (Exception ex) {
                    log.error((Object)("error setting public description for " + groupInd.getURI()));
                }
                return groupURI;
            }
            finally {
                this.getOntModel().leaveCriticalSection();
            }
        }
        log.error((Object)("Unable to insert property group " + group.getName()));
        return groupURI;
    }

    @Override
    public int removeUnpopulatedGroups(List<PropertyGroup> groups) {
        if (groups == null || groups.size() == 0) {
            return 0;
        }
        int removedGroupsCount = 0;
        ListIterator<PropertyGroup> it = groups.listIterator();
        while (it.hasNext()) {
            PropertyGroup group = it.next();
            List<edu.cornell.mannlib.vitro.webapp.beans.Property> properties = group.getPropertyList();
            if (properties != null && properties.size() >= 1) continue;
            ++removedGroupsCount;
            it.remove();
        }
        return removedGroupsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePropertyGroup(PropertyGroup group) {
        OntModel ontModel = this.getOntModelSelector().getApplicationMetadataModel();
        ontModel.enterCriticalSection(false);
        try {
            Individual groupInd = ontModel.getIndividual(group.getURI());
            try {
                groupInd.setLabel(group.getName(), this.getDefaultLanguage());
            }
            catch (Exception e) {
                log.error((Object)("error updating name for " + groupInd.getURI()));
            }
            try {
                groupInd.removeAll((Property)this.PUBLIC_DESCRIPTION_ANNOT);
                if (group.getPublicDescription() != null && group.getPublicDescription().length() > 0) {
                    groupInd.addProperty((Property)this.PUBLIC_DESCRIPTION_ANNOT, group.getPublicDescription(), (RDFDatatype)XSDDatatype.XSDstring);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error updating public description for " + groupInd.getURI()));
            }
            try {
                groupInd.removeAll((Property)this.DISPLAY_RANK);
                groupInd.addProperty((Property)this.DISPLAY_RANK, Integer.toString(group.getDisplayRank()), (RDFDatatype)XSDDatatype.XSDint);
            }
            catch (Exception e) {
                log.error((Object)("error updating display rank for " + groupInd.getURI()));
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public PropertyGroup createDummyPropertyGroup(String name, int rank) {
        PropertyGroup newGroup = new PropertyGroup();
        newGroup.setName(name);
        newGroup.setDisplayRank(rank);
        newGroup.setURI(this.DEFAULT_NAMESPACE + "vitroPropertyGroup" + "name");
        ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Property> propsList = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Property>();
        newGroup.setPropertyList(propsList);
        return newGroup;
    }

    private PropertyGroup groupFromGroupIndividual(Individual groupInd) {
        if (groupInd == null) {
            return null;
        }
        PropertyGroup group = new PropertyGroup();
        group.setName(this.getLabelOrId((OntResource)groupInd));
        group.setURI(groupInd.getURI());
        group.setNamespace(groupInd.getNameSpace());
        group.setLocalName(groupInd.getLocalName());
        group.setPublicDescription(this.getPropertyStringValue((OntResource)groupInd, (Property)this.PUBLIC_DESCRIPTION_ANNOT));
        group.setDisplayRank(this.getPropertyNonNegativeIntValue((OntResource)groupInd, (Property)this.DISPLAY_RANK));
        return group;
    }
}

