/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessClassGroupDataGetterN3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class ProcessIndividualsForClassesDataGetterN3
extends ProcessClassGroupDataGetterN3 {
    private static String classType = "java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.IndividualsForClassesDataGetter";
    protected static String individualClassVarNameBase = "classesSelectedInClassGroup";
    private Log log = LogFactory.getLog(ProcessIndividualsForClassesDataGetterN3.class);

    @Override
    public List<String> retrieveN3Required(int counter) {
        List<String> classGroupN3 = this.retrieveN3ForTypeAndClassGroup(counter);
        classGroupN3.addAll(this.addIndividualClassesN3(counter));
        return classGroupN3;
    }

    protected List<String> addIndividualClassesN3(int counter) {
        ArrayList<String> classN3 = new ArrayList<String>();
        classN3.add(this.generateIndividualClassN3(counter));
        return classN3;
    }

    protected String generateIndividualClassN3(int counter) {
        String dataGetterVar = this.getDataGetterVar(counter);
        String n3 = dataGetterVar + " <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass" + "> ";
        n3 = n3 + this.getN3VarName(individualClassVarNameBase, counter);
        n3 = n3 + " .";
        return n3;
    }

    @Override
    public List<String> retrieveN3Optional(int counter) {
        return null;
    }

    @Override
    public List<String> retrieveLiteralsOnForm(int counter) {
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        return literalsOnForm;
    }

    @Override
    public List<String> retrieveUrisOnForm(int counter) {
        List<String> urisOnForm = super.retrieveUrisOnForm(counter);
        urisOnForm.add(this.getVarName(individualClassVarNameBase, counter));
        return urisOnForm;
    }

    @Override
    public List<FieldVTwo> retrieveFields(int counter) {
        List<FieldVTwo> fields = super.retrieveFields(counter);
        fields.add(new FieldVTwo().setName(this.getVarName(individualClassVarNameBase, counter)));
        return fields;
    }

    @Override
    public List<String> getLiteralVarNamesBase() {
        return Arrays.asList(new String[0]);
    }

    @Override
    public List<String> getUriVarNamesBase() {
        return Arrays.asList("classGroup", individualClassVarNameBase, classTypeVarBase);
    }

    @Override
    public String getClassType() {
        return classType;
    }

    @Override
    public void populateExistingValues(String dataGetterURI, int counter, OntModel queryModel) {
        this.populateExistingDataGetterURI(dataGetterURI, counter);
        this.populateExistingClassType(this.getClassType(), counter);
        String querystr = this.getExistingValuesIndividualsForClasses(dataGetterURI);
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            ArrayList<String> individualsForClasses = new ArrayList<String>();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Resource classGroupResource = qs.getResource("classGroup");
                String classGroupVarName = this.getVarName(classGroupVarBase, counter);
                if (!this.existingUriValues.containsKey(classGroupVarName)) {
                    this.existingUriValues.put(this.getVarName(classGroupVarBase, counter), new ArrayList<String>(Arrays.asList(classGroupResource.getURI())));
                }
                Resource individualForClassResource = qs.getResource("individualForClass");
                individualsForClasses.add(individualForClassResource.getURI());
            }
            this.existingUriValues.put(this.getVarName(individualClassVarNameBase, counter), new ArrayList(individualsForClasses));
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
    }

    protected String getExistingValuesIndividualsForClasses(String dataGetterURI) {
        String query = this.getSparqlPrefix() + "SELECT ?classGroup  ?individualForClass WHERE {" + "<" + dataGetterURI + "> <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup" + "> ?classGroup  . \n" + "<" + dataGetterURI + "> <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass" + "> ?individualForClass . \n" + "}";
        return query;
    }

    @Override
    public ObjectNode getExistingValuesJSON(String dataGetterURI, OntModel queryModel, ServletContext context) {
        ObjectNode jObject = new ObjectMapper().createObjectNode();
        jObject.put("dataGetterClass", classType);
        jObject.put(classTypeVarBase, classType);
        this.getExistingClassGroupAndIndividuals(dataGetterURI, jObject, queryModel);
        super.getExistingClassesInClassGroup(context, dataGetterURI, jObject);
        return jObject;
    }

    private void getExistingClassGroupAndIndividuals(String dataGetterURI, ObjectNode jObject, OntModel queryModel) {
        String querystr = this.getExistingValuesIndividualsForClasses(dataGetterURI);
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            ArrayNode individualsForClasses = new ObjectMapper().createArrayNode();
            String classGroupURI = null;
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                if (classGroupURI == null) {
                    Resource classGroupResource = qs.getResource("classGroup");
                    classGroupURI = classGroupResource.getURI();
                }
                Resource individualForClassResource = qs.getResource("individualForClass");
                individualsForClasses.add(individualForClassResource.getURI());
            }
            jObject.put("classGroup", classGroupURI);
            jObject.set(individualClassVarNameBase, (JsonNode)individualsForClasses);
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
    }
}

