/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;

public class DefaultDataPropertyFormValidator
implements N3ValidatorVTwo {
    private Log log = LogFactory.getLog(DefaultDataPropertyFormValidator.class);
    VitroRequest vreq;
    private String datatype;
    private final I18nBundle i18n;
    private final String dtRegex = "^([0-9]{4})-((0[1-9])|(1[0-2]))-((0[1-9])|([1-2][0-9])|(3[0-1]))(T|\\s)(([0-1][0-9])|(2[0-3])):([0-5][0-9]):([0-5][0-9])";
    private final Pattern dtPattern = Pattern.compile("^([0-9]{4})-((0[1-9])|(1[0-2]))-((0[1-9])|([1-2][0-9])|(3[0-1]))(T|\\s)(([0-1][0-9])|(2[0-3])):([0-5][0-9]):([0-5][0-9])");
    private final String dateRegex = "^([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})";
    private final Pattern datePattern = Pattern.compile("^([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})");
    private final String timeRegex = "^(([0-1][0-9])|(2[0-3])):([0-5][0-9]):([0-5][0-9])";
    private final Pattern timePattern = Pattern.compile("^(([0-1][0-9])|(2[0-3])):([0-5][0-9]):([0-5][0-9])");
    private final String yearRegex = "^\\d{4}";
    private final Pattern yearPattern = Pattern.compile("^\\d{4}");
    private final String ymRegex = "^([0-9]{4})-(0[1-9]|1[012])";
    private final Pattern ymPattern = Pattern.compile("^([0-9]{4})-(0[1-9]|1[012])");
    private final String monthRegex = "^--(0[1-9]|1[012])";
    private final Pattern monthPattern = Pattern.compile("^--(0[1-9]|1[012])");
    private final String floatRegex = "^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?.";
    private final Pattern floatPattern = Pattern.compile("^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?.");
    private final String intRegex = "^-?\\d+$";
    private final Pattern intPattern = Pattern.compile("^-?\\d+$");

    public DefaultDataPropertyFormValidator(String datatype, VitroRequest vreq) {
        this.datatype = datatype;
        this.vreq = vreq;
        this.i18n = I18n.bundle((HttpServletRequest)vreq);
    }

    @Override
    public Map<String, String> validate(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        Map<String, List<Literal>> literalsFromForm = editSub.getLiteralsFromForm();
        HashMap<String, String> errors = new HashMap<String, String>();
        List<Literal> formLiterals = literalsFromForm.get("literal");
        Literal literal = null;
        if (formLiterals != null && formLiterals.size() > 0) {
            literal = formLiterals.get(0);
        }
        String literalValue = "";
        if (literal != null && "".equals(literalValue = literal.getLexicalForm())) {
            literal = null;
        }
        if (literal != null) {
            if (this.datatype.indexOf("#dateTime") > -1) {
                if (!this.dtPattern.matcher(literalValue).matches()) {
                    errors.put("dateTime", this.i18n.text("minimum_ymd", new Object[0]));
                }
            } else if (this.datatype.indexOf("#date") > -1) {
                if (!this.datePattern.matcher(literalValue).matches()) {
                    errors.put("date", this.i18n.text("year_month_day", new Object[0]));
                }
            } else if (this.datatype.indexOf("#time") > -1) {
                if (!this.timePattern.matcher(literalValue).matches()) {
                    errors.put("time", this.i18n.text("minimum_hour", new Object[0]));
                }
            } else if (this.datatype.indexOf("#gYearMonth") > -1) {
                if (!this.ymPattern.matcher(literalValue).matches()) {
                    errors.put("yearMonth", this.i18n.text("year_month", new Object[0]));
                }
            } else if (this.datatype.indexOf("#gYear") > -1) {
                if (!this.yearPattern.matcher(literalValue).matches()) {
                    errors.put("year", this.i18n.text("four_digit_year", new Object[0]));
                }
            } else if (this.datatype.indexOf("#float") > -1) {
                if (!this.floatPattern.matcher(literalValue).matches()) {
                    errors.put("float", this.i18n.text("decimal_only", new Object[0]));
                }
            } else if (this.datatype.indexOf("#int") > -1 && !this.intPattern.matcher(literalValue).matches()) {
                errors.put("integer", this.i18n.text("whole_number", new Object[0]));
            }
        } else {
            return null;
        }
        return errors.size() != 0 ? errors : null;
    }
}

