/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.rel18;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockedOntModel;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class FauxPropertiesUpdater {
    private static final String[] PATH_TO_PROPERTY_CONFIG = new String[]{"rdf", "display", "firsttime", "PropertyConfig.n3"};
    private static final Resource DISPLAY_MODEL = ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata");
    private static final Property UPDATED_DISPLAY_MODEL = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#updatedDisplayModel");
    private static final Literal VERSION_1_8 = ResourceFactory.createPlainLiteral((String)"1.8");
    private final ServletContextListener parent;
    private final StartupStatus ss;
    private final LockableOntModel lockableDisplayModel;
    private Path propertyConfigPath;

    public FauxPropertiesUpdater(ServletContext ctx, ServletContextListener parent) {
        this.parent = parent;
        this.ss = StartupStatus.getBean(ctx);
        this.lockableDisplayModel = new LockableOntModel(ModelAccess.on(ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata"));
    }

    public void migrate() {
        if (!this.isAlreadyUpdated() && this.locateFile() && this.loadFile()) {
            this.writeSuccess();
        }
    }

    private boolean isAlreadyUpdated() {
        try (LockedOntModel m = this.lockableDisplayModel.read();){
            boolean bl = m.contains(DISPLAY_MODEL, UPDATED_DISPLAY_MODEL, (RDFNode)VERSION_1_8);
            return bl;
        }
    }

    private boolean locateFile() {
        String homePath = ApplicationUtils.instance().getHomeDirectory().getPath().toString();
        this.propertyConfigPath = Paths.get(homePath, PATH_TO_PROPERTY_CONFIG);
        if (Files.exists(this.propertyConfigPath, new LinkOption[0])) {
            return true;
        }
        this.ss.warning(this.parent, "Could not find attributes for faux properties at " + this.propertyConfigPath);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFile() {
        try (LockedOntModel m = this.lockableDisplayModel.write();){
            m.read(new FileInputStream(this.propertyConfigPath.toFile()), null, "N3");
            this.ss.info(this.parent, "Read " + this.propertyConfigPath + " into display model: " + "attributes for faux properties.");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.ss.warning(this.parent, "Failed to read attributes for faux properties.", e);
            return false;
        }
    }

    private void writeSuccess() {
        try (LockedOntModel m = this.lockableDisplayModel.write();){
            m.add(DISPLAY_MODEL, UPDATED_DISPLAY_MODEL, (RDFNode)VERSION_1_8);
        }
    }
}

