/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.ontology.update;

import edu.cornell.mannlib.vitro.webapp.ontology.update.ABoxUpdater;
import edu.cornell.mannlib.vitro.webapp.ontology.update.AtomicOntologyChange;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeLogger;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeRecord;
import edu.cornell.mannlib.vitro.webapp.ontology.update.UpdateSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class TBoxUpdater {
    private static final Log log = LogFactory.getLog(TBoxUpdater.class);
    private UpdateSettings settings;
    private OntModel oldTboxAnnotationsModel;
    private OntModel newTboxAnnotationsModel;
    private OntModel siteModel;
    private ChangeLogger logger;
    private ChangeRecord record;
    private boolean detailLogs = false;
    private static final String classGroupURI = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#ClassGroup";
    private Resource classGroupClass = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createResource("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#ClassGroup");
    private static final String inClassGroupURI = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup";
    private Property inClassGroupProp = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup");

    public TBoxUpdater(UpdateSettings settings, ChangeLogger logger, ChangeRecord record) {
        this.settings = settings;
        this.oldTboxAnnotationsModel = settings.getOldTBoxAnnotationsModel();
        this.newTboxAnnotationsModel = settings.getNewTBoxAnnotationsModel();
        this.siteModel = settings.getAssertionOntModelSelector().getTBoxModel();
        this.logger = logger;
        this.record = record;
    }

    public void modifyPropertyQualifications() throws IOException {
    }

    public void updateDefaultAnnotationValues() throws IOException {
        this.updateDefaultAnnotationValues(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefaultAnnotationValues(String subjectURI) throws IOException {
        this.siteModel.enterCriticalSection(false);
        try {
            Model additions = ModelFactory.createDefaultModel();
            Model retractions = ModelFactory.createDefaultModel();
            if (this.oldTboxAnnotationsModel == null) {
                this.logger.log("oldTboxAnnotationModel is null; aborting update of annotation values");
                return;
            }
            Resource subj = subjectURI == null ? null : ResourceFactory.createResource((String)subjectURI);
            StmtIterator iter = this.oldTboxAnnotationsModel.listStatements(subj, null, (RDFNode)null);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                Resource subject = stmt.getSubject();
                Property predicate = stmt.getPredicate();
                RDFNode oldObject = stmt.getObject();
                if (!RDFS.getURI().equals(predicate.getNameSpace()) && !"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#".equals(predicate.getNameSpace())) continue;
                NodeIterator newObjects = this.newTboxAnnotationsModel.listObjectsOfProperty(subject, predicate);
                if (newObjects == null || !newObjects.hasNext()) {
                    RDFNode siteNode;
                    List siteObjects = this.siteModel.listObjectsOfProperty(subject, predicate).toList();
                    if (siteObjects.size() > 1) {
                        // empty if block
                    }
                    if (siteObjects.size() <= 0 || !(siteNode = (RDFNode)siteObjects.get(0)).equals(oldObject)) continue;
                    retractions.add(this.siteModel.listStatements(subject, predicate, (RDFNode)null));
                    continue;
                }
                RDFNode newObject = newObjects.next();
                int i = 1;
                while (newObjects.hasNext()) {
                    ++i;
                    newObjects.next();
                }
                if (i > 1) continue;
                NodeIterator siteObjects = this.siteModel.listObjectsOfProperty(subject, predicate);
                if (siteObjects == null || !siteObjects.hasNext()) {
                    try {
                        additions.add(subject, predicate, newObject);
                        if (!this.detailLogs) continue;
                        this.logger.log("adding Statement: subject = " + subject.getURI() + " property = " + predicate.getURI() + " object = " + (newObject.isLiteral() ? ((Literal)newObject).getLexicalForm() : ((Resource)newObject).getURI()));
                    }
                    catch (Exception e) {
                        this.logger.logError("Error trying to add statement with property " + predicate.getURI() + " of class = " + subject.getURI() + " in the knowledge base:\n" + e.getMessage());
                    }
                    continue;
                }
                if (newObject.equals(oldObject)) continue;
                RDFNode siteObject = siteObjects.next();
                i = 1;
                while (siteObjects.hasNext()) {
                    ++i;
                    siteObjects.next();
                }
                if (i > 1 || !siteObject.equals(oldObject)) continue;
                try {
                    StmtIterator it = this.siteModel.listStatements(subject, predicate, (RDFNode)null);
                    while (it.hasNext()) {
                        retractions.add((Statement)it.next());
                    }
                }
                catch (Exception e) {
                    this.logger.logError("Error removing statement for subject = " + subject.getURI() + "and property = " + predicate.getURI() + "from the knowledge base:\n" + e.getMessage());
                }
                try {
                    additions.add(subject, predicate, newObject);
                    if (!this.detailLogs) continue;
                    this.logger.log("Changed the value of property " + predicate.getURI() + " of subject = " + subject.getURI() + " from " + (oldObject.isResource() ? ((Resource)oldObject).getURI() : ((Literal)oldObject).getLexicalForm()) + " to " + (newObject.isResource() ? ((Resource)newObject).getURI() : ((Literal)newObject).getLexicalForm()) + " in the knowledge base:\n");
                }
                catch (Exception e) {
                    this.logger.logError("Error trying to change the value of property " + predicate.getURI() + " of class = " + subject.getURI() + " in the knowledge base:\n" + e.getMessage());
                }
            }
            Model actualAdditions = additions.difference(retractions);
            this.siteModel.add(actualAdditions);
            this.record.recordAdditions(actualAdditions);
            Model actualRetractions = retractions.difference(additions);
            this.siteModel.remove(actualRetractions);
            this.record.recordRetractions(actualRetractions);
            long numAdded = actualAdditions.size();
            long numRemoved = actualRetractions.size();
            if (numAdded > 0L) {
                this.logger.log("Updated the default vitro annotation value for " + numAdded + " statements in the knowledge base");
            }
            if (numRemoved > 0L) {
                this.logger.log("Removed " + numRemoved + " outdated vitro annotation property setting" + (numRemoved > 1L ? "s" : "") + " from the knowledge base");
            }
            Model newAnnotationSettings = this.newTboxAnnotationsModel.difference((Model)this.oldTboxAnnotationsModel);
            Model newAnnotationSettingsToAdd = ModelFactory.createDefaultModel();
            StmtIterator newStmtIt = newAnnotationSettings.listStatements();
            while (newStmtIt.hasNext()) {
                Statement stmt = (Statement)newStmtIt.next();
                if (this.siteModel.contains(stmt)) continue;
                newAnnotationSettingsToAdd.add(stmt);
                if (!this.detailLogs) continue;
                this.logger.log("adding Statement: subject = " + stmt.getSubject().getURI() + " property = " + stmt.getPredicate().getURI() + " object = " + (stmt.getObject().isLiteral() ? ((Literal)stmt.getObject()).getLexicalForm() : ((Resource)stmt.getObject()).getURI()));
            }
            this.siteModel.add(newAnnotationSettingsToAdd);
            this.record.recordAdditions(newAnnotationSettingsToAdd);
            if (newAnnotationSettingsToAdd.size() > 0L) {
                boolean plural = newAnnotationSettingsToAdd.size() > 1L;
                this.logger.log("Added " + newAnnotationSettingsToAdd.size() + " new annotation property setting" + (plural ? "s" : "") + " to the knowledge base. This includes only " + "existing annotation properties applied to existing classes where they weren't applied before, or existing " + "properties applied to new classes.");
            }
        }
        finally {
            this.siteModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnnotationModel() throws IOException {
        this.removeObsoleteAnnotations();
        this.siteModel.enterCriticalSection(false);
        try {
            Model retractions = ModelFactory.createDefaultModel();
            StmtIterator iter = this.oldTboxAnnotationsModel.listStatements((Resource)null, RDF.type, (RDFNode)this.classGroupClass);
            while (iter.hasNext()) {
                Statement stmt = (Statement)iter.next();
                if (this.newTboxAnnotationsModel.contains(stmt) || this.usesGroup((Model)this.siteModel, stmt.getSubject())) continue;
                long pre = retractions.size();
                retractions.add(this.siteModel.listStatements(stmt.getSubject(), (Property)null, (RDFNode)null));
                long post = retractions.size();
                if (post - pre <= 0L) continue;
                this.logger.log("Removed the " + stmt.getSubject().getURI() + " ClassGroup from the annotations model");
            }
            if (retractions.size() > 0L) {
                this.siteModel.remove(retractions);
                this.record.recordRetractions(retractions);
            }
        }
        finally {
            this.siteModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean usesGroup(Model model, Resource theClassGroup) throws IOException {
        model.enterCriticalSection(true);
        try {
            boolean bl = model.contains((Resource)null, this.inClassGroupProp, (RDFNode)theClassGroup);
            return bl;
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObsoleteAnnotations() throws IOException {
        Resource subj1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createResource("http://vivoweb.org/ontology/florida#StatewideGoalAndFocusArea");
        Resource obj1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createResource("http://vivoweb.org/ontology#vitroClassGrouptopics");
        Property subj2 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createProperty("http://vivoweb.org/ontology/florida#divisionOfSponsoredResearchNumber");
        Resource obj2 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createResource("http://vivoweb.org/ontology#vitroPropertyGroupidentifiers");
        Property subj3 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createProperty("http://vivoweb.org/ontology/florida#statewideGoalAndFocusArea");
        Resource obj3 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createResource("http://vivoweb.org/ontology#vitroPropertyGroupoutreach");
        Property inPropertyGroupProp = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inPropertyGroup");
        this.siteModel.enterCriticalSection(false);
        try {
            Model retractions = ModelFactory.createDefaultModel();
            if (this.siteModel.contains(subj1, this.inClassGroupProp, (RDFNode)obj1)) {
                retractions.add(subj1, this.inClassGroupProp, (RDFNode)obj1);
                this.logger.log("Removed statement " + ABoxUpdater.stmtString(subj1, this.inClassGroupProp, (RDFNode)obj1) + " from the knowledge base (assumed to be obsolete)");
            }
            if (this.siteModel.contains((Resource)subj2, inPropertyGroupProp, (RDFNode)obj2)) {
                retractions.add((Resource)subj2, inPropertyGroupProp, (RDFNode)obj2);
                this.logger.log("Removed statement " + ABoxUpdater.stmtString((Resource)subj2, inPropertyGroupProp, (RDFNode)obj2) + " from the knowledge base (assumed to be obsolete)");
            }
            if (this.siteModel.contains((Resource)subj3, inPropertyGroupProp, (RDFNode)obj3)) {
                retractions.add((Resource)subj3, inPropertyGroupProp, (RDFNode)obj3);
                this.logger.log("Removed statement " + ABoxUpdater.stmtString((Resource)subj3, inPropertyGroupProp, (RDFNode)obj3) + " from the knowledge base (assumed to be obsolete)");
            }
            if (retractions.size() > 0L) {
                this.siteModel.remove(retractions);
                this.record.recordRetractions(retractions);
            }
        }
        finally {
            this.siteModel.leaveCriticalSection();
        }
    }

    public void renameProperty(AtomicOntologyChange changeObj) throws IOException {
        if (changeObj.getNotes() != null && changeObj.getNotes().startsWith("cc:")) {
            this.mergePropertyAnnotationsToPropertyConfig(changeObj, (Model)this.siteModel);
        }
        Resource renamedProperty = this.siteModel.getResource(changeObj.getSourceURI());
        this.siteModel.removeAll(renamedProperty, null, (RDFNode)null);
        this.siteModel.removeAll(null, null, (RDFNode)renamedProperty);
    }

    private void mergePropertyAnnotationsToPropertyConfig(AtomicOntologyChange changeObj, Model userAnnotationsModel) throws IOException {
        String contextURI = "http://vitro.mannlib.cornell.edu/ns/vitro/siteConfig/" + changeObj.getNotes().substring(3);
        String oldPropertyURI = changeObj.getSourceURI();
        OntModel oldAnnotationsModel = this.settings.getOldTBoxAnnotationsModel();
        String propertyAnnotationsQuery = "PREFIX config: <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nCONSTRUCT { \n    <" + oldPropertyURI + "> <" + RDFS.label.getURI() + "> ?label . \n" + "    <" + oldPropertyURI + "> ?vitroProp ?vitroValue \n" + "} WHERE { \n" + "    { <" + oldPropertyURI + "> <" + RDFS.label.getURI() + "> ?label } \n" + "    UNION { <" + oldPropertyURI + "> ?vitroProp ?vitroValue  \n" + "    FILTER (regex(str(?vitroProp), \"" + "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#" + "\")) } \n" + "} \n";
        Model userAnnotations = this.construct(propertyAnnotationsQuery, userAnnotationsModel);
        Model oldAnnotations = this.construct(propertyAnnotationsQuery, (Model)oldAnnotationsModel);
        Model diff = userAnnotations.difference(oldAnnotations);
        Model valuesToMigrate = ModelFactory.createDefaultModel();
        StmtIterator sit = diff.listStatements();
        while (sit.hasNext()) {
            Statement stmt = sit.nextStatement();
            valuesToMigrate.add(userAnnotations.listStatements(null, stmt.getPredicate(), (RDFNode)null));
        }
        if (valuesToMigrate.size() == 0L) {
            return;
        }
        log.info((Object)("Updating PropertyConfig.n3 to include locally-changed settings from old property " + oldPropertyURI));
        String newQuery = "PREFIX config: <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nCONSTRUCT { \n    ?configuration config:propertyGroup ?group . \n    ?configuration config:displayName ?label . \n    ?configuration ?vitroProp ?vitroValue . \n} WHERE { \n    <" + contextURI + "> config:hasConfiguration ?configuration . \n" + "    OPTIONAL { <" + oldPropertyURI + "> vitro:inPropertyGroupAnnot ?group } \n" + "    OPTIONAL { <" + oldPropertyURI + "> <" + RDFS.label.getURI() + "> ?label } \n" + "    OPTIONAL { <" + oldPropertyURI + "> ?vitroProp ?vitroValue  \n" + "    FILTER (regex(str(?vitroProp), \"" + "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#" + "\")) } \n" + "} \n";
        String existingQuery = "PREFIX config: <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nCONSTRUCT { \n    ?configuration config:propertyGroup ?group . \n    ?configuration config:displayName ?label . \n    ?configuration ?vitroProp ?vitroValue . \n} WHERE { \n    <" + contextURI + "> config:hasConfiguration ?configuration . \n" + "    OPTIONAL { ?configuration config:propertyGroup ?group } \n" + "    OPTIONAL { ?configuration config:displayName ?label } \n" + "    OPTIONAL { ?configuration ?vitroProp ?vitroValue  \n" + "    FILTER (regex(str(?vitroProp), \"" + "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#" + "\")) } \n" + "} \n";
        Model configModel = ModelFactory.createDefaultModel();
        String configFileName = this.settings.getQualifiedPropertyConfigFile();
        File file = new File(configFileName);
        FileInputStream fis = new FileInputStream(file);
        configModel.read((InputStream)fis, null, "N3");
        Model userChangesUnion = ModelFactory.createUnion((Model)configModel, (Model)valuesToMigrate);
        Model userAnnotationsAsConfig = this.construct(newQuery, userChangesUnion);
        Model currentDefaultConfig = this.construct(existingQuery, configModel);
        Model additions = userAnnotationsAsConfig.difference(currentDefaultConfig);
        Model retractions = currentDefaultConfig.difference(userAnnotationsAsConfig);
        Model filteredRetractions = ModelFactory.createDefaultModel();
        StmtIterator retractIt = retractions.listStatements();
        while (retractIt.hasNext()) {
            Statement candidate = retractIt.nextStatement();
            if (!additions.contains(null, candidate.getPredicate(), (RDFNode)null)) continue;
            filteredRetractions.add(candidate);
        }
        if (additions.size() > 0L || filteredRetractions.size() > 0L) {
            configModel.remove(filteredRetractions);
            log.debug((Object)("Removing " + filteredRetractions.size() + " statements from " + contextURI));
            configModel.add(additions);
            log.debug((Object)("Adding " + additions.size() + " statements from " + contextURI));
            FileOutputStream fos = new FileOutputStream(file);
            configModel.write((OutputStream)fos, "N3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model construct(String queryStr, Model model) {
        Query query = QueryFactory.create((String)queryStr);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);){
            Model model2 = qe.execConstruct();
            return model2;
        }
    }
}

