/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingModel;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.Union;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.impl.OntModelImpl;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.impl.ModelCom;

public class VitroModelFactory {
    private static final Log log = LogFactory.getLog(VitroModelFactory.class);

    public static Model createModel() {
        return ModelFactory.createDefaultModel();
    }

    public static OntModel createOntologyModel() {
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    }

    public static OntModel createOntologyModel(Model model) {
        Graph graph = model.getGraph();
        ModelCom bareModel = new ModelCom(graph);
        OntModelImpl ontModel = new OntModelImpl(OntModelSpec.OWL_MEM, (Model)bareModel);
        return new BulkUpdatingOntModel((OntModel)ontModel);
    }

    public static Model createUnion(Model baseModel, Model plusModel) {
        Graph baseGraph = baseModel.getGraph();
        Graph plusGraph = plusModel.getGraph();
        BulkUpdatingUnion unionGraph = new BulkUpdatingUnion(baseGraph, plusGraph);
        Model unionModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        return new BulkUpdatingModel(unionModel, baseGraph);
    }

    public static OntModel createUnion(OntModel baseModel, OntModel plusModel) {
        Graph baseGraph = baseModel.getGraph();
        Graph plusGraph = plusModel.getGraph();
        BulkUpdatingUnion unionGraph = new BulkUpdatingUnion(baseGraph, plusGraph);
        Model unionModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        OntModel unionOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)unionModel);
        return new BulkUpdatingOntModel(unionOntModel, baseGraph);
    }

    public static Model createModelForGraph(Graph g) {
        return new BulkUpdatingModel(ModelFactory.createModelForGraph((Graph)g));
    }

    private static class BulkUpdatingUnion
    extends Union {
        public BulkUpdatingUnion(Graph L, Graph R) {
            super(L, R);
        }

        public String toString() {
            return "BulkUpdatingUnion[" + ToString.hashHex((Object)this) + ", L=" + ToString.graphToString(this.L) + ", R=" + ToString.graphToString(this.R) + "]";
        }
    }
}

