/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.SparqlUtils;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.VitroAjaxController;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.json.JSONArray;

public class DataAutocompleteController
extends VitroAjaxController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DataAutocompleteController.class);
    private static final String PARAM_QUERY = "term";
    private static final String PARAM_PROPERTY = "property";
    String NORESULT_MSG = "";
    private static final int DEFAULT_MAX_HIT_COUNT = 1000;
    public static final int MAX_QUERY_LENGTH = 500;

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.QUERY_FULL_MODEL.ACTION;
    }

    @Override
    protected void doRequest(VitroRequest vreq, HttpServletResponse response) throws IOException, ServletException {
        try {
            String qtxt = vreq.getParameter(PARAM_QUERY);
            String property = vreq.getParameter(PARAM_PROPERTY);
            String sparqlQuery = this.getSparqlQuery(qtxt, property);
            Model model = this.getModel(vreq);
            Query query = SparqlUtils.createQuery(sparqlQuery);
            this.outputResults(response, query, model);
            return;
        }
        catch (SparqlUtils.AjaxControllerException ex) {
            log.error((Object)ex, (Throwable)ex);
            response.sendError(ex.getStatusCode());
        }
        catch (Throwable e) {
            log.error((Object)e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputResults(HttpServletResponse response, Query query, Model model) throws IOException {
        Dataset dataset = DatasetFactory.create((Model)model);
        ArrayList<String> outputResults = new ArrayList<String>();
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Dataset)dataset);){
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Literal dataLiteral = qs.getLiteral("dataLiteral");
                String dataValue = dataLiteral.getString();
                outputResults.add(dataValue);
            }
            JSONArray jsonArray = new JSONArray(outputResults);
            try {
                response.getWriter().write(jsonArray.toString());
            }
            catch (Throwable e) {
                log.error((Object)e, e);
                this.doSearchError(response);
            }
        }
    }

    private Model getModel(VitroRequest vreq) throws SparqlUtils.AjaxControllerException {
        OntModel model = vreq.getJenaOntModel();
        if (model == null) {
            throw new SparqlUtils.AjaxControllerException(500, "Model '' not found.");
        }
        return model;
    }

    private String getSparqlQuery(String qtxt, String property) {
        String query = "SELECT DISTINCT ?dataLiteral where {?s <" + property + "> ?dataLiteral . " + "FILTER(regex(str(?dataLiteral), \"^" + qtxt + "\", \"i\")) } ORDER BY ?dataLiteral";
        return query;
    }

    private void doSearchError(HttpServletResponse response) throws IOException {
        this.doNoSearchResults(response);
    }

    private void doNoSearchResults(HttpServletResponse response) throws IOException {
        response.getWriter().write("[]");
    }
}

