/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.datasource;

import com.google.gson.JsonObject;
import org.linkeddatafragments.datasource.DataSourceTypesRegistry;
import org.linkeddatafragments.datasource.IDataSource;
import org.linkeddatafragments.datasource.IDataSourceType;
import org.linkeddatafragments.exceptions.DataSourceCreationException;
import org.linkeddatafragments.exceptions.UnknownDataSourceTypeException;

public class DataSourceFactory {
    public static IDataSource create(JsonObject config) throws DataSourceCreationException {
        String title = config.getAsJsonPrimitive("title").getAsString();
        String description = config.getAsJsonPrimitive("description").getAsString();
        String typeName = config.getAsJsonPrimitive("type").getAsString();
        JsonObject settings = config.getAsJsonObject("settings");
        IDataSourceType type = DataSourceTypesRegistry.getType(typeName);
        if (type == null) {
            throw new UnknownDataSourceTypeException(typeName);
        }
        return type.createDataSource(title, description, settings);
    }
}

