/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import com.ibm.icu.text.SimpleDateFormat;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.config.RevisionInfoBean;
import edu.cornell.mannlib.vitro.webapp.config.RevisionInfoSetup;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class RevisionInfoSetupTest
extends AbstractTestClass {
    private ServletContextStub context;
    private HttpSessionStub session;
    private ServletContextListener listener;
    private ServletContextEvent event;

    @Before
    public void setupContext() {
        this.context = new ServletContextStub();
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.context);
        this.event = new ServletContextEvent((ServletContext)this.context);
    }

    @Before
    public void createContextListener() {
        this.listener = new RevisionInfoSetup();
    }

    @Before
    public void suppressInfoMessages() {
        RevisionInfoSetupTest.setLoggerLevel(RevisionInfoBean.class, Level.WARN);
    }

    @Before
    public void suppressMessagesFromStartupStatus() {
        RevisionInfoSetupTest.setLoggerLevel(StartupStatus.class, Level.OFF);
    }

    @Test
    public void noResourceFile() {
        RevisionInfoSetupTest.setLoggerLevel(RevisionInfoSetup.class, Level.OFF);
        this.testThisExpectedFailure("no resource", null);
    }

    @Test
    public void resourceFileIsEmpty() {
        RevisionInfoSetupTest.setLoggerLevel(RevisionInfoSetup.class, Level.OFF);
        this.testThisExpectedFailure("empty resource", "");
    }

    @Test
    public void resourceFileHasNoSignificantLines() {
        RevisionInfoSetupTest.setLoggerLevel(RevisionInfoSetup.class, Level.OFF);
        this.testThisExpectedFailure("no siginificant lines", "    \n    #   \n\n");
    }

    @Test
    public void resourceFileHasInvalidDateLine() {
        RevisionInfoSetupTest.setLoggerLevel(RevisionInfoSetup.class, Level.OFF);
        this.testThisExpectedFailure("invalid date line", "BOGUS DATE LINE\nname ~ release ~ revision");
    }

    @Test
    public void resourceFileHasInvalidLevelLine() {
        RevisionInfoSetupTest.setLoggerLevel(RevisionInfoSetup.class, Level.OFF);
        this.testThisExpectedFailure("invalid level line", "2010-02-13 23:55:00\nname ~ release ~revision");
    }

    @Test
    public void simpleSingleLevel() {
        this.testThisResourceFile("simple single level", "2010-02-13 23:55:00\nname ~ release ~ revision", this.bean(this.date("2010-02-13 23:55:00"), this.level("name", "release", "revision")));
    }

    @Test
    public void ignoreWhiteSpaceAroundDate() {
        this.testThisResourceFile("white space around date", "   1999-01-01 00:00:00    \nname ~ release ~ revision", this.bean(this.date("1999-01-01 00:00:00"), this.level("name", "release", "revision")));
    }

    @Test
    public void ignoreWhiteSpaceInLevelInfo() {
        this.testThisResourceFile("white space in level info", "2010-02-13 23:55:00\n   name   ~ release   ~   revision  ", this.bean(this.date("2010-02-13 23:55:00"), this.level("name", "release", "revision")));
    }

    @Test
    public void ignoreBlankLinesAndComments() {
        this.testThisResourceFile("ignore empty lines", "2010-02-13 23:55:00\n\n     \n   #   \nname ~ release ~ revision", this.bean(this.date("2010-02-13 23:55:00"), this.level("name", "release", "revision")));
    }

    @Test
    public void parseMultipleLevels() {
        this.testThisResourceFile("multiple levels", "2010-02-13 23:55:00\nname ~ release ~ revision\nname2 ~ release2 ~ revision2\n", this.bean(this.date("2010-02-13 23:55:00"), this.level("name", "release", "revision"), this.level("name2", "release2", "revision2")));
    }

    @Test
    public void parseNoLevels() {
        this.testThisResourceFile("no levels", "2010-02-13 23:55:00\n", this.bean(this.date("2010-02-13 23:55:00"), new RevisionInfoBean.LevelRevisionInfo[0]));
    }

    private RevisionInfoBean bean(Date date, RevisionInfoBean.LevelRevisionInfo ... levels) {
        return new RevisionInfoBean(date, Arrays.asList(levels));
    }

    private RevisionInfoBean.LevelRevisionInfo level(String name, String release, String revision) {
        return new RevisionInfoBean.LevelRevisionInfo(name, release, revision);
    }

    private Date date(String string) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't parse this date string: '" + string + "'");
        }
    }

    private void testThisResourceFile(String message, String fileContents, RevisionInfoBean expected) {
        this.context.setMockResource("/WEB-INF/resources/revisionInfo.txt", fileContents);
        this.listener.contextInitialized(this.event);
        Assert.assertEquals((String)message, (Object)expected, (Object)RevisionInfoBean.getBean((HttpSession)this.session));
    }

    private void testThisExpectedFailure(String message, String fileContents) {
        this.testThisResourceFile(message, fileContents, RevisionInfoBean.DUMMY_BEAN);
    }
}

