/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.vocabulary.XSD;
import org.junit.Assert;
import org.junit.Test;

public class PropertyInstanceDaoJenaTest {
    String isDependentRelation = " <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#stubObjectPropertyAnnot> \"true\"^^xsd:boolean .\n";
    String nosePropIsDependentRel = "<http://vitro.mannlib.cornell.edu/ns/vitro/0.7#stubObjectPropertyAnnot> rdf:type owl:AnnotationProperty .\n ex:hasNose " + this.isDependentRelation;
    String prefixesN3 = "@prefix vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> . \n@prefix xsd: <" + XSD.getURI() + "> . \n @prefix ex: <http://example.com/> . \n@prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> . \n@prefix owl:  <http://www.w3.org/2002/07/owl#> . \n";

    void printModels(Model expected, Model result) {
        System.out.println("Expected:");
        expected.write((OutputStream)System.out);
        System.out.println("Result:");
        result.write((OutputStream)System.out);
    }

    @Test
    public void testStmtNonForceDelete() {
        String n3 = this.prefixesN3 + " ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + " ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.add(model.listStatements());
        WebappDaoFactoryJena wdf = new WebappDaoFactoryJena(ontModel);
        wdf.getPropertyInstanceDao().deleteObjectPropertyStatement("http://example.com/bob", "http://example.com/hasNose", "http://example.com/nose1");
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        this.wipeOutModTime((Model)ontModel);
        boolean same = expectedModel.isIsomorphicWith(ontModel.getBaseModel());
        if (!same) {
            this.printModels(expectedModel, ontModel.getBaseModel());
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtSimpleForceDelete() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation;
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.add(model.listStatements());
        WebappDaoFactoryJena wdf = new WebappDaoFactoryJena(ontModel);
        wdf.getPropertyInstanceDao().deleteObjectPropertyStatement("http://example.com/bob", "http://example.com/hasNose", "http://example.com/nose1");
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        this.wipeOutModTime((Model)ontModel);
        boolean same = expectedModel.isIsomorphicWith(ontModel.getBaseModel());
        if (!same) {
            this.printModels(expectedModel, ontModel.getBaseModel());
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtForceDeleteWithLiterals() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.add(model.listStatements());
        WebappDaoFactoryJena wdf = new WebappDaoFactoryJena(ontModel);
        wdf.getPropertyInstanceDao().deleteObjectPropertyStatement("http://example.com/bob", "http://example.com/hasNose", "http://example.com/nose1");
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        this.wipeOutModTime((Model)ontModel);
        boolean same = expectedModel.isIsomorphicWith(ontModel.getBaseModel());
        if (!same) {
            this.printModels(expectedModel, ontModel.getBaseModel());
        }
        Assert.assertTrue((boolean)same);
    }

    void wipeOutModTime(Model model) {
        model.removeAll(null, model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#modTime"), null);
    }

    @Test
    public void testGetAllPossiblePropInstForIndividual() {
        String n3 = this.prefixesN3 + "ex:hasMold a owl:ObjectProperty . \nex:hasSpore a owl:ObjectProperty . \nex:hasFungus a owl:ObjectProperty . \nex:redHerring a owl:ObjectProperty . \nex:Person a owl:Class . \nex:Agent a owl:Class . \nex:Mold a owl:Class . \nex:Spore a owl:Class . \nex:Fungus a owl:Class . \nex:Organism a owl:Class . \nex:Mold rdfs:subClassOf ex:Organism . \nex:Spore rdfs:subClassOf ex:Organism . \nex:Fungus rdfs:subClassOf ex:Organism . \nex:Person rdfs:subClassOf ex:Agent . \nex:hasFungus rdfs:range ex:Fungus . \nex:hasFungus rdfs:domain ex:Agent . \nex:Agent rdfs:subClassOf [ a owl:Restriction ; \nowl:onProperty ex:hasMold ; \nowl:allValuesFrom ex:Organism ] . \nex:Person rdfs:subClassOf [ a owl:Restriction ; \nowl:onProperty ex:hasMold ; \nowl:allValuesFrom ex:Mold ] . \nex:Agent rdfs:subClassOf [ a owl:Restriction ; \nowl:onProperty ex:hasSpore ; \nowl:allValuesFrom ex:Organism ] . \nex:Person rdfs:subClassOf [ a owl:Restriction ; \nowl:onProperty ex:hasSpore ; \nowl:someValuesFrom ex:Spore ] . \nex:bob a ex:Person ; a ex:Agent . \n";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ontModel.read((Reader)new StringReader(n3), null, "N3");
        WebappDaoFactoryJena wadf = new WebappDaoFactoryJena(ontModel);
        Assert.assertEquals((long)4L, (long)wadf.getObjectPropertyDao().getAllObjectProperties().size());
        Assert.assertEquals((long)6L, (long)wadf.getVClassDao().getAllVclasses().size());
        Assert.assertNotNull((Object)wadf.getIndividualDao().getIndividualByURI("http://example.com/bob"));
        Collection pinsts = wadf.getPropertyInstanceDao().getAllPossiblePropInstForIndividual("http://example.com/bob");
        Assert.assertEquals((long)3L, (long)pinsts.size());
        HashMap<String, String> propToRange = new HashMap<String, String>();
        for (PropertyInstance pi : pinsts) {
            propToRange.put(pi.getPropertyURI(), pi.getRangeClassURI());
        }
        Assert.assertEquals((Object)"http://example.com/Mold", propToRange.get("http://example.com/hasMold"));
        Assert.assertEquals((Object)"http://example.com/Organism", propToRange.get("http://example.com/hasSpore"));
        Assert.assertEquals((Object)"http://example.com/Fungus", propToRange.get("http://example.com/hasFungus"));
    }
}

