/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.filestorage.FileServingHelper;
import javax.servlet.ServletContext;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesStub;
import stubs.javax.servlet.ServletContextStub;

public class FileServingHelperTest
extends AbstractTestClass {
    private static final String DEFAULT_NAMESPACE = "http://some.crazy.domain/individual/";
    private ServletContextStub ctx;

    @Before
    public void createConfigurationProperties() throws Exception {
        FileServingHelperTest.setLoggerLevel(ConfigurationProperties.class, Level.WARN);
        this.ctx = new ServletContextStub();
        ConfigurationPropertiesStub props = new ConfigurationPropertiesStub();
        props.setProperty("Vitro.defaultNamespace", DEFAULT_NAMESPACE);
        props.setBean(this.ctx);
    }

    @Test
    public void nullUri() {
        this.assertCorrectUrl(null, "somefilename.ext", null);
    }

    @Test
    public void nullFilename() {
        this.assertCorrectUrl("http://some.crazy.domain/individual/n4324", null, null);
    }

    @Test
    public void notInDefaultNamespace() {
        FileServingHelperTest.setLoggerLevel(FileServingHelper.class, Level.ERROR);
        this.assertCorrectUrl("notInTheNamespace", "somefilename.ext", "notInTheNamespace");
    }

    @Test
    public void inDefaultNamespaceNoTrailingSlash() {
        this.assertCorrectUrl("http://some.crazy.domain/individual/n4324", "somefilename.ext", "/file/n4324/somefilename.ext");
    }

    @Test
    public void inDefaultNamespaceTrailingSlash() {
        this.assertCorrectUrl("http://some.crazy.domain/individual/n4324/", "somefilename.ext", "/file/n4324/somefilename.ext");
    }

    private void assertCorrectUrl(String uri, String filename, String expected) {
        String actual = FileServingHelper.getBytestreamAliasUrl((String)uri, (String)filename, (ServletContext)this.ctx);
        Assert.assertEquals((String)"url", (Object)expected, (Object)actual);
    }
}

