/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.search.controller.PagedSearchController;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.i18n.I18nStub;

public class PagedSearchControllerTest {
    @Before
    public void useI18nStubBundles() {
        I18nStub.setup();
    }

    @Test
    public void testGetPagingLinks() {
        UrlBuilder.ParamMap pm = new UrlBuilder.ParamMap();
        int hitsPerPage = 25;
        int totalHits = 500;
        int currentStartIndex = 0;
        List pageLinks = PagedSearchController.getPagingLinks((int)currentStartIndex, (int)hitsPerPage, (long)totalHits, (String)"baseURL", (UrlBuilder.ParamMap)pm, null);
        Assert.assertNotNull((Object)pageLinks);
        Assert.assertEquals((long)20L, (long)pageLinks.size());
        hitsPerPage = 25;
        totalHits = 10;
        currentStartIndex = 0;
        pageLinks = PagedSearchController.getPagingLinks((int)currentStartIndex, (int)hitsPerPage, (long)totalHits, (String)"baseURL", (UrlBuilder.ParamMap)pm, null);
        Assert.assertNotNull((Object)pageLinks);
        Assert.assertEquals((long)0L, (long)pageLinks.size());
    }

    @Test
    public void testGetPagingLinksForLargeResults() {
        UrlBuilder.ParamMap pm = new UrlBuilder.ParamMap();
        int hitsPerPage = 25;
        int totalHits = 349909;
        int currentStartIndex = 0;
        List pageLinks = PagedSearchController.getPagingLinks((int)currentStartIndex, (int)hitsPerPage, (long)totalHits, (String)"baseURL", (UrlBuilder.ParamMap)pm, null);
        Assert.assertNotNull((Object)pageLinks);
        Assert.assertEquals((long)(1000 / hitsPerPage), (long)pageLinks.size());
        hitsPerPage = 25;
        totalHits = 21329;
        currentStartIndex = 6432;
        pageLinks = PagedSearchController.getPagingLinks((int)currentStartIndex, (int)hitsPerPage, (long)totalHits, (String)"baseURL", (UrlBuilder.ParamMap)pm, null);
        Assert.assertNotNull((Object)pageLinks);
        Assert.assertEquals((long)(currentStartIndex / hitsPerPage + 1000 / hitsPerPage + 1), (long)pageLinks.size());
    }
}

