/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.searchengine;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.AutoCompleteWords;
import org.junit.Assert;
import org.junit.Test;

public class AutoCompleteWordsTest
extends AbstractTestClass {
    private static final String WORD_DELIMITER = "[, ]+";
    private static final String FIELD_NAME_COMPLETE = "complete";
    private static final String FIELD_NAME_PARTIAL = "partial";

    @Test
    public void nullSearchTerm() {
        this.assertQueryString(null, "");
    }

    @Test
    public void emptySearchTerm() {
        this.assertQueryString("", "");
    }

    @Test
    public void blankSearchTerm() {
        this.assertQueryString(" ", "");
    }

    @Test
    public void searchTermContainsOnlyCommas() {
        this.assertQueryString(",,", "");
    }

    @Test
    public void oneWord() {
        this.assertQueryString("first", "partial:\"first\"");
    }

    @Test
    public void twoWords() {
        this.assertQueryString("first, second", "complete:\"first\" AND partial:\"second\"");
    }

    @Test
    public void threeWords() {
        this.assertQueryString("first, second, third", "complete:\"first\" AND complete:\"second\" AND partial:\"third\"");
    }

    @Test
    public void oneWordAndComma() {
        this.assertQueryString("first,", "complete:\"first\"");
    }

    @Test
    public void oneWordAndCommaAndSpace() {
        this.assertQueryString("first, ", "complete:\"first\"");
    }

    @Test
    public void emptyCompleteWord() {
        this.assertQueryString(", second", "partial:\"second\"");
    }

    private void assertQueryString(String searchTerm, String expected) {
        AutoCompleteWords acw = new AutoCompleteWords(searchTerm, WORD_DELIMITER);
        String actual = acw.assembleQuery(FIELD_NAME_COMPLETE, FIELD_NAME_PARTIAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

