/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ModelSelectQueryContext;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ResultSetParser;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ResultSetParserTest
extends AbstractTestClass {
    private static final String NAMESPACE = "http://namespace#";
    private static final String SUBJECT = "http://namespace#subject";
    private static final String PREDICATE_URI = "http://namespace#uri";
    private static final String OBJECT_URI = "http://namespace#objectUri";
    private static final String OBJECT_URI_DEFAULT = "http://namespace#objectUriDefault";
    private static final String PREDICATE_ANON = "http://namespace#anonymous";
    private static final String OBJECT_ANON_DEFAULT = "http://namespace#anonDefault";
    private static final String PREDICATE_STRING = "http://namespace#string";
    private static final String OBJECT_STRING = "objectString";
    private static final String OBJECT_STRING_DEFAULT = "objectStringDefault";
    private static final String PREDICATE_INT = "http://namespace#int";
    private static final Integer OBJECT_INT = 4;
    private static final Integer OBJECT_INT_DEFAULT = -1;
    private static final String PREDICATE_LONG = "http://namespace#long";
    private static final Long OBJECT_LONG = 888L;
    private static final Long OBJECT_LONG_DEFAULT = -333L;
    private static final Object PARSING_FAILURE = "PARSING_FAILURE";
    private static final Object NO_RECORDS_FOUND = "NO_RECORDS_FOUND";
    private static final String SELECT_QUERY = "SELECT ?uri ?anonymous ?string ?int ?long \nWHERE { \n  ?s <http://namespace#uri> ?uri . \n  ?s <http://namespace#anonymous> ?anon . \n  ?s <http://namespace#string> ?string . \n  ?s <http://namespace#int> ?int . \n  ?s <http://namespace#long> ?long . \n} \n";
    private Model model;

    @Before
    public void setup() {
        ResultSetParserTest.setLoggerLevel(ModelSelectQueryContext.class, Level.OFF);
        this.model = ModelUtilitiesTestHelper.model(ModelUtilitiesTestHelper.objectProperty(SUBJECT, PREDICATE_URI, OBJECT_URI), ModelUtilitiesTestHelper.objectProperty(SUBJECT, PREDICATE_ANON), ModelUtilitiesTestHelper.dataProperty(SUBJECT, PREDICATE_STRING, OBJECT_STRING), ModelUtilitiesTestHelper.dataProperty(SUBJECT, PREDICATE_INT, OBJECT_INT, XSDDatatype.XSDinteger), ModelUtilitiesTestHelper.dataProperty(SUBJECT, PREDICATE_LONG, OBJECT_LONG, XSDDatatype.XSDlong));
    }

    @Test
    public void errorInParse_yieldsDefaultValue() {
        this.assertParsingResult(PARSING_FAILURE, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                throw new RuntimeException("I refuse to parse this!");
            }
        });
    }

    @Test
    public void expectedUriFoundUri() {
        this.assertParsingResult(OBJECT_URI, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifResourcePresent(solution, "uri", ResultSetParserTest.OBJECT_URI_DEFAULT);
            }
        });
    }

    @Test
    public void expectedUriFoundNothing_returnsDefault() {
        this.assertParsingResult(OBJECT_URI_DEFAULT, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifResourcePresent(solution, "nothing", ResultSetParserTest.OBJECT_URI_DEFAULT);
            }
        });
    }

    @Test
    @Ignore
    public void expectedUriFoundAnonymous_returnsDefault() {
        this.assertParsingResult(OBJECT_URI_DEFAULT, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifResourcePresent(solution, "anon", ResultSetParserTest.OBJECT_URI_DEFAULT);
            }
        });
    }

    @Test
    public void expectedUriFoundString_returnsDefault() {
        this.assertParsingResult(OBJECT_URI_DEFAULT, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifResourcePresent(solution, "string", ResultSetParserTest.OBJECT_URI_DEFAULT);
            }
        });
    }

    @Test
    public void expectedStringFoundString() {
        this.assertParsingResult(OBJECT_STRING, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLiteralPresent(solution, "string", ResultSetParserTest.OBJECT_STRING_DEFAULT);
            }
        });
    }

    @Test
    public void expectedStringFoundNothing_returnsDefault() {
        this.assertParsingResult(OBJECT_STRING_DEFAULT, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLiteralPresent(solution, "nothing", ResultSetParserTest.OBJECT_STRING_DEFAULT);
            }
        });
    }

    @Test
    public void expectedStringFoundResource_fails() {
        this.assertParsingResult(PARSING_FAILURE, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLiteralPresent(solution, "uri", ResultSetParserTest.OBJECT_STRING_DEFAULT);
            }
        });
    }

    @Test
    public void expectedStringFoundInt_returnsStringValueOfInt() {
        this.assertParsingResult(OBJECT_INT.toString(), new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLiteralPresent(solution, "int", ResultSetParserTest.OBJECT_STRING_DEFAULT);
            }
        });
    }

    @Test
    public void expectedIntFoundInt() {
        this.assertParsingResult(OBJECT_INT, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifIntPresent(solution, "int", OBJECT_INT_DEFAULT);
            }
        });
    }

    @Test
    public void expectedIntFoundNothing() {
        this.assertParsingResult(OBJECT_INT_DEFAULT, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifIntPresent(solution, "nothing", OBJECT_INT_DEFAULT);
            }
        });
    }

    @Test
    public void expectedIntFoundResource_fails() {
        this.assertParsingResult(PARSING_FAILURE, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifIntPresent(solution, "uri", OBJECT_INT_DEFAULT);
            }
        });
    }

    @Test
    public void expectedIntFoundString_fails() {
        this.assertParsingResult(PARSING_FAILURE, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifIntPresent(solution, "string", OBJECT_INT_DEFAULT);
            }
        });
    }

    @Test
    public void expectedIntFoundLong() {
        this.assertParsingResult(new Integer(OBJECT_LONG.intValue()), new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifIntPresent(solution, "long", OBJECT_INT_DEFAULT);
            }
        });
    }

    @Test
    public void expectedLongFoundLong() {
        this.assertParsingResult(OBJECT_LONG, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLongPresent(solution, "long", OBJECT_LONG_DEFAULT);
            }
        });
    }

    @Test
    public void expectedLongFoundNothing() {
        this.assertParsingResult(OBJECT_LONG_DEFAULT, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLongPresent(solution, "nothing", OBJECT_LONG_DEFAULT);
            }
        });
    }

    @Test
    public void expectedLongFoundResource_fails() {
        this.assertParsingResult(PARSING_FAILURE, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLongPresent(solution, "uri", OBJECT_LONG_DEFAULT);
            }
        });
    }

    @Test
    public void expectedLongFoundString_fails() {
        this.assertParsingResult(PARSING_FAILURE, new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLongPresent(solution, "string", OBJECT_LONG_DEFAULT);
            }
        });
    }

    @Test
    public void expectedLongFoundInt() {
        this.assertParsingResult(new Long(OBJECT_INT.intValue()), new BaseParser(){

            @Override
            Object parseOneLine(QuerySolution solution) {
                return this.ifLongPresent(solution, "int", OBJECT_LONG_DEFAULT);
            }
        });
    }

    private void assertParsingResult(Object expected, BaseParser parser) {
        Object actual = SparqlQueryRunner.createSelectQueryContext((Model)this.model, (String)SELECT_QUERY).execute().parse((ResultSetParser)parser);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static abstract class BaseParser
    extends ResultSetParser<Object> {
        private BaseParser() {
        }

        protected Object defaultValue() {
            return PARSING_FAILURE;
        }

        protected Object parseResults(String queryStr, ResultSet results) {
            if (results.hasNext()) {
                return this.parseOneLine(results.next());
            }
            return NO_RECORDS_FOUND;
        }

        abstract Object parseOneLine(QuerySolution var1);
    }
}

