/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web;

import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualController;
import edu.cornell.mannlib.vitro.webapp.web.ContentType;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ContentTypeTest {
    @Test
    public void typeAndQTest1() {
        Map map = ContentType.getTypesAndQ((String)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8,application/rdf+xml;q=0.93,text/rdf+n3;q=0.5");
        Assert.assertEquals((float)1.0f, (float)((Float)map.get("text/html")).floatValue(), (float)0.01f);
        Assert.assertEquals((float)1.0f, (float)((Float)map.get("application/xhtml+xml")).floatValue(), (float)0.01f);
        Assert.assertEquals((float)0.9f, (float)((Float)map.get("application/xml")).floatValue(), (float)0.01f);
        Assert.assertEquals((float)0.93f, (float)((Float)map.get("application/rdf+xml")).floatValue(), (float)0.01f);
        Assert.assertEquals((float)0.5f, (float)((Float)map.get("text/rdf+n3")).floatValue(), (float)0.01f);
        Assert.assertEquals((float)0.8f, (float)((Float)map.get("*/*")).floatValue(), (float)0.01f);
    }

    @Test
    public void typeAndQTest2() {
        Map map = ContentType.getTypesAndQ((String)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        Assert.assertEquals((float)1.0f, (float)((Float)map.get("text/html")).floatValue(), (float)0.01f);
        Assert.assertEquals((float)1.0f, (float)((Float)map.get("application/xhtml+xml")).floatValue(), (float)0.01f);
        Assert.assertEquals((float)0.9f, (float)((Float)map.get("application/xml")).floatValue(), (float)0.01f);
        Assert.assertEquals((float)0.8f, (float)((Float)map.get("*/*")).floatValue(), (float)0.01f);
    }

    @Test
    public void testWeightedBestContentTypeForTabulator() {
        Map clientAccepts = ContentType.getTypesAndQ((String)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8,application/rdf+xml;q=0.93,text/rdf+n3;q=0.5");
        Map serverTypes = IndividualController.ACCEPTED_CONTENT_TYPES;
        Assert.assertEquals((Object)"application/rdf+xml", (Object)ContentType.getBestContentType((Map)clientAccepts, (Map)serverTypes));
    }

    @Test
    public void testWeightedBestContentTypeForFirefox() {
        Map clientAccepts = ContentType.getTypesAndQ((String)"text/html;q=0.95,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        Map serverTypes = IndividualController.ACCEPTED_CONTENT_TYPES;
        Assert.assertEquals((Object)"application/xhtml+xml", (Object)ContentType.getBestContentType((Map)clientAccepts, (Map)serverTypes));
    }
}

