/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.IsRootUser;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RootUserPolicy
implements PolicyIface {
    private static final Log log = LogFactory.getLog(RootUserPolicy.class);
    private static final String PROPERTY_ROOT_USER_EMAIL = "rootUser.emailAddress";
    private static final String ROOT_USER_INITIAL_PASSWORD = "rootPassword";

    @Override
    public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
        if (IsRootUser.isRootUser(whoToAuth)) {
            return new BasicPolicyDecision(Authorization.AUTHORIZED, "RootUserPolicy: approved");
        }
        return new BasicPolicyDecision(Authorization.INCONCLUSIVE, "not root user");
    }

    public String toString() {
        return "RootUserPolicy - " + this.hashCode();
    }

    public static class Setup
    implements ServletContextListener {
        private ServletContext ctx;
        private StartupStatus ss;
        private UserAccountsDao uaDao;
        private ConfigurationProperties cp;
        private String configuredRootUser;
        private boolean configuredRootUserExists;
        private TreeSet<String> otherRootUsers;

        public void contextInitialized(ServletContextEvent sce) {
            this.ctx = sce.getServletContext();
            this.ss = StartupStatus.getBean(this.ctx);
            this.cp = ConfigurationProperties.getBean(this.ctx);
            try {
                this.uaDao = ModelAccess.on(this.ctx).getWebappDaoFactory().getUserAccountsDao();
                this.configuredRootUser = this.getRootEmailFromConfig();
                this.otherRootUsers = this.getEmailsOfAllRootUsers();
                this.configuredRootUserExists = this.otherRootUsers.remove(this.configuredRootUser);
                if (this.configuredRootUserExists) {
                    if (this.otherRootUsers.isEmpty()) {
                        this.informThatRootUserExists();
                    } else {
                        this.complainAboutMultipleRootUsers();
                    }
                } else {
                    this.createRootUser();
                    if (!this.otherRootUsers.isEmpty()) {
                        this.complainAboutWrongRootUsers();
                    }
                }
                ServletPolicyList.addPolicy(this.ctx, new RootUserPolicy());
            }
            catch (Exception e) {
                this.ss.fatal(this, "Failed to set up the RootUserPolicy", e);
            }
        }

        private String getRootEmailFromConfig() {
            String email = ConfigurationProperties.getBean(this.ctx).getProperty(RootUserPolicy.PROPERTY_ROOT_USER_EMAIL);
            if (email == null) {
                throw new IllegalStateException("runtime.properties must contain a value for 'rootUser.emailAddress'");
            }
            return email;
        }

        private TreeSet<String> getEmailsOfAllRootUsers() {
            TreeSet<String> rootUsers = new TreeSet<String>();
            for (UserAccount ua : this.uaDao.getAllUserAccounts()) {
                if (!ua.isRootUser()) continue;
                rootUsers.add(ua.getEmailAddress());
            }
            return rootUsers;
        }

        private void createRootUser() {
            if (!Authenticator.isValidEmailAddress(this.configuredRootUser)) {
                throw new IllegalStateException("Value for 'rootUser.emailAddress' is not a valid email address: '" + this.configuredRootUser + "'");
            }
            if (null != this.uaDao.getUserAccountByEmail(this.configuredRootUser)) {
                throw new IllegalStateException("Can't create root user - an account already exists with email address '" + this.configuredRootUser + "'");
            }
            UserAccount ua = new UserAccount();
            ua.setEmailAddress(this.configuredRootUser);
            ua.setFirstName("root");
            ua.setLastName("user");
            ua.setArgon2Password(Authenticator.applyArgon2iEncoding(RootUserPolicy.ROOT_USER_INITIAL_PASSWORD));
            ua.setMd5Password("");
            ua.setPasswordChangeRequired(true);
            ua.setStatus(UserAccount.Status.ACTIVE);
            ua.setRootUser(true);
            this.uaDao.insertUserAccount(ua);
            StartupStatus.getBean(this.ctx).info(this, "Created root user '" + this.configuredRootUser + "'");
        }

        private void informThatRootUserExists() {
            this.ss.info(this, "Root user is " + this.configuredRootUser);
        }

        private void complainAboutMultipleRootUsers() {
            for (String other : this.otherRootUsers) {
                this.ss.warning(this, "runtime.properties specifies '" + this.configuredRootUser + "' as the value for '" + RootUserPolicy.PROPERTY_ROOT_USER_EMAIL + "', but the system also contains this root user: " + other);
            }
            this.ss.warning(this, "For security, it is best to delete unneeded root user accounts.");
        }

        private void complainAboutWrongRootUsers() {
            for (String other : this.otherRootUsers) {
                this.ss.warning(this, "runtime.properties specifies '" + this.configuredRootUser + "' as the value for '" + RootUserPolicy.PROPERTY_ROOT_USER_EMAIL + "', but the system contains this root user instead: " + other);
            }
            this.ss.warning(this, "Creating root user '" + this.configuredRootUser + "'");
            this.ss.warning(this, "For security, it is best to delete unneeded root user accounts.");
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }
}

