/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsEditPage;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Message;

public abstract class UserAccountsEditPageStrategy
extends UserAccountsPage {
    protected final UserAccountsEditPage page;

    public static UserAccountsEditPageStrategy getInstance(VitroRequest vreq, UserAccountsEditPage page, boolean emailEnabled) {
        if (emailEnabled) {
            return new EmailStrategy(vreq, page);
        }
        return new NoEmailStrategy(vreq, page);
    }

    public UserAccountsEditPageStrategy(VitroRequest vreq, UserAccountsEditPage page) {
        super(vreq);
        this.page = page;
    }

    protected abstract void parseAdditionalParameters();

    protected abstract String additionalValidations();

    protected abstract void addMoreBodyValues(Map<String, Object> var1);

    protected abstract void setAdditionalProperties(UserAccount var1);

    protected abstract void notifyUser();

    protected abstract boolean wasPasswordEmailSent();

    private static class NoEmailStrategy
    extends UserAccountsEditPageStrategy {
        private static final String PARAMETER_NEW_PASSWORD = "newPassword";
        private static final String PARAMETER_CONFIRM_PASSWORD = "confirmPassword";
        private static final String ERROR_WRONG_PASSWORD_LENGTH = "errorPasswordIsWrongLength";
        private static final String ERROR_PASSWORDS_DONT_MATCH = "errorPasswordsDontMatch";
        private String newPassword;
        private String confirmPassword;

        public NoEmailStrategy(VitroRequest vreq, UserAccountsEditPage page) {
            super(vreq, page);
        }

        @Override
        protected void parseAdditionalParameters() {
            this.newPassword = this.getStringParameter(PARAMETER_NEW_PASSWORD, "");
            this.confirmPassword = this.getStringParameter(PARAMETER_CONFIRM_PASSWORD, "");
        }

        @Override
        protected String additionalValidations() {
            if (this.page.isExternalAuthOnly()) {
                return "";
            }
            if (this.newPassword.isEmpty() && this.confirmPassword.isEmpty()) {
                return "";
            }
            if (!this.checkPasswordLength(this.newPassword)) {
                return ERROR_WRONG_PASSWORD_LENGTH;
            }
            if (!this.newPassword.equals(this.confirmPassword)) {
                return ERROR_PASSWORDS_DONT_MATCH;
            }
            return "";
        }

        @Override
        protected void addMoreBodyValues(Map<String, Object> body) {
            body.put(PARAMETER_NEW_PASSWORD, this.newPassword);
            body.put(PARAMETER_CONFIRM_PASSWORD, this.confirmPassword);
            body.put("minimumLength", 6);
            body.put("maximumLength", 12);
        }

        @Override
        protected void setAdditionalProperties(UserAccount u) {
            if (!this.page.isExternalAuthOnly() && !this.newPassword.isEmpty()) {
                u.setArgon2Password(Authenticator.applyArgon2iEncoding(this.newPassword));
                u.setMd5Password("");
                u.setPasswordChangeRequired(true);
            }
        }

        @Override
        protected void notifyUser() {
        }

        @Override
        protected boolean wasPasswordEmailSent() {
            return false;
        }
    }

    private static class EmailStrategy
    extends UserAccountsEditPageStrategy {
        private static final String PARAMETER_RESET_PASSWORD = "resetPassword";
        private static final String EMAIL_TEMPLATE = "userAccounts-passwordResetPendingEmail.ftl";
        public static final String RESET_PASSWORD_URL = "/accounts/resetPassword";
        private boolean resetPassword;
        private boolean sentEmail;

        public EmailStrategy(VitroRequest vreq, UserAccountsEditPage page) {
            super(vreq, page);
        }

        @Override
        protected void parseAdditionalParameters() {
            this.resetPassword = this.isFlagOnRequest(PARAMETER_RESET_PASSWORD);
        }

        @Override
        protected String additionalValidations() {
            return "";
        }

        @Override
        protected void setAdditionalProperties(UserAccount u) {
            if (this.resetPassword && !this.page.isExternalAuthOnly()) {
                u.setPasswordLinkExpires(this.figureExpirationDate().getTime());
            }
        }

        @Override
        protected void addMoreBodyValues(Map<String, Object> body) {
            body.put("emailIsEnabled", Boolean.TRUE);
            if (this.resetPassword) {
                body.put(PARAMETER_RESET_PASSWORD, Boolean.TRUE);
            }
        }

        @Override
        protected void notifyUser() {
            if (!this.resetPassword) {
                return;
            }
            if (this.page.isExternalAuthOnly()) {
                return;
            }
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("userAccount", this.page.getUpdatedAccount());
            body.put("passwordLink", this.buildResetPasswordLink());
            body.put("siteName", this.getSiteName());
            FreemarkerEmailMessage email = FreemarkerEmailFactory.createNewMessage(this.vreq);
            email.addRecipient(Message.RecipientType.TO, this.page.getUpdatedAccount().getEmailAddress());
            email.setTemplate(EMAIL_TEMPLATE);
            email.setBodyMap(body);
            email.processTemplate();
            email.send();
            this.sentEmail = true;
        }

        private String buildResetPasswordLink() {
            try {
                String email = this.page.getUpdatedAccount().getEmailAddress();
                String hash = this.page.getUpdatedAccount().getPasswordLinkExpiresHash();
                String relativeUrl = UrlBuilder.getUrl(RESET_PASSWORD_URL, "user", email, "key", hash);
                URL context = new URL(this.vreq.getRequestURL().toString());
                URL url = new URL(context, relativeUrl);
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                return "error_creating_password_link";
            }
        }

        @Override
        protected boolean wasPasswordEmailSent() {
            return this.sentEmail;
        }
    }
}

