/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.forwarder.PageForwarder;
import edu.cornell.mannlib.vedit.forwarder.impl.UrlForwarder;
import edu.cornell.mannlib.vedit.listener.ChangeListener;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vedit.validator.impl.XMLNameValidator;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Classes2Classes;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.edit.utils.RoleLevelOptionsSetup;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="VclassRetryController", urlPatterns={"/vclass_retry"})
public class VclassRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)VclassRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        EditProcessObject epo = super.createEpo((HttpServletRequest)request);
        VClass testMask = new VClass();
        epo.setBeanClass(VClass.class);
        epo.setImplementationClass(VClass.class);
        epo.setBeanMask(testMask);
        String action = null;
        if (epo.getAction() == null) {
            action = "insert";
            epo.setAction("insert");
        } else {
            action = epo.getAction();
        }
        WebappDaoFactory wadf = ModelAccess.on(this.getServletContext()).getWebappDaoFactory();
        VClassDao vcwDao = wadf.getVClassDao();
        epo.setDataAccessObject(vcwDao);
        VClassGroupDao cgDao = wadf.getVClassGroupDao();
        OntologyDao oDao = wadf.getOntologyDao();
        VClass vclassForEditing = null;
        if (!epo.getUseRecycledBean()) {
            if (request.getParameter("uri") != null) {
                try {
                    vclassForEditing = vcwDao.getVClassByURI(request.getParameter("uri"));
                    action = "update";
                    epo.setAction("update");
                }
                catch (NullPointerException e) {
                    log.error((Object)"Need to implement 'record not found' error message.");
                }
            } else {
                vclassForEditing = new VClass();
                if (request.getParameter("GroupId") != null) {
                    vclassForEditing.setGroupURI(request.getParameter("GroupURI"));
                }
            }
            epo.setOriginalBean(vclassForEditing);
        } else {
            vclassForEditing = (VClass)epo.getNewBean();
        }
        Object[] simpleMaskPair = new Object[]{"URI", vclassForEditing.getURI()};
        epo.getSimpleMask().add(simpleMaskPair);
        ArrayList<XMLNameValidator> localNameValidatorList = new ArrayList<XMLNameValidator>();
        localNameValidatorList.add(new XMLNameValidator());
        epo.getValidatorMap().put("LocalName", localNameValidatorList);
        LinkedList<SubclassListener> changeListenerList = new LinkedList<SubclassListener>();
        if (request.getParameter("superclassUri") != null) {
            changeListenerList.add(new SubclassListener(request.getParameter("superclassUri"), request.getUnfilteredWebappDaoFactory()));
        }
        epo.setChangeListenerList(changeListenerList);
        epo.setPostInsertPageForwarder(new VclassInsertPageForwarder());
        epo.setPostDeletePageForwarder(new UrlForwarder("showClassHierarchy"));
        try {
            Class[] args = new Class[]{String.class};
            epo.setGetMethod(VClassDao.class.getDeclaredMethod("getVClassByURI", args));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)(this.getClass().getName() + " could not find the getVClassByURI method"));
        }
        HashMap<String, List<Option>> optionMap = new HashMap<String, List<Option>>();
        try {
            VClassGroupDao vcgDao = request.getUnfilteredWebappDaoFactory().getVClassGroupDao();
            List<Option> classGroupOptionList = FormUtils.makeOptionListFromBeans(vcgDao.getPublicGroupsWithVClasses(), "URI", "PublicName", vclassForEditing.getGroupURI(), null, vclassForEditing.getGroupURI() != null && !vclassForEditing.getGroupURI().equals(""));
            classGroupOptionList.add(0, new Option("", "none", "update".equals(action) && (vclassForEditing.getGroupURI() == null || vclassForEditing.getGroupURI().equals(""))));
            optionMap.put("GroupURI", classGroupOptionList);
        }
        catch (Exception e) {
            log.error((Object)"unable to create GroupId option list");
        }
        try {
            List<Option> namespaceIdList = action.equals("insert") ? FormUtils.makeOptionListFromBeans(oDao.getAllOntologies(), "URI", "Name", vclassForEditing.getNamespace() == null ? "" : vclassForEditing.getNamespace(), null, false) : FormUtils.makeOptionListFromBeans(oDao.getAllOntologies(), "URI", "Name", vclassForEditing.getNamespace() == null ? "" : vclassForEditing.getNamespace(), null, true);
            namespaceIdList.add(0, new Option(request.getUnfilteredWebappDaoFactory().getDefaultNamespace(), "default"));
            optionMap.put("Namespace", namespaceIdList);
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + "unable to create Namespace option list"));
        }
        optionMap.put("HiddenFromDisplayBelowRoleLevelUsingRoleUri", RoleLevelOptionsSetup.getDisplayOptionsList(vclassForEditing));
        optionMap.put("ProhibitedFromUpdateBelowRoleLevelUsingRoleUri", RoleLevelOptionsSetup.getUpdateOptionsList(vclassForEditing));
        optionMap.put("HiddenFromPublishBelowRoleLevelUsingRoleUri", RoleLevelOptionsSetup.getPublishOptionsList(vclassForEditing));
        FormObject foo = new FormObject();
        foo.setErrorMap(epo.getErrMsgMap());
        foo.setOptionLists(optionMap);
        epo.setFormObject(foo);
        request.setAttribute("formValue", foo.getValues());
        FormUtils.populateFormFromBean(vclassForEditing, action, foo, epo.getBadValueMap());
        request.setAttribute("formJsp", "/templates/edit/specific/vclass_retry.jsp");
        request.setAttribute("colspan", "4");
        request.setAttribute("scripts", "/templates/edit/formBasic.js");
        request.setAttribute("title", "Class Editing Form");
        request.setAttribute("_action", action);
        request.setAttribute("unqualifiedClassName", "VClass");
        this.setRequestAttributes((HttpServletRequest)request, epo);
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)"VclassRetryController could not forward to view.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    class VclassInsertPageForwarder
    implements PageForwarder {
        VclassInsertPageForwarder() {
        }

        @Override
        public void doForward(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) {
            String newVclassUrl = "vclassEdit?uri=";
            VClass vcl = (VClass)epo.getNewBean();
            try {
                newVclassUrl = newVclassUrl + URLEncoder.encode(vcl.getURI(), "UTF-8");
            }
            catch (Exception e) {
                log.error((Object)(this.getClass().getName() + " could not use UTF-8 encoding to encode new URL"));
            }
            try {
                response.sendRedirect(newVclassUrl);
            }
            catch (IOException ioe) {
                log.error((Object)"VclassInsertPageForwarder could not send redirect.");
            }
        }
    }

    class SubclassListener
    implements ChangeListener {
        String superclassURI = null;
        WebappDaoFactory daoFactory = null;

        public SubclassListener(String superclassURI, WebappDaoFactory cdf) {
            this.superclassURI = superclassURI;
            this.daoFactory = cdf;
        }

        @Override
        public void doInserted(Object newObj, EditProcessObject epo) {
            Classes2Classes c2c = new Classes2Classes();
            c2c.setSubclassURI(((VClass)newObj).getURI());
            c2c.setSuperclassURI(this.superclassURI);
            this.daoFactory.getVClassDao().insertNewClasses2Classes(c2c);
        }

        @Override
        public void doUpdated(Object oldObj, Object newObj, EditProcessObject epo) {
        }

        @Override
        public void doDeleted(Object oldObj, EditProcessObject epo) {
        }
    }
}

