/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualListQueryResults {
    private static final Log log = LogFactory.getLog(IndividualListQueryResults.class);
    private static final IndividualListQueryResults EMPTY_RESULT = new IndividualListQueryResults(0, new ArrayList<Individual>());
    private final int hitCount;
    private final List<Individual> individuals;

    public static IndividualListQueryResults runQuery(SearchQuery query, IndividualDao indDao) throws SearchEngineException {
        SearchEngine search = ApplicationUtils.instance().getSearchEngine();
        SearchResponse response = search.query(query);
        if (response == null) {
            log.debug((Object)"response from search query was null");
            return EMPTY_RESULT;
        }
        SearchResultDocumentList docs = response.getResults();
        if (docs == null) {
            log.debug((Object)"results from search query response was null");
            return EMPTY_RESULT;
        }
        long hitCount = docs.getNumFound();
        log.debug((Object)("Number of search results: " + hitCount));
        ArrayList<Individual> individuals = new ArrayList<Individual>(docs.size());
        for (SearchResultDocument doc : docs) {
            String uri = doc.getStringValue("URI");
            Individual individual = indDao.getIndividualByURI(uri);
            if (individual == null) {
                log.debug((Object)("No individual for search document with uri = " + uri));
                continue;
            }
            individuals.add(individual);
            log.debug((Object)("Adding individual " + uri + " to individual list"));
        }
        return new IndividualListQueryResults((int)hitCount, individuals);
    }

    public IndividualListQueryResults(int hitCount, List<Individual> individuals) {
        this.hitCount = hitCount;
        this.individuals = individuals;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public List<Individual> getIndividuals() {
        return this.individuals;
    }
}

