/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;

@WebServlet(name="ViewLabelsServlet", urlPatterns={"/viewLabels"})
public class ViewLabelsServlet
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ViewLabelsServlet.class.getName());
    private static String LABEL_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT DISTINCT ?label WHERE { \n    ?subject rdfs:label ?label \n} ORDER BY ?label";

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String subjectUri = vreq.getParameter("subjectUri");
        body.put("subjectUri", subjectUri);
        try {
            List<HashMap<String, String>> locales = this.getLocales(vreq);
            HashMap<String, String> localeCodeToNameMap = this.getFullCodeToLanguageNameMap(locales);
            ArrayList<Literal> existingLabels = this.getExistingLabels(subjectUri, vreq);
            HashMap<String, List<LabelInformation>> existingLabelsByLanguageName = this.getLabelsSortedByLanguageName(existingLabels, localeCodeToNameMap, vreq, subjectUri);
            HashSet<String> existingLanguageNames = new HashSet<String>(existingLabelsByLanguageName.keySet());
            body.put("labelsSortedByLanguageName", existingLabelsByLanguageName);
            Individual subject = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(subjectUri);
            if (subject != null && subject.getName() != null) {
                body.put("subjectName", subject.getName());
            } else {
                body.put("subjectName", null);
            }
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            return new ExceptionResponseValues(e);
        }
        String template = "viewLabelsForIndividual.ftl";
        return new TemplateResponseValues(template, body);
    }

    private HashMap<String, List<LabelInformation>> getLabelsSortedByLanguageName(List<Literal> labels, Map<String, String> localeCodeToNameMap, VitroRequest vreq, String subjectUri) {
        HashMap<String, List<LabelInformation>> labelsHash = new HashMap<String, List<LabelInformation>>();
        for (Literal l : labels) {
            String languageTag = l.getLanguage();
            String languageName = "";
            if (StringUtils.isEmpty((CharSequence)languageTag)) {
                languageName = "untyped";
            } else if (localeCodeToNameMap.containsKey(languageTag)) {
                languageName = localeCodeToNameMap.get(languageTag);
            } else {
                log.warn((Object)("This language tag " + languageTag + " does not have corresponding name in the system and was not processed"));
            }
            if (StringUtils.isEmpty((CharSequence)languageName)) continue;
            if (!labelsHash.containsKey(languageName)) {
                labelsHash.put(languageName, new ArrayList());
            }
            ArrayList labelsList = (ArrayList)labelsHash.get(languageName);
            labelsList.add(new LabelInformation(l, languageTag, languageName));
        }
        LabelInformationComparator lic = new LabelInformationComparator();
        for (String languageName : labelsHash.keySet()) {
            List<LabelInformation> labelInfo = labelsHash.get(languageName);
            labelInfo.sort(lic);
        }
        return labelsHash;
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public List<HashMap<String, String>> getLocales(VitroRequest vreq) {
        List<Locale> selectables = SelectedLocale.getSelectableLocales((HttpServletRequest)vreq);
        if (selectables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        Locale currentLocale = SelectedLocale.getCurrentLocale((HttpServletRequest)vreq);
        for (Locale locale : selectables) {
            try {
                list.add(this.buildLocaleMap(locale, currentLocale));
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Can't show the Locale selector for '" + locale + "': " + e));
            }
        }
        return list;
    }

    private HashMap<String, String> buildLocaleMap(Locale locale, Locale currentLocale) throws FileNotFoundException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", locale.toString().replace("_", "-"));
        map.put("label", locale.getDisplayName(currentLocale));
        return map;
    }

    public HashMap<String, String> getFullCodeToLanguageNameMap(List<HashMap<String, String>> localesList) {
        HashMap<String, String> codeToLanguageMap = new HashMap<String, String>();
        for (Map map : localesList) {
            String code = (String)map.get("code");
            String label = (String)map.get("label");
            if (!codeToLanguageMap.containsKey(code)) {
                codeToLanguageMap.put(code, label);
                continue;
            }
            log.warn((Object)("Language code " + code + " for " + label + " was not associated in map becayse label already exists"));
        }
        return codeToLanguageMap;
    }

    private ArrayList<Literal> getExistingLabels(String subjectUri, VitroRequest vreq) {
        String queryStr = QueryUtils.subUriForQueryVar(LABEL_QUERY, "subject", subjectUri);
        log.debug((Object)("queryStr = " + queryStr));
        ArrayList<Literal> labels = new ArrayList<Literal>();
        try {
            ResultSet results = QueryUtils.getLanguageNeutralQueryResults(queryStr, vreq);
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                Literal nodeLiteral = soln.get("label").asLiteral();
                labels.add(nodeLiteral);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return labels;
    }

    public class LabelInformation {
        private Literal labelLiteral = null;
        private String languageCode;
        private String languageName;

        public LabelInformation(Literal inputLiteral, String inputLanguageCode, String inputLanguageName) {
            this.labelLiteral = inputLiteral;
            this.languageCode = inputLanguageCode;
            this.languageName = inputLanguageName;
        }

        public Literal getLabelLiteral() {
            return this.labelLiteral;
        }

        public String getLabelStringValue() {
            return this.labelLiteral.getString();
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public String getLanguageName() {
            return this.languageName;
        }
    }

    public static class LabelInformationComparator
    implements Comparator<LabelInformation> {
        @Override
        public int compare(LabelInformation l1, LabelInformation l2) {
            return l1.getLabelStringValue().compareTo(l2.getLabelStringValue());
        }
    }
}

