/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.BaseFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.IndividualFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import edu.cornell.mannlib.vitro.webapp.edit.EditLiteral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.jga.algorithms.Filter;
import net.sf.jga.algorithms.Transform;
import net.sf.jga.fn.UnaryFunctor;

class IndividualDaoFiltering
extends BaseFiltering
implements IndividualDao {
    IndividualDao innerIndividualDao;
    VitroFilters filters;

    public IndividualDaoFiltering(IndividualDao individualDao, VitroFilters filters2) {
        this.innerIndividualDao = individualDao;
        this.filters = filters2;
    }

    protected List<Individual> filterAndWrap(Collection<Individual> cin, VitroFilters filters) {
        if (cin == null || cin.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList filteredList = new ArrayList();
        Filter.filter(cin, filters.getIndividualFilter(), filteredList);
        ArrayList<Individual> cout = new ArrayList<Individual>();
        for (Individual ind : filteredList) {
            cout.add(new IndividualFiltering(ind, filters));
        }
        return cout;
    }

    protected Iterator<Individual> filterAndWrap(Iterator<Individual> it, VitroFilters filters) {
        if (it == null) {
            return null;
        }
        if (filters == null) {
            return it;
        }
        return Transform.transform((Iterator)Filter.filter(it, filters.getIndividualFilter()), (UnaryFunctor)new ToFilteredIndividual(filters));
    }

    @Override
    public Individual getIndividualByURI(String individualURI) {
        Individual ind = this.innerIndividualDao.getIndividualByURI(individualURI);
        if (ind != null && ((Boolean)this.filters.getIndividualFilter().fn((Object)ind)).booleanValue()) {
            return new IndividualFiltering(ind, this.filters);
        }
        return null;
    }

    @Override
    public void fillVClassForIndividual(Individual individual) {
        this.innerIndividualDao.fillVClassForIndividual(individual);
    }

    @Override
    public List<Individual> getIndividualsByDataProperty(String dataPropertyUri, String value) {
        return this.filterAndWrap(this.innerIndividualDao.getIndividualsByDataProperty(dataPropertyUri, value), this.filters);
    }

    @Override
    public List<Individual> getIndividualsByDataProperty(String dataPropertyUri, String value, String datatypeUri, String lang) {
        return this.filterAndWrap(this.innerIndividualDao.getIndividualsByDataProperty(dataPropertyUri, value, datatypeUri, lang), this.filters);
    }

    public List getIndividualsByVClass(VClass vclass) {
        List<Individual> list = this.innerIndividualDao.getIndividualsByVClass(vclass);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return this.filterAndWrap(list, this.filters);
    }

    public List getIndividualsByVClassURI(String vclassURI) {
        List<Individual> list = this.innerIndividualDao.getIndividualsByVClassURI(vclassURI);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return this.filterAndWrap(list, this.filters);
    }

    public List getIndividualsByVClassURI(String vclassURI, int offset, int quantity) {
        List<Individual> list = this.innerIndividualDao.getIndividualsByVClassURI(vclassURI, offset, quantity);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return this.filterAndWrap(list, this.filters);
    }

    @Override
    public Collection<String> getAllIndividualUris() {
        return this.innerIndividualDao.getAllIndividualUris();
    }

    @Override
    public Iterator<String> getUpdatedSinceIterator(long updatedSince) {
        return this.innerIndividualDao.getUpdatedSinceIterator(updatedSince);
    }

    @Override
    public Collection<DataPropertyStatement> getExternalIds(String individualURI) {
        return this.innerIndividualDao.getExternalIds(individualURI);
    }

    @Override
    public Collection<DataPropertyStatement> getExternalIds(String individualURI, String dataPropertyURI) {
        return this.innerIndividualDao.getExternalIds(individualURI, dataPropertyURI);
    }

    @Override
    public int deleteIndividual(String individualURI) {
        return this.innerIndividualDao.deleteIndividual(individualURI);
    }

    @Override
    public int deleteIndividual(Individual individual) {
        return this.innerIndividualDao.deleteIndividual(individual);
    }

    public int getCountOfIndividualsInVClass(int vclassId) {
        throw new Error("IndividualDaoFiltering.getCountOfIndividualsInVClass is not supported");
    }

    @Override
    public void addVClass(String individualURI, String vclassURI) {
        this.innerIndividualDao.addVClass(individualURI, vclassURI);
    }

    @Override
    public void removeVClass(String individualURI, String vclassURI) {
        this.innerIndividualDao.removeVClass(individualURI, vclassURI);
    }

    @Override
    public String insertNewIndividual(Individual individual) throws InsertException {
        return this.innerIndividualDao.insertNewIndividual(individual);
    }

    @Override
    public int updateIndividual(Individual individual) {
        return this.innerIndividualDao.updateIndividual(individual);
    }

    @Override
    public void markModified(Individual individual) {
        this.innerIndividualDao.markModified(individual);
    }

    public String toString() {
        return "IndividualDaoFiltering filter: " + this.filters.getIndividualFilter().toString() + "\nInnerDao: " + this.innerIndividualDao.toString();
    }

    @Override
    public boolean isIndividualOfClass(String vclassURI, String indURI) {
        return this.innerIndividualDao.isIndividualOfClass(vclassURI, indURI);
    }

    @Override
    public String getUnusedURI(Individual individual) throws InsertException {
        return this.innerIndividualDao.getUnusedURI(individual);
    }

    @Override
    public EditLiteral getLabelEditLiteral(String individualUri) {
        return this.innerIndividualDao.getLabelEditLiteral(individualUri);
    }

    private class ToFilteredIndividual
    extends UnaryFunctor<Individual, Individual> {
        private final VitroFilters filters;

        public ToFilteredIndividual(VitroFilters vf) {
            this.filters = vf;
        }

        public Individual fn(Individual arg) {
            return new IndividualFiltering(arg, this.filters);
        }
    }
}

