/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.dao.ApplicationDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class ApplicationDaoJena
extends JenaBaseDao
implements ApplicationDao {
    private static final Property LINKED_NAMESPACE_PROP = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#linkedNamespace");
    Integer portalCount = null;
    List<String> externallyLinkedNamespaces = null;
    private static final boolean CLEAR_CACHE = true;

    public ApplicationDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    private String getApplicationResourceURI() {
        return this.DEFAULT_NAMESPACE + "portal" + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationBean getApplicationBean() {
        ApplicationBean application = new ApplicationBean();
        OntModel ontModel = this.getOntModelSelector().getApplicationMetadataModel();
        Individual appInd = ontModel.getIndividual(this.getApplicationResourceURI());
        if (appInd == null) {
            return application;
        }
        ontModel.enterCriticalSection(true);
        try {
            String appName = appInd.getLabel(null);
            if (appName != null) {
                application.setApplicationName(appName);
            }
            application.setAboutText(this.getPropertyStringValue((OntResource)appInd, (Property)this.APPLICATION_ABOUTTEXT));
            application.setAcknowledgeText(this.getPropertyStringValue((OntResource)appInd, (Property)this.APPLICATION_ACKNOWLEGETEXT));
            application.setContactMail(this.getPropertyStringValue((OntResource)appInd, (Property)this.APPLICATION_CONTACTMAIL));
            application.setCorrectionMail(this.getPropertyStringValue((OntResource)appInd, (Property)this.APPLICATION_CORRECTIONMAIL));
            application.setCopyrightAnchor(this.getPropertyStringValue((OntResource)appInd, (Property)this.APPLICATION_COPYRIGHTANCHOR));
            application.setCopyrightURL(this.getPropertyStringValue((OntResource)appInd, (Property)this.APPLICATION_COPYRIGHTURL));
            application.setThemeDir(this.getPropertyStringValue((OntResource)appInd, (Property)this.APPLICATION_THEMEDIR));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateApplicationBean(ApplicationBean application) {
        OntModel ontModel = this.getOntModelSelector().getApplicationMetadataModel();
        Individual appInd = ontModel.getIndividual(this.getApplicationResourceURI());
        if (appInd == null) {
            appInd = ontModel.createIndividual(this.getApplicationResourceURI(), (Resource)this.PORTAL);
        }
        ontModel.enterCriticalSection(false);
        try {
            appInd.setLabel(application.getApplicationName(), null);
            this.updatePropertyStringValue((Resource)appInd, (Property)this.APPLICATION_ABOUTTEXT, application.getAboutText(), (Model)ontModel);
            this.updatePropertyStringValue((Resource)appInd, (Property)this.APPLICATION_ACKNOWLEGETEXT, application.getAcknowledgeText(), (Model)ontModel);
            this.updatePropertyStringValue((Resource)appInd, (Property)this.APPLICATION_CONTACTMAIL, application.getContactMail(), (Model)ontModel);
            this.updatePropertyStringValue((Resource)appInd, (Property)this.APPLICATION_CORRECTIONMAIL, application.getCorrectionMail(), (Model)ontModel);
            this.updatePropertyStringValue((Resource)appInd, (Property)this.APPLICATION_COPYRIGHTANCHOR, application.getCopyrightAnchor(), (Model)ontModel);
            this.updatePropertyStringValue((Resource)appInd, (Property)this.APPLICATION_COPYRIGHTURL, application.getCopyrightURL(), (Model)ontModel);
            this.updatePropertyStringValue((Resource)appInd, (Property)this.APPLICATION_THEMEDIR, application.getThemeDir(), (Model)ontModel);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    public void close() {
    }

    @Override
    public synchronized List<String> getExternallyLinkedNamespaces() {
        return this.getExternallyLinkedNamespaces(false);
    }

    private synchronized List<String> getExternallyLinkedNamespaces(boolean clearCache) {
        if (clearCache || this.externallyLinkedNamespaces == null) {
            this.externallyLinkedNamespaces = new ArrayList<String>();
            OntModel ontModel = this.getOntModelSelector().getDisplayModel();
            NodeIterator nodes = ontModel.listObjectsOfProperty(LINKED_NAMESPACE_PROP);
            while (nodes.hasNext()) {
                RDFNode node = nodes.next();
                if (!node.isLiteral()) continue;
                String namespace = ((Literal)node).getLexicalForm();
                if (!namespace.endsWith("/")) {
                    namespace = namespace + "/";
                }
                this.externallyLinkedNamespaces.add(namespace);
            }
        }
        return this.externallyLinkedNamespaces;
    }

    @Override
    public boolean isExternallyLinkedNamespace(String namespace) {
        List<String> namespaces = this.getExternallyLinkedNamespaces();
        return namespaces.contains(namespace);
    }
}

