/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.jena.IndividualJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.IndividualCreationEvent;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.IndividualDeletionEvent;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.IndividualUpdateEvent;
import edu.cornell.mannlib.vitro.webapp.edit.EditLiteral;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.UnionClass;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class IndividualDaoJena
extends JenaBaseDao
implements IndividualDao {
    private Random random = new Random(System.currentTimeMillis());
    private static final Log log = LogFactory.getLog((String)IndividualDaoJena.class.getName());

    public IndividualDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    @Override
    public Collection<DataPropertyStatement> getExternalIds(String individualURI) {
        return this.getExternalIds(individualURI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DataPropertyStatement> getExternalIds(String individualURI, String dataPropertyURI) {
        ArrayList<DataPropertyStatement> externalIdStatements = new ArrayList<DataPropertyStatement>();
        edu.cornell.mannlib.vitro.webapp.beans.Individual ind = this.getIndividualByURI(individualURI);
        HashSet<String> externalIdPropURISet = new HashSet<String>();
        HashSet<String> nonExternalIdPropURISet = new HashSet<String>();
        if (ind != null) {
            Collection<DataPropertyStatement> dpsColl = this.getWebappDaoFactory().getDataPropertyStatementDao().getDataPropertyStatementsForIndividualByDataPropertyURI(ind, dataPropertyURI);
            for (DataPropertyStatement dps : dpsColl) {
                if (externalIdPropURISet.contains(dps.getDatapropURI())) {
                    externalIdStatements.add(dps);
                    continue;
                }
                if (nonExternalIdPropURISet.contains(dps.getDatapropURI())) continue;
                OntModel tboxOntModel = this.getOntModelSelector().getTBoxModel();
                tboxOntModel.enterCriticalSection(true);
                try {
                    Resource dataprop = tboxOntModel.getResource(dps.getDatapropURI());
                    if (dataprop != null && (tboxOntModel.contains(dataprop, (Property)this.DATAPROPERTY_ISEXTERNALID, (RDFNode)ResourceFactory.createTypedLiteral((Object)true)) || tboxOntModel.contains(dataprop, (Property)this.DATAPROPERTY_ISEXTERNALID, "TRUE"))) {
                        externalIdPropURISet.add(dps.getDatapropURI());
                        externalIdStatements.add(dps);
                        continue;
                    }
                    nonExternalIdPropURISet.add(dps.getDatapropURI());
                }
                finally {
                    tboxOntModel.leaveCriticalSection();
                }
            }
        }
        return externalIdStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVClass(String individualURI, String vclassURI) {
        OntModel ontModel = this.getOntModelSelector().getABoxModel();
        ontModel.enterCriticalSection(false);
        ontModel.getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, individualURI));
        try {
            Resource indRes = ontModel.getResource(individualURI);
            ontModel.add(indRes, RDF.type, (RDFNode)ontModel.getResource(vclassURI));
            this.updatePropertyDateTimeValue(indRes, (Property)this.MODTIME, Calendar.getInstance().getTime(), (Model)ontModel);
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, individualURI));
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVClass(String individualURI, String vclassURI) {
        OntModel ontModel = this.getOntModelSelector().getABoxModel();
        ontModel.enterCriticalSection(false);
        IndividualUpdateEvent event = new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, individualURI);
        ontModel.getBaseModel().notifyEvent((Object)event);
        try {
            Resource indRes = ontModel.getResource(individualURI);
            this.getOntModel().remove(indRes, RDF.type, (RDFNode)ontModel.getResource(vclassURI));
            this.updatePropertyDateTimeValue(indRes, (Property)this.MODTIME, Calendar.getInstance().getTime(), (Model)ontModel);
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, individualURI));
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.Individual> getIndividualsByVClass(VClass vclass) {
        return this.getIndividualsByVClassURI(vclass.getURI(), -1, -1);
    }

    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.Individual> getIndividualsByVClassURI(String vclassURI) {
        return this.getIndividualsByVClassURI(vclassURI, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.Individual> getIndividualsByVClassURI(String vclassURI, int offset, int quantity) {
        Resource theClass;
        if (vclassURI == null) {
            return null;
        }
        ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Individual> ents = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Individual>();
        Resource resource = theClass = vclassURI.indexOf(this.PSEUDO_BNODE_NS) == 0 ? this.getOntModel().createResource(new AnonId(vclassURI.split("#")[1])) : ResourceFactory.createResource((String)vclassURI);
        if (theClass.isAnon() && theClass.canAs(UnionClass.class)) {
            UnionClass u = (UnionClass)theClass.as(UnionClass.class);
            for (OntClass operand : u.listOperands().toList()) {
                VClassJena vc = new VClassJena(operand, this.getWebappDaoFactory());
                ents.addAll(this.getIndividualsByVClass(vc));
            }
        } else {
            OntModel ontModel = this.getOntModelSelector().getABoxModel();
            try {
                ontModel.enterCriticalSection(true);
                try (StmtIterator stmtIt = ontModel.listStatements((Resource)null, RDF.type, (RDFNode)theClass);){
                    while (stmtIt.hasNext()) {
                        Statement stmt = stmtIt.nextStatement();
                        OntResource ind = (OntResource)stmt.getSubject().as(OntResource.class);
                        ents.add(new IndividualJena(ind, this.getWebappDaoFactory()));
                    }
                }
            }
            finally {
                ontModel.leaveCriticalSection();
            }
        }
        Collections.sort(ents);
        return ents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountOfIndividualsInVClass(String vclassURI) {
        int count = 0;
        this.getOntModel().enterCriticalSection(true);
        try {
            OntClass cls = this.getOntModel().getOntClass(vclassURI);
            ExtendedIterator indIt = cls.listInstances();
            while (indIt.hasNext()) {
                ++count;
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return count;
    }

    @Override
    public String insertNewIndividual(edu.cornell.mannlib.vitro.webapp.beans.Individual ent) throws InsertException {
        return this.insertNewIndividualWebapp(ent);
    }

    public String insertNewIndividualWebapp(edu.cornell.mannlib.vitro.webapp.beans.Individual ent) throws InsertException {
        this.initInd(ent);
        return this.insertNewIndividual(ent, this.getOntModelSelector().getABoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertNewIndividual(edu.cornell.mannlib.vitro.webapp.beans.Individual ent, OntModel ontModel) throws InsertException {
        String preferredURI = this.getUnusedURI(ent);
        String entURI = null;
        Resource cls = ent.getVClassURI() != null ? ontModel.getResource(ent.getVClassURI()) : OWL.Thing;
        ontModel.enterCriticalSection(false);
        try {
            entURI = preferredURI;
            Individual test = ontModel.getIndividual(entURI);
            int count = 0;
            while (test != null) {
                entURI = preferredURI + ++count;
                test = ontModel.getIndividual(entURI);
            }
            try {
                List<VClass> vclasses;
                ontModel.getBaseModel().notifyEvent((Object)new IndividualCreationEvent(this.getWebappDaoFactory().getUserURI(), true, entURI));
                Individual ind = ontModel.createIndividual(entURI, cls);
                if (ent.getName() != null) {
                    ind.setLabel(ent.getName(), this.getDefaultLanguage());
                }
                if ((vclasses = ent.getVClasses(false)) != null) {
                    for (VClass vc : vclasses) {
                        ind.addRDFType(ResourceFactory.createResource((String)vc.getURI()));
                    }
                }
                this.addPropertyDateTimeValue((Resource)ind, (Property)this.MODTIME, Calendar.getInstance().getTime(), (Model)ontModel);
                if (ent.getMainImageUri() != null) {
                    this.addPropertyResourceURIValue((Resource)ind, this.IND_MAIN_IMAGE, ent.getMainImageUri());
                }
                if (ent.getSearchBoost() != null) {
                    this.addPropertyFloatValue((Resource)ind, (Property)this.SEARCH_BOOST_ANNOT, ent.getSearchBoost(), (Model)ontModel);
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception inserting individual: ", (Throwable)e);
            }
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new IndividualCreationEvent(this.getWebappDaoFactory().getUserURI(), false, entURI));
            ontModel.leaveCriticalSection();
        }
        return entURI;
    }

    @Override
    public int updateIndividual(edu.cornell.mannlib.vitro.webapp.beans.Individual ent) {
        return this.updateIndividualWebapp(ent);
    }

    public int updateIndividualWebapp(edu.cornell.mannlib.vitro.webapp.beans.Individual ent) {
        this.initInd(ent);
        return this.updateIndividual(ent, this.getOntModelSelector().getABoxModel());
    }

    private void initInd(edu.cornell.mannlib.vitro.webapp.beans.Individual ent) {
        ent.getClass();
        ent.getVClasses(false);
        ent.getDataPropertyList();
        ent.getDataPropertyStatements();
        ent.getExternalIds();
        ent.getMainImageUri();
        ent.getModTime();
        ent.getName();
        ent.getNamespace();
        ent.getObjectPropertyList();
        ent.getVClassURI();
        ent.getVClass();
        ent.getVClassURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateIndividual(edu.cornell.mannlib.vitro.webapp.beans.Individual ent, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            ontModel.getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, ent.getURI()));
            Individual ind = ontModel.getIndividual(ent.getURI());
            if (ind != null) {
                if (ent.getName() != null && (ind.getLabel(this.getDefaultLanguage()) == null || ind.getLabel(this.getDefaultLanguage()) != null && ent.getName() != null && !ent.getName().equals(ind.getLabel(this.getDefaultLanguage())))) {
                    Model temp = ModelFactory.createDefaultModel();
                    temp.add(ontModel.listStatements((Resource)ind, RDFS.label, (RDFNode)null));
                    ontModel.remove(temp);
                    ind.setLabel(ent.getName(), this.getDefaultLanguage());
                }
                HashSet<String> oldTypeURIsSet = new HashSet<String>();
                ExtendedIterator typeIt = ind.listRDFTypes(true);
                while (typeIt.hasNext()) {
                    Resource t = (Resource)typeIt.next();
                    if (t.getURI() == null) continue;
                    oldTypeURIsSet.add(t.getURI());
                }
                HashSet<String> newTypeURIsSet = new HashSet<String>();
                if (ent.getVClassURI() != null) {
                    newTypeURIsSet.add(ent.getVClassURI());
                }
                boolean conservativeTypeDeletion = false;
                try {
                    List<VClass> vcl = ent.getVClasses(false);
                    if (vcl == null) {
                        conservativeTypeDeletion = true;
                    } else {
                        for (VClass vc : vcl) {
                            newTypeURIsSet.add(vc.getURI());
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
                for (String uri : oldTypeURIsSet) {
                    if (newTypeURIsSet.contains(uri) || conservativeTypeDeletion && uri.indexOf("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#") != 0) continue;
                    ind.removeRDFType(ResourceFactory.createResource((String)uri));
                }
                for (String uri : newTypeURIsSet) {
                    if (oldTypeURIsSet.contains(uri)) continue;
                    ind.addRDFType(ResourceFactory.createResource((String)uri));
                }
                this.updatePropertyDateTimeValue((Resource)ind, (Property)this.MODTIME, Calendar.getInstance().getTime(), (Model)ontModel);
                this.updatePropertyResourceURIValue((Resource)ind, (Property)this.IND_MAIN_IMAGE, ent.getMainImageUri(), (Model)ontModel);
                if (ent.getSearchBoost() != null) {
                    this.updatePropertyFloatValue((Resource)ind, (Property)this.SEARCH_BOOST_ANNOT, ent.getSearchBoost(), (Model)ontModel);
                }
                int n = 0;
                return n;
            }
            int n = 1;
            return n;
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, ent.getURI()));
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void markModified(edu.cornell.mannlib.vitro.webapp.beans.Individual ind) {
        this.markModified(ind, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markModified(edu.cornell.mannlib.vitro.webapp.beans.Individual ind, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            Individual jind = ontModel.getIndividual(ind.getURI());
            if (jind != null) {
                this.updatePropertyDateTimeValue((Resource)jind, (Property)this.MODTIME, Calendar.getInstance().getTime(), (Model)ontModel);
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public int deleteIndividual(String URI2) {
        return this.deleteIndividual(URI2, this.getOntModelSelector().getABoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteIndividual(String URI2, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            if (URI2 == null) {
                log.debug((Object)"Cannot remove individual with null URI");
                int n = 1;
                return n;
            }
            ontModel.getBaseModel().notifyEvent((Object)new IndividualDeletionEvent(this.getWebappDaoFactory().getUserURI(), true, URI2));
            Resource res = ontModel.getResource(URI2);
            if (res == null) {
                log.error((Object)"Null resource returned from model");
                int n = 1;
                return n;
            }
            if (res.canAs(OntResource.class)) {
                OntResource ontRes = (OntResource)res.as(OntResource.class);
                this.smartRemove(ontRes, ontModel);
            } else {
                ontModel.removeAll(res, null, null);
                ontModel.removeAll(null, null, (RDFNode)res);
            }
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new IndividualDeletionEvent(this.getWebappDaoFactory().getUserURI(), false, URI2));
            ontModel.leaveCriticalSection();
        }
        return 0;
    }

    @Override
    public int deleteIndividual(edu.cornell.mannlib.vitro.webapp.beans.Individual ent) {
        return this.deleteIndividual(ent.getURI());
    }

    public int deleteIndividualWebapp(edu.cornell.mannlib.vitro.webapp.beans.Individual ent) {
        return this.deleteIndividual(ent.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public edu.cornell.mannlib.vitro.webapp.beans.Individual getIndividualByURI(String entityURI) {
        if (entityURI == null || entityURI.length() == 0) {
            return null;
        }
        OntModel ontModel = this.getOntModelSelector().getABoxModel();
        ontModel.enterCriticalSection(true);
        try {
            IndividualJena ent;
            OntResource ontRes = entityURI.startsWith("http://vitro.mannlib.cornell.edu/ns/bnode#") ? (OntResource)ontModel.createResource(new AnonId(entityURI.substring("http://vitro.mannlib.cornell.edu/ns/bnode#".length()))).as(OntResource.class) : ontModel.getOntResource(entityURI);
            IndividualJena individualJena = ent = new IndividualJena(ontRes, this.getWebappDaoFactory());
            return individualJena;
        }
        catch (Exception ex) {
            edu.cornell.mannlib.vitro.webapp.beans.Individual individual = null;
            return individual;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void fillVClassForIndividual(edu.cornell.mannlib.vitro.webapp.beans.Individual entity) {
        entity.setVClass(this.getWebappDaoFactory().getVClassDao().getVClassByURI(entity.getVClassURI()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.Individual> getIndividualsByDataProperty(String dataPropertyUri, String value) {
        Property prop = null;
        prop = RDFS.label.getURI().equals(dataPropertyUri) ? RDFS.label : this.getOntModel().getProperty(dataPropertyUri);
        if (prop == null) {
            log.debug((Object)("Could not getIndividualsByDataProperty() because " + dataPropertyUri + "was not found in model."));
            return Collections.emptyList();
        }
        if (value == null) {
            log.debug((Object)"Could not getIndividualsByDataProperty() because value was null");
            return Collections.emptyList();
        }
        Literal litv1 = this.getOntModel().createLiteral(value);
        Literal litv2 = this.getOntModel().createTypedLiteral(value);
        Literal litv3 = this.getOntModel().createLiteral(value, "EN");
        HashMap<String, IndividualJena> individualsMap = new HashMap<String, IndividualJena>();
        this.getOntModel().enterCriticalSection(true);
        int count = 0;
        try {
            Individual ind;
            String subUri;
            Literal literal;
            Object v;
            RDFNode obj;
            Resource sub;
            Statement stmt;
            StmtIterator stmts = this.getOntModel().listStatements((Resource)null, prop, (RDFNode)litv1);
            while (stmts.hasNext()) {
                ++count;
                stmt = stmts.nextStatement();
                sub = stmt.getSubject();
                if (sub == null || sub.isAnon() || sub.isLiteral() || (obj = stmt.getObject()) == null || !obj.isLiteral() || (v = (literal = (Literal)obj).getValue()) == null || individualsMap.containsKey(subUri = sub.getURI())) continue;
                ind = this.getOntModel().getIndividual(subUri);
                individualsMap.put(subUri, new IndividualJena((OntResource)ind, this.getWebappDaoFactory()));
            }
            stmts = this.getOntModel().listStatements((Resource)null, prop, (RDFNode)litv2);
            while (stmts.hasNext()) {
                ++count;
                stmt = stmts.nextStatement();
                sub = stmt.getSubject();
                if (sub == null || sub.isAnon() || sub.isLiteral() || (obj = stmt.getObject()) == null || !obj.isLiteral() || (v = (literal = (Literal)obj).getValue()) == null || individualsMap.containsKey(subUri = sub.getURI())) continue;
                ind = this.getOntModel().getIndividual(subUri);
                individualsMap.put(subUri, new IndividualJena((OntResource)ind, this.getWebappDaoFactory()));
            }
            stmts = this.getOntModel().listStatements((Resource)null, prop, (RDFNode)litv3);
            while (stmts.hasNext()) {
                ++count;
                stmt = stmts.nextStatement();
                sub = stmt.getSubject();
                if (sub == null || sub.isAnon() || sub.isLiteral() || (obj = stmt.getObject()) == null || !obj.isLiteral() || (v = (literal = (Literal)obj).getValue()) == null || individualsMap.containsKey(subUri = sub.getURI())) continue;
                ind = this.getOntModel().getIndividual(subUri);
                individualsMap.put(subUri, new IndividualJena((OntResource)ind, this.getWebappDaoFactory()));
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Individual> rv = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Individual>(individualsMap.size());
        rv.addAll(individualsMap.values());
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.Individual> getIndividualsByDataProperty(String dataPropertyUri, String value, String datatypeUri, String lang) {
        if (datatypeUri == null && lang == null) {
            return this.getIndividualsByDataProperty(dataPropertyUri, value);
        }
        Object prop = null;
        prop = RDFS.label.getURI().equals(dataPropertyUri) ? RDFS.label : this.getOntModel().getDatatypeProperty(dataPropertyUri);
        if (prop == null || value == null) {
            log.debug((Object)("Could not getIndividualsByDataProperty() because " + dataPropertyUri + "was not found in model."));
            return Collections.emptyList();
        }
        ResIterator stmts = null;
        ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Individual> inds = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.Individual>();
        Literal literal = null;
        literal = datatypeUri != null && datatypeUri.length() > 0 ? this.getOntModel().createTypedLiteral(value, datatypeUri) : (lang != null && lang.length() > 0 ? this.getOntModel().createLiteral(value, lang) : this.getOntModel().createLiteral(value));
        this.getOntModel().enterCriticalSection(true);
        try {
            stmts = this.getOntModel().listSubjectsWithProperty(prop, (RDFNode)literal);
            while (stmts.hasNext()) {
                Resource st = stmts.nextResource();
                if (st.getURI() == null) continue;
                Individual ind = this.getOntModel().getIndividual(st.getURI());
                inds.add(new IndividualJena((OntResource)ind, this.getWebappDaoFactory()));
            }
        }
        finally {
            if (stmts != null) {
                stmts.close();
            }
            this.getOntModel().leaveCriticalSection();
        }
        return inds;
    }

    @Override
    public Collection<String> getAllIndividualUris() {
        throw new NotImplementedException("");
    }

    @Override
    public Iterator<String> getUpdatedSinceIterator(long updatedSince) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean isIndividualOfClass(String vclassURI, String indURI) {
        if (vclassURI == null || indURI == null || "".equals(vclassURI) || "".equals(indURI)) {
            return false;
        }
        return this.getOntModel().contains(this.getOntModel().getResource(indURI), RDF.type, (RDFNode)this.getOntModel().getResource(vclassURI));
    }

    @Override
    public String getUnusedURI(edu.cornell.mannlib.vitro.webapp.beans.Individual individual) throws InsertException {
        String errMsg = null;
        String namespace = null;
        String uri = null;
        boolean uriIsGood = false;
        if (individual == null || individual.getURI() != null && individual.getURI().startsWith(this.DEFAULT_NAMESPACE) || individual.getNamespace() == null || individual.getNamespace().length() == 0 || this.DEFAULT_NAMESPACE.equals(individual.getNamespace())) {
            namespace = this.DEFAULT_NAMESPACE;
            uri = null;
            log.debug((Object)("Setting namespace to default namespace " + this.DEFAULT_NAMESPACE + " and uri is null"));
            log.debug((Object)("Individual : " + individual + " - URI: " + individual.getURI() + " - namespace -" + individual.getNamespace() + "- "));
        } else if (individual.getURI() != null) {
            errMsg = this.getWebappDaoFactory().checkURI(individual.getURI());
            if (errMsg != null) {
                throw new InsertException(errMsg);
            }
            uriIsGood = true;
            uri = individual.getURI();
            log.debug((Object)("Individual URI not null " + individual.getURI() + " and uriIsGood is true and uri set to individual uri"));
        } else {
            namespace = individual.getNamespace();
            if (namespace == null || namespace.length() == 0) {
                namespace = this.DEFAULT_NAMESPACE;
            }
            String localName = individual.getName();
            log.debug((Object)("Namespace " + namespace + " -localname=" + localName));
            if (localName != null) {
                log.debug((Object)"Local name not equal to null so replacing characters, etc.");
                localName = localName.replaceAll("\\W", "");
                localName = localName.replaceAll(":", "");
                if (localName.length() > 2) {
                    if (Character.isDigit(localName.charAt(0))) {
                        localName = "n" + localName;
                    }
                    uri = namespace + localName;
                    errMsg = this.getWebappDaoFactory().checkURI(uri);
                    if (errMsg != null) {
                        throw new InsertException(errMsg);
                    }
                    uriIsGood = true;
                    log.debug((Object)("uriIsGood is true and uri is " + uri));
                }
            }
        }
        for (int attempts = 0; !uriIsGood && attempts < 30; ++attempts) {
            log.debug((Object)("While loop: Uri is good false, attempt=" + attempts));
            String localName = "n" + this.random.nextInt(Math.min(Integer.MAX_VALUE, (int)Math.pow(2.0, attempts + 13)));
            uri = namespace + localName;
            log.debug((Object)("Trying URI " + uri));
            errMsg = this.getWebappDaoFactory().checkURI(uri);
            if (errMsg != null) {
                uri = null;
                continue;
            }
            uriIsGood = true;
        }
        if (uri == null) {
            throw new InsertException("Could not create URI for individual: " + errMsg);
        }
        log.debug((Object)("Using URI" + uri));
        return uri;
    }

    @Override
    public EditLiteral getLabelEditLiteral(String individualUri) {
        Literal literal = this.getLabelLiteral(individualUri);
        if (literal == null) {
            return null;
        }
        String value = literal.getLexicalForm();
        String datatype = literal.getDatatypeURI();
        String lang = literal.getLanguage();
        return new EditLiteral(value, datatype, lang);
    }
}

