/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DependentResourceDeleteJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.PropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.ProfileException;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ObjectPropertyDaoJena
extends PropertyDaoJena
implements ObjectPropertyDao {
    private static final Log log = LogFactory.getLog((String)ObjectPropertyDaoJena.class.getName());
    protected static final List<String> EXCLUDED_NAMESPACES = Arrays.asList(new String[0]);
    protected static final String PROPERTY_FILTERS;
    protected static final String OBJECT_PROPERTY_QUERY_STRING;
    protected static final String LIST_VIEW_CONFIG_FILE_QUERY_STRING = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nPREFIX config: <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nSELECT ?property ?range ?domain ?filename WHERE { \n    { ?property display:listViewConfigFile ?filename \n    } UNION { \n        ?configuration config:listViewConfigFile ?filename . \n         ?context config:hasConfiguration ?configuration . \n        ?context config:configContextFor ?property . \n        ?context config:qualifiedBy ?range . \n        OPTIONAL { ?context config:qualifiedByDomain ?domain } \n    } \n}";
    protected static Query listViewConfigFileQuery;
    Map<PropertyDao.FullPropertyKey, String> customListViewConfigFileMap;

    public ObjectPropertyDaoJena(RDFService rdfService, DatasetWrapperFactory dwf, Map<PropertyDao.FullPropertyKey, String> customListViewConfigFileMap, WebappDaoFactoryJena wadf) {
        super(rdfService, dwf, wadf);
        this.customListViewConfigFileMap = customListViewConfigFileMap;
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getTBoxModel();
    }

    @Override
    public void deleteObjectProperty(String propertyURI) {
        edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op = this.getObjectPropertyByURI(propertyURI);
        this.deleteObjectProperty(op);
    }

    @Override
    public void fillObjectPropertiesForIndividual(Individual entity) {
        if (entity == null) {
            return;
        }
        ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> props = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty>();
        props.addAll(this.getObjectPropertiesForObjectPropertyStatements(entity.getObjectPropertyStatements()));
        entity.setPropertyList(props);
    }

    protected edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty propertyFromOntProperty(OntProperty op) {
        if (op == null) {
            return null;
        }
        if (op instanceof DatatypeProperty) {
            return null;
        }
        edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty p = new edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty();
        try {
            p.setURI(op.getURI());
            p.setNamespace(op.getNameSpace());
            p.setLocalName(op.getLocalName());
            p.setLocalNameWithPrefix(this.getWebappDaoFactory().makeLocalNameWithPrefix(p));
            if (op.getLabel(null) != null) {
                p.setDomainPublic(this.getLabelOrId((OntResource)op));
            } else {
                p.setDomainPublic(op.getLocalName());
            }
            if (p.getDomainPublic() == null) {
                p.setDomainPublic("[related to]");
            }
            p.setPickListName(this.getWebappDaoFactory().makePickListName(p));
            if (op.getDomain() != null) {
                p.setDomainVClassURI(op.getDomain().isAnon() ? this.PSEUDO_BNODE_NS + op.getDomain().getId().toString() : op.getDomain().getURI());
            }
            if (op.getRange() != null) {
                p.setRangeVClassURI(op.getRange().isAnon() ? this.PSEUDO_BNODE_NS + op.getRange().getId().toString() : op.getRange().getURI());
            }
            OntProperty invOp = null;
            try {
                invOp = op.getInverse();
            }
            catch (ProfileException profileException) {
                // empty catch block
            }
            try {
                if (op.getSuperProperty() != null) {
                    p.setParentURI(op.getSuperProperty().getURI());
                }
            }
            catch (ConversionException ce) {
                Statement parentStmt;
                StmtIterator parentStmtIt = op.listProperties(RDFS.subPropertyOf);
                if (parentStmtIt.hasNext() && (parentStmt = parentStmtIt.nextStatement()).getObject().isResource()) {
                    p.setParentURI(((Resource)parentStmt.getObject()).getURI());
                }
                parentStmtIt.close();
            }
            if (invOp != null) {
                p.setURIInverse(invOp.getURI());
                p.setNamespaceInverse(invOp.getNameSpace());
                p.setLocalNameInverse(invOp.getLocalName());
                p.setRangePublic(this.getLabelOrId((OntResource)invOp));
            }
            try {
                if (op.isTransitiveProperty() || invOp != null && invOp.isTransitiveProperty()) {
                    p.setTransitive(true);
                }
            }
            catch (ProfileException ce) {
                // empty catch block
            }
            try {
                if (op.isSymmetricProperty() || invOp != null && invOp.isSymmetricProperty()) {
                    p.setSymmetric(true);
                }
            }
            catch (ProfileException ce) {
                // empty catch block
            }
            try {
                if (op.isFunctionalProperty()) {
                    p.setFunctional(true);
                }
            }
            catch (ProfileException ce) {
                // empty catch block
            }
            try {
                if (op.isInverseFunctionalProperty()) {
                    p.setInverseFunctional(true);
                }
            }
            catch (ProfileException ce) {
                // empty catch block
            }
            p.setExample(this.getPropertyStringValue((OntResource)op, (Property)this.EXAMPLE_ANNOT));
            p.setDescription(this.getPropertyStringValue((OntResource)op, (Property)this.DESCRIPTION_ANNOT));
            p.setPublicDescription(this.getPropertyStringValue((OntResource)op, (Property)this.PUBLIC_DESCRIPTION_ANNOT));
            p.setDomainDisplayTier(this.getPropertyNonNegativeIntegerValue((OntResource)op, (Property)this.DISPLAY_RANK_ANNOT));
            p.setRangeDisplayTier(this.getPropertyNonNegativeIntegerValue((OntResource)invOp, (Property)this.DISPLAY_RANK_ANNOT));
            p.setDomainDisplayLimit(this.getPropertyNonNegativeIntValue((OntResource)op, (Property)this.DISPLAY_LIMIT));
            p.setRangeDisplayLimit(this.getPropertyNonNegativeIntValue((OntResource)invOp, (Property)this.DISPLAY_LIMIT));
            RDFNode objectIndividualSortPropertyNode = op.getPropertyValue((Property)this.PROPERTY_OBJECTINDIVIDUALSORTPROPERTY);
            if (objectIndividualSortPropertyNode instanceof Resource) {
                p.setObjectIndividualSortPropertyURI(((Resource)objectIndividualSortPropertyNode).getURI());
            }
            p.setDomainEntitySortDirection(this.getPropertyStringValue((OntResource)op, (Property)this.PROPERTY_ENTITYSORTDIRECTION));
            p.setRangeEntitySortDirection(this.getPropertyStringValue((OntResource)invOp, (Property)this.PROPERTY_ENTITYSORTDIRECTION));
            StmtIterator it = op.listProperties((Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel hiddenRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || hiddenRoleLevel != null && roleFromModel.compareTo(hiddenRoleLevel) <= 0) continue;
                hiddenRoleLevel = roleFromModel;
            }
            p.setHiddenFromDisplayBelowRoleLevel(hiddenRoleLevel);
            it = op.listProperties((Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel prohibitedRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || prohibitedRoleLevel != null && roleFromModel.compareTo(prohibitedRoleLevel) <= 0) continue;
                prohibitedRoleLevel = roleFromModel;
            }
            p.setProhibitedFromUpdateBelowRoleLevel(prohibitedRoleLevel);
            it = op.listProperties((Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel publishRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || publishRoleLevel != null && roleFromModel.compareTo(publishRoleLevel) <= 0) continue;
                publishRoleLevel = roleFromModel;
            }
            p.setHiddenFromPublishBelowRoleLevel(publishRoleLevel);
            p.setCustomEntryForm(this.getPropertyStringValue((OntResource)op, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT));
            Boolean selectFromObj = this.getPropertyBooleanValue((OntResource)op, (Property)this.PROPERTY_SELECTFROMEXISTINGANNOT);
            p.setSelectFromExisting(selectFromObj == null ? true : selectFromObj);
            Boolean offerCreateObj = this.getPropertyBooleanValue((OntResource)op, (Property)this.PROPERTY_OFFERCREATENEWOPTIONANNOT);
            p.setOfferCreateNewOption(offerCreateObj == null ? false : offerCreateObj);
            Boolean dependencyDeletionObj = this.getPropertyBooleanValue((OntResource)op, (Property)this.PROPERTY_STUBOBJECTPROPERTYANNOT);
            p.setStubObjectRelation(dependencyDeletionObj == null ? false : dependencyDeletionObj);
            Boolean collateBySubclass = this.getPropertyBooleanValue((OntResource)op, (Property)this.PROPERTY_COLLATEBYSUBCLASSANNOT);
            p.setCollateBySubclass(collateBySubclass == null ? false : collateBySubclass);
            Boolean editLinkSuppressed = this.getPropertyBooleanValue((OntResource)op, (Property)this.PROPERTY_EDITLINKSUPPRESSED);
            p.setEditLinkSuppressed(editLinkSuppressed == null ? false : editLinkSuppressed);
            Boolean addLinkSuppressed = this.getPropertyBooleanValue((OntResource)op, (Property)this.PROPERTY_ADDLINKSUPPRESSED);
            p.setAddLinkSuppressed(addLinkSuppressed == null ? false : addLinkSuppressed);
            Boolean deleteLinkSuppressed = this.getPropertyBooleanValue((OntResource)op, (Property)this.PROPERTY_DELETELINKSUPPRESSED);
            p.setDeleteLinkSuppressed(deleteLinkSuppressed == null ? false : deleteLinkSuppressed);
            Resource groupRes = (Resource)op.getPropertyValue((Property)this.PROPERTY_INPROPERTYGROUPANNOT);
            if (groupRes != null) {
                p.setGroupURI(groupRes.getURI());
            }
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjectProperties() {
        this.getOntModel().enterCriticalSection(true);
        try {
            ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> props = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty>();
            try (ExtendedIterator opIt = this.getOntModel().listObjectProperties();){
                while (opIt.hasNext()) {
                    ObjectProperty op = (ObjectProperty)opIt.next();
                    if (this.NONUSER_NAMESPACES.contains(op.getNameSpace())) continue;
                    props.add(this.propertyFromOntProperty((OntProperty)op));
                }
            }
            catch (ProfileException pe) {
                try (ResIterator opIt2 = this.getOntModel().listSubjectsWithProperty(RDF.type, (RDFNode)RDF.Property);){
                    while (opIt2.hasNext()) {
                        Resource res = (Resource)opIt2.next();
                        if (!res.canAs(OntProperty.class) || this.NONUSER_NAMESPACES.contains(res.getNameSpace())) continue;
                        props.add(this.propertyFromOntProperty((OntProperty)res.as(OntProperty.class)));
                    }
                }
            }
            ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> arrayList = props;
            return arrayList;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    public List getPropIdsForClass(String classURI, boolean direction) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty getObjectPropertyByURI(String propertyURI) {
        if (propertyURI == null) {
            return null;
        }
        OntModel ontModel = this.getOntModel();
        OntModel localModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ontModel.enterCriticalSection(true);
        try {
            Resource prop = ontModel.getResource(propertyURI);
            localModel.add(ontModel.listStatements(prop, null, (RDFNode)null));
            StmtIterator invit = ontModel.listStatements(prop, OWL.inverseOf, (RDFNode)null);
            while (invit.hasNext()) {
                Statement invSit = invit.nextStatement();
                if (!invSit.getObject().isURIResource()) continue;
                Resource invProp = (Resource)invSit.getObject();
                localModel.add(ontModel.listStatements(invProp, null, (RDFNode)null));
            }
            ObjectProperty op = localModel.getObjectProperty(propertyURI);
            edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty objectProperty = this.propertyFromOntProperty((OntProperty)op);
            return objectProperty;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty getObjectPropertyByURIs(String propertyURI, String domainURI, String rangeURI) {
        return this.getObjectPropertyByURIs(propertyURI, domainURI, rangeURI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty getObjectPropertyByURIs(String propertyURI, String domainURI, String rangeURI, edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty base) {
        edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting " + propertyURI + " with domain " + domainURI + " and range " + rangeURI));
        }
        long start = System.currentTimeMillis();
        edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty objectProperty = op = base != null ? base : this.getObjectPropertyByURI(propertyURI);
        if (op == null || rangeURI == null) {
            return op;
        }
        op.setDomainVClassURI(domainURI);
        op.setRangeVClassURI(rangeURI);
        String propQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX config: <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?range ?rangeRoot ?label ?group ?customForm ?displayRank ?displayLevel     ?updateLevel ?publishLevel ?editLinkSuppressed ?addLinkSuppressed ?deleteLinkSuppressed \n    ?collateBySubclass ?displayLimit ?individualSortProperty \n    ?entitySortDirection ?selectFromExisting ?offerCreateNew \n    ?publicDescription ?stubDeletion \n WHERE { \n    ?context config:configContextFor <" + propertyURI + "> . \n";
        propQuery = domainURI != null && !domainURI.equals(OWL.Thing.getURI()) ? propQuery + "    ?context config:qualifiedByDomain <" + domainURI + "> . \n" : propQuery + "   FILTER NOT EXISTS { ?context config:qualifiedByDomain ?domainURI } \n";
        if (rangeURI != null) {
            propQuery = propQuery + "    ?context config:qualifiedBy <" + rangeURI + "> . \n";
        }
        propQuery = propQuery + "    OPTIONAL { ?context config:qualifiedByRoot ?rangeRoot } \n    ?context config:hasConfiguration ?configuration . \n    ?configuration a config:ObjectPropertyDisplayConfig . \n    OPTIONAL { ?configuration config:propertyGroup ?group } \n    OPTIONAL { ?configuration config:displayName ?label } \n    OPTIONAL { ?configuration config:editLinkSuppressed ?editLinkSuppressed } \n    OPTIONAL { ?configuration config:addLinkSuppressed ?addLinkSuppressed } \n    OPTIONAL { ?configuration config:deleteLinkSuppressed ?deleteLinkSuppressed } \n    OPTIONAL { ?configuration vitro:displayRankAnnot ?displayRank } \n    OPTIONAL { ?configuration vitro:customEntryFormAnnot ?customForm } \n    OPTIONAL { ?configuration vitro:hiddenFromDisplayBelowRoleLevelAnnot ?displayLevel } \n    OPTIONAL { ?configuration vitro:prohibitedFromUpdateBelowRoleLevelAnnot ?updateLevel } \n    OPTIONAL { ?configuration vitro:hiddenFromPublishBelowRoleLevelAnnot ?publishLevel } \n    OPTIONAL { ?configuration <" + this.PROPERTY_COLLATEBYSUBCLASSANNOT.getURI() + "> ?collateBySubclass } \n    OPTIONAL { ?configuration <" + this.DISPLAY_LIMIT.getURI() + "> ?displayLimit } \n    OPTIONAL { ?configuration <" + this.PROPERTY_OBJECTINDIVIDUALSORTPROPERTY.getURI() + "> ?individualSortProperty } \n     OPTIONAL { ?configuration <" + this.PROPERTY_ENTITYSORTDIRECTION.getURI() + "> ?entitySortDirection } \n    OPTIONAL { ?configuration <" + this.PROPERTY_SELECTFROMEXISTINGANNOT.getURI() + "> ?selectFromExisting } \n    OPTIONAL { ?configuration <" + this.PROPERTY_OFFERCREATENEWOPTIONANNOT.getURI() + "> ?offerCreateNew } \n    OPTIONAL { ?configuration <" + this.PUBLIC_DESCRIPTION_ANNOT.getURI() + "> ?publicDescription } \n    OPTIONAL { ?configuration <" + this.PROPERTY_STUBOBJECTPROPERTYANNOT.getURI() + "> ?stubDeletion } \n}";
        Query q = QueryFactory.create((String)propQuery);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)this.getOntModelSelector().getDisplayModel());){
            ResultSet rs = qe.execSelect();
            if (rs.hasNext()) {
                Literal publicDescriptionLit;
                Literal stubDeletionLit;
                Literal offerCreateNewLit;
                Literal selectFromExistingLit;
                Literal entitySortDirectionLit;
                Resource individualSortPropertyRes;
                Literal collateBySubclassLit;
                Literal deleteLinkSuppressedLit;
                Literal addLinkSuppressedLit;
                Literal editLinkSuppressedLit;
                Literal customFormLit;
                Literal labelLit;
                Resource publishLevelRes;
                Resource updateLevelRes;
                Resource displayLevelRes;
                Literal displayLimitLit;
                Literal displayRankLit;
                Resource groupRes;
                QuerySolution qsoln = rs.nextSolution();
                Resource rangeRootRes = qsoln.getResource("rangeRoot");
                if (rangeRootRes != null) {
                    op.setRangeEntityURI(rangeRootRes.getURI());
                }
                if ((groupRes = qsoln.getResource("group")) != null) {
                    op.setGroupURI(groupRes.getURI());
                }
                if ((displayRankLit = qsoln.getLiteral("displayRank")) != null) {
                    op.setDomainDisplayTier(Integer.parseInt(displayRankLit.getLexicalForm()));
                }
                if ((displayLimitLit = qsoln.getLiteral("displayLimit")) != null) {
                    op.setDomainDisplayLimit(Integer.parseInt(displayLimitLit.getLexicalForm()));
                }
                if ((displayLevelRes = qsoln.getResource("displayLevel")) != null) {
                    op.setHiddenFromDisplayBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(displayLevelRes.getURI()));
                }
                if ((updateLevelRes = qsoln.getResource("updateLevel")) != null) {
                    op.setProhibitedFromUpdateBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(updateLevelRes.getURI()));
                }
                if ((publishLevelRes = qsoln.getResource("publishLevel")) != null) {
                    op.setHiddenFromPublishBelowRoleLevel(BaseResourceBean.RoleLevel.getRoleByUri(publishLevelRes.getURI()));
                }
                if ((labelLit = qsoln.getLiteral("label")) != null) {
                    op.setDomainPublic(labelLit.getLexicalForm());
                }
                if ((customFormLit = qsoln.getLiteral("customForm")) != null) {
                    op.setCustomEntryForm(customFormLit.getLexicalForm());
                }
                if ((editLinkSuppressedLit = qsoln.getLiteral("editLinkSuppressed")) != null) {
                    op.setEditLinkSuppressed(editLinkSuppressedLit.getBoolean());
                }
                if ((addLinkSuppressedLit = qsoln.getLiteral("addLinkSuppressed")) != null) {
                    op.setAddLinkSuppressed(addLinkSuppressedLit.getBoolean());
                }
                if ((deleteLinkSuppressedLit = qsoln.getLiteral("deleteLinkSuppressed")) != null) {
                    op.setDeleteLinkSuppressed(deleteLinkSuppressedLit.getBoolean());
                }
                if ((collateBySubclassLit = qsoln.getLiteral("collateBySubclass")) != null) {
                    op.setCollateBySubclass(collateBySubclassLit.getBoolean());
                }
                if ((individualSortPropertyRes = qsoln.getResource("individualSortProperty")) != null) {
                    op.setObjectIndividualSortPropertyURI(individualSortPropertyRes.getURI());
                }
                if ((entitySortDirectionLit = qsoln.getLiteral("entitySortDirection")) != null) {
                    op.setDomainEntitySortDirection(entitySortDirectionLit.getLexicalForm());
                }
                if ((selectFromExistingLit = qsoln.getLiteral("selectFromExisting")) != null) {
                    op.setSelectFromExisting(selectFromExistingLit.getBoolean());
                }
                if ((offerCreateNewLit = qsoln.getLiteral("offerCreateNew")) != null) {
                    op.setOfferCreateNewOption(offerCreateNewLit.getBoolean());
                }
                if ((stubDeletionLit = qsoln.getLiteral("stubDeletion")) != null) {
                    op.setStubObjectRelation(stubDeletionLit.getBoolean());
                }
                if ((publicDescriptionLit = qsoln.getLiteral("publicDescription")) != null) {
                    op.setPublicDescription(publicDescriptionLit.getLexicalForm());
                }
            }
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> getObjectPropertiesForObjectPropertyStatements(List<ObjectPropertyStatement> objPropertyStmts) {
        if (objPropertyStmts == null || objPropertyStmts.size() < 1) {
            return new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty>();
        }
        HashMap<String, edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> hash = new HashMap<String, edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty>();
        String uris = "";
        this.getOntModel().enterCriticalSection(true);
        try {
            for (ObjectPropertyStatement objPropertyStmt : objPropertyStmts) {
                if (hash.containsKey(objPropertyStmt.getPropertyURI())) {
                    edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty p = (edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty)hash.get(objPropertyStmt.getPropertyURI());
                    p.addObjectPropertyStatement(objPropertyStmt);
                    continue;
                }
                OntProperty op = this.getOntModel().getOntProperty(objPropertyStmt.getPropertyURI());
                if (op == null) continue;
                edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty p = this.propertyFromOntProperty(op);
                hash.put(p.getURI(), p);
                p.addObjectPropertyStatement(objPropertyStmt);
            }
            ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> props = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty>();
            for (String key : hash.keySet()) {
                props.add((edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty)hash.get(key));
            }
            ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> arrayList = props;
            return arrayList;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    private boolean hasInverse(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop) {
        boolean hasInverse = false;
        if (prop.getURIInverse() != null && !"".equals(prop.getURIInverse())) {
            hasInverse = true;
        }
        if (prop.getNamespaceInverse() != null && !prop.getNamespaceInverse().equals("") && (prop.getLocalNameInverse() == null || "".equals(prop.getLocalNameInverse()))) {
            hasInverse = false;
        }
        return hasInverse;
    }

    @Override
    public int insertObjectProperty(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop) throws InsertException {
        return this.insertProperty(prop, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertProperty(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop, OntModel ontModel) throws InsertException {
        if (prop.getURI() == null || prop.getURI().length() < 3) {
            return 1;
        }
        ontModel.enterCriticalSection(false);
        try {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
            String errMsgStr = this.getWebappDaoFactory().checkURIForEditableEntity(prop.getURI());
            if (errMsgStr != null) {
                throw new InsertException(errMsgStr);
            }
            ObjectProperty p = ontModel.createObjectProperty(prop.getURI());
            ObjectProperty inv = null;
            if (this.hasInverse(prop)) {
                log.debug((Object)("non-null inverse URI: " + prop.getURIInverse()));
                errMsgStr = this.getWebappDaoFactory().checkURIForEditableEntity(prop.getURIInverse());
                if (errMsgStr != null) {
                    throw new InsertException("Unusable URI for inverse property: " + errMsgStr);
                }
                inv = ontModel.createObjectProperty(prop.getURIInverse());
                inv.setInverseOf((Property)p);
                p.setInverseOf((Property)inv);
            }
            this.doUpdate(prop, (OntProperty)p, (OntProperty)inv, ontModel);
            int n = 0;
            return n;
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void updateObjectProperty(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop) {
        this.updateProperty(prop, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop, OntModel ontModel) {
        if (prop.getURI() == null || prop.getURI().length() < 3) {
            return;
        }
        ontModel.enterCriticalSection(false);
        try {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
            ObjectProperty p = ontModel.getObjectProperty(prop.getURI());
            if (p == null) {
                return;
            }
            ObjectProperty inv = null;
            if (this.hasInverse(prop)) {
                try {
                    inv = ontModel.getObjectProperty(prop.getURIInverse());
                    if (!inv.isInverseOf((Property)p)) {
                        inv.setInverseOf((Property)p);
                        p.setInverseOf((Property)inv);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("Couldn't set " + prop.getURIInverse() + " as inverse"));
                }
            }
            try {
                this.doUpdate(prop, (OntProperty)p, (OntProperty)inv, ontModel);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
    }

    private void doUpdate(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop, OntProperty p, OntProperty inv, OntModel ontModel) {
        this.updateRDFSLabel((OntResource)p, prop.getDomainPublic());
        if (inv != null) {
            this.updateRDFSLabel((OntResource)inv, prop.getRangePublic());
        }
        try {
            ObjectProperty parent;
            String parentURI = prop.getParentURI();
            if (parentURI != null && (parent = ontModel.getObjectProperty(prop.getParentURI())) != null) {
                OntProperty parentInv;
                if (!p.hasSuperProperty((Property)parent, true)) {
                    p.addSuperProperty((Property)parent);
                }
                if (inv != null && (parentInv = parent.getInverse()) != null && !inv.hasSuperProperty((Property)parentInv, true)) {
                    inv.setSuperProperty((Property)parentInv);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to update parent property for " + prop.getURI()), (Throwable)e);
        }
        if (prop.getTransitive()) {
            if (!this.getOntModel().contains((Resource)p, RDF.type, (RDFNode)OWL.TransitiveProperty)) {
                this.getOntModel().add((Resource)p, RDF.type, (RDFNode)OWL.TransitiveProperty);
            }
            if (inv != null && !this.getOntModel().contains((Resource)inv, RDF.type, (RDFNode)OWL.TransitiveProperty)) {
                this.getOntModel().add((Resource)inv, RDF.type, (RDFNode)OWL.TransitiveProperty);
            }
        } else {
            if (this.getOntModel().contains((Resource)p, RDF.type, (RDFNode)OWL.TransitiveProperty)) {
                this.getOntModel().remove((Resource)p, RDF.type, (RDFNode)OWL.TransitiveProperty);
            }
            if (inv != null && this.getOntModel().contains((Resource)inv, RDF.type, (RDFNode)OWL.TransitiveProperty)) {
                this.getOntModel().remove((Resource)inv, RDF.type, (RDFNode)OWL.TransitiveProperty);
            }
        }
        if (prop.getSymmetric()) {
            if (!this.getOntModel().contains((Resource)p, RDF.type, (RDFNode)OWL.SymmetricProperty)) {
                this.getOntModel().add((Resource)p, RDF.type, (RDFNode)OWL.SymmetricProperty);
            }
            if (inv != null && !this.getOntModel().contains((Resource)inv, RDF.type, (RDFNode)OWL.SymmetricProperty)) {
                this.getOntModel().add((Resource)inv, RDF.type, (RDFNode)OWL.SymmetricProperty);
            }
        } else {
            if (this.getOntModel().contains((Resource)p, RDF.type, (RDFNode)OWL.SymmetricProperty)) {
                this.getOntModel().remove((Resource)p, RDF.type, (RDFNode)OWL.SymmetricProperty);
            }
            if (inv != null && this.getOntModel().contains((Resource)inv, RDF.type, (RDFNode)OWL.SymmetricProperty)) {
                this.getOntModel().remove((Resource)inv, RDF.type, (RDFNode)OWL.SymmetricProperty);
            }
        }
        if (prop.getFunctional()) {
            if (!this.getOntModel().contains((Resource)p, RDF.type, (RDFNode)OWL.FunctionalProperty)) {
                this.getOntModel().add((Resource)p, RDF.type, (RDFNode)OWL.FunctionalProperty);
            }
        } else if (this.getOntModel().contains((Resource)p, RDF.type, (RDFNode)OWL.FunctionalProperty)) {
            this.getOntModel().remove((Resource)p, RDF.type, (RDFNode)OWL.FunctionalProperty);
        }
        if (prop.getInverseFunctional()) {
            if (!this.getOntModel().contains((Resource)p, RDF.type, (RDFNode)OWL.InverseFunctionalProperty)) {
                this.getOntModel().add((Resource)p, RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
            }
        } else if (this.getOntModel().contains((Resource)p, RDF.type, (RDFNode)OWL.InverseFunctionalProperty)) {
            this.getOntModel().remove((Resource)p, RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
        }
        if (prop.getDomainVClassURI() != null && prop.getDomainVClassURI().length() > 0) {
            if (!p.hasDomain(ontModel.getResource(prop.getDomainVClassURI()))) {
                p.setDomain(ontModel.getResource(prop.getDomainVClassURI()));
                if (inv != null) {
                    inv.setRange((Resource)p.getDomain());
                }
            }
        } else {
            p.removeAll(RDFS.domain);
            if (inv != null) {
                inv.removeAll(RDFS.range);
            }
        }
        if (prop.getRangeVClassURI() != null && prop.getRangeVClassURI().length() > 0) {
            if (!p.hasRange(ontModel.getResource(prop.getRangeVClassURI()))) {
                p.setRange(ontModel.getResource(prop.getRangeVClassURI()));
                if (inv != null) {
                    inv.setDomain((Resource)p.getRange());
                }
            }
        } else {
            p.removeAll(RDFS.range);
            if (inv != null) {
                inv.removeAll(RDFS.domain);
            }
        }
        this.updatePropertyStringValue((Resource)p, (Property)this.EXAMPLE_ANNOT, prop.getExample(), (Model)this.getOntModel());
        this.updatePropertyStringValue((Resource)p, (Property)this.DESCRIPTION_ANNOT, prop.getDescription(), (Model)this.getOntModel());
        this.updatePropertyStringValue((Resource)p, (Property)this.PUBLIC_DESCRIPTION_ANNOT, prop.getPublicDescription(), (Model)this.getOntModel());
        this.updatePropertyNonNegativeIntegerValue((Resource)p, (Property)this.DISPLAY_LIMIT, prop.getDomainDisplayLimitInteger(), (Model)this.getOntModel());
        this.updatePropertyStringValue((Resource)p, (Property)this.PROPERTY_ENTITYSORTDIRECTION, prop.getDomainEntitySortDirection(), (Model)this.getOntModel());
        if (inv != null) {
            this.updatePropertyStringValue((Resource)inv, (Property)this.EXAMPLE_ANNOT, prop.getExample(), (Model)this.getOntModel());
            this.updatePropertyStringValue((Resource)inv, (Property)this.DESCRIPTION_ANNOT, prop.getDescription(), (Model)this.getOntModel());
            this.updatePropertyNonNegativeIntegerValue((Resource)inv, (Property)this.DISPLAY_LIMIT, prop.getRangeDisplayLimitInteger(), (Model)this.getOntModel());
            this.updatePropertyStringValue((Resource)inv, (Property)this.PROPERTY_ENTITYSORTDIRECTION, prop.getRangeEntitySortDirection(), (Model)this.getOntModel());
        }
        this.updatePropertyNonNegativeIntegerValue((Resource)p, (Property)this.DISPLAY_RANK_ANNOT, prop.getDomainDisplayTierInteger(), (Model)this.getOntModel());
        if (inv != null) {
            this.updatePropertyNonNegativeIntegerValue((Resource)inv, (Property)this.DISPLAY_RANK_ANNOT, prop.getRangeDisplayTierInteger(), (Model)this.getOntModel());
        }
        String oldObjectIndividualSortPropertyURI = null;
        RDFNode sortPropertyNode = p.getPropertyValue((Property)this.PROPERTY_OBJECTINDIVIDUALSORTPROPERTY);
        if (sortPropertyNode != null && sortPropertyNode instanceof Resource) {
            oldObjectIndividualSortPropertyURI = ((Resource)sortPropertyNode).getURI();
        }
        if (oldObjectIndividualSortPropertyURI != null && prop.getObjectIndividualSortPropertyURI() == null || oldObjectIndividualSortPropertyURI != null && prop.getObjectIndividualSortPropertyURI() != null && !oldObjectIndividualSortPropertyURI.equals(prop.getObjectIndividualSortPropertyURI())) {
            p.removeAll((Property)this.PROPERTY_OBJECTINDIVIDUALSORTPROPERTY);
        }
        if (oldObjectIndividualSortPropertyURI == null && prop.getObjectIndividualSortPropertyURI() != null || oldObjectIndividualSortPropertyURI != null && prop.getObjectIndividualSortPropertyURI() != null && !oldObjectIndividualSortPropertyURI.equals(prop.getObjectIndividualSortPropertyURI())) {
            Resource newObjectIndividualSortProperty = null;
            try {
                if (prop.getObjectIndividualSortPropertyURI().length() > 0) {
                    newObjectIndividualSortProperty = ResourceFactory.createResource((String)prop.getObjectIndividualSortPropertyURI());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (newObjectIndividualSortProperty != null) {
                p.addProperty((Property)this.PROPERTY_OBJECTINDIVIDUALSORTPROPERTY, (RDFNode)newObjectIndividualSortProperty);
            }
        }
        if (prop.getHiddenFromDisplayBelowRoleLevel() != null) {
            this.updatePropertyResourceURIValue((Resource)p, (Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT, prop.getHiddenFromDisplayBelowRoleLevel().getURI());
        }
        if (prop.getProhibitedFromUpdateBelowRoleLevel() != null) {
            this.updatePropertyResourceURIValue((Resource)p, (Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT, prop.getProhibitedFromUpdateBelowRoleLevel().getURI());
        }
        if (prop.getHiddenFromPublishBelowRoleLevel() != null) {
            this.updatePropertyResourceURIValue((Resource)p, (Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT, prop.getHiddenFromPublishBelowRoleLevel().getURI());
        }
        this.updatePropertyStringValue((Resource)p, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT, prop.getCustomEntryForm(), (Model)ontModel);
        this.updatePropertyBooleanValue((Resource)p, (Property)this.PROPERTY_SELECTFROMEXISTINGANNOT, prop.getSelectFromExisting(), (Model)ontModel, false);
        this.updatePropertyBooleanValue((Resource)p, (Property)this.PROPERTY_OFFERCREATENEWOPTIONANNOT, prop.getOfferCreateNewOption(), (Model)ontModel, true);
        this.updatePropertyBooleanValue((Resource)p, (Property)this.PROPERTY_STUBOBJECTPROPERTYANNOT, prop.getStubObjectRelation(), (Model)ontModel, true);
        this.updatePropertyBooleanValue((Resource)p, (Property)this.PROPERTY_COLLATEBYSUBCLASSANNOT, prop.getCollateBySubclass(), (Model)ontModel, true);
        this.updatePropertyResourceURIValue((Resource)p, (Property)this.PROPERTY_INPROPERTYGROUPANNOT, prop.getGroupURI());
    }

    @Override
    public void deleteObjectProperty(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop) {
        this.deleteProperty(prop, this.getOntModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProperty(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
        try {
            OntProperty invOp;
            OntProperty op = ontModel.getOntProperty(prop.getURI());
            if (op != null) {
                ResIterator restIt = ontModel.listSubjectsWithProperty(OWL.onProperty, (RDFNode)op);
                while (restIt.hasNext()) {
                    Resource restRes = (Resource)restIt.next();
                    if (!restRes.canAs(OntResource.class)) continue;
                    OntResource restOntRes = (OntResource)restRes.as(OntResource.class);
                    this.smartRemove(restOntRes, ontModel);
                }
                this.removeRulesMentioningResource((Resource)op, ontModel);
                LinkedList<Statement> depResStmts = new LinkedList<Statement>();
                StmtIterator depResIt = ontModel.listStatements(null, (Property)op, (RDFNode)null);
                while (depResIt.hasNext()) {
                    depResStmts.addAll(DependentResourceDeleteJena.getDependentResourceDeleteList(depResIt.nextStatement(), (Model)ontModel));
                }
                ontModel.remove(depResStmts);
                op.remove();
            }
            if (prop.getURIInverse() != null && prop.getURIInverse().length() > 0 && (invOp = ontModel.getOntProperty(prop.getURIInverse())) != null) {
                ResIterator restIt = ontModel.listSubjectsWithProperty(OWL.onProperty, (RDFNode)op);
                while (restIt.hasNext()) {
                    Resource restRes = (Resource)restIt.next();
                    if (!restRes.canAs(OntResource.class)) continue;
                    OntResource restOntRes = (OntResource)restRes.as(OntResource.class);
                    this.smartRemove(restOntRes, ontModel);
                }
                this.removeRulesMentioningResource((Resource)invOp, ontModel);
                invOp.remove();
            }
        }
        finally {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
        this.removeABoxStatementsWithPredicate(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> getRootObjectProperties() {
        ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> rootProperties = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty>();
        this.getOntModel().enterCriticalSection(true);
        try {
            ExtendedIterator propIt;
            try {
                propIt = this.getOntModel().listObjectProperties();
            }
            catch (ProfileException pe) {
                propIt = this.getOntModel().listSubjectsWithProperty(RDF.type, (RDFNode)RDF.Property);
            }
            try {
                while (propIt.hasNext()) {
                    Resource res = (Resource)propIt.next();
                    if (!res.canAs(OntProperty.class)) continue;
                    OntProperty op = (OntProperty)res.as(OntProperty.class);
                    boolean isRoot = false;
                    ExtendedIterator parentIt = op.listSuperProperties();
                    if (parentIt != null) {
                        ArrayList<Property> parentList = new ArrayList<Property>();
                        try {
                            parentList.addAll(op.listSuperProperties().toList());
                        }
                        catch (ConversionException ce) {
                            StmtIterator parentStmtIt = op.listProperties(RDFS.subPropertyOf);
                            while (parentStmtIt.hasNext()) {
                                Resource parentRes;
                                Statement parentStmt = parentStmtIt.nextStatement();
                                if (!parentStmt.getObject().isResource() || (parentRes = (Resource)parentStmt.getObject()).getURI() == null) continue;
                                Property parentProperty = ResourceFactory.createProperty((String)parentRes.getURI());
                                parentList.add(parentProperty);
                            }
                            parentStmtIt.close();
                        }
                        if (parentList.size() == 0) {
                            isRoot = true;
                        } else {
                            isRoot = true;
                            for (Property pt : parentList) {
                                if (pt.equals(op) || this.getOntModel().contains((Resource)op, OWL.equivalentProperty, (RDFNode)pt) && !this.getOntModel().contains((Resource)pt, OWL.equivalentProperty, (RDFNode)op)) continue;
                                isRoot = false;
                            }
                        }
                    } else {
                        isRoot = true;
                    }
                    if (!isRoot || this.NONUSER_NAMESPACES.contains(op.getNameSpace())) continue;
                    rootProperties.add(this.propertyFromOntProperty(op));
                }
            }
            finally {
                propIt.close();
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        if (rootProperties.size() == 0) {
            return null;
        }
        return rootProperties;
    }

    public List<String> getSuperPropertyURIs(String objectPropertyURI) {
        ArrayList<String> supURIs = new ArrayList<String>();
        try {
            ExtendedIterator supIt = this.getOntModel().getOntProperty(objectPropertyURI).listSuperProperties(true);
            while (supIt.hasNext()) {
                try {
                    OntProperty op = (OntProperty)supIt.next();
                    supURIs.add(op.getURI());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supURIs;
    }

    @Override
    public List<String> getSubPropertyURIs(String objectPropertyURI) {
        ArrayList<String> subURIs = new ArrayList<String>();
        try {
            ExtendedIterator subIt = this.getOntModel().getOntProperty(objectPropertyURI).listSubProperties(true);
            while (subIt.hasNext()) {
                try {
                    OntProperty op = (OntProperty)subIt.next();
                    subURIs.add(op.getURI());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return subURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean skipEditForm(String predicateURI) {
        OntModel ontModel = this.getOntModel();
        try {
            ontModel.enterCriticalSection(true);
            if (this.getOntModel().contains(ontModel.getResource(predicateURI), ontModel.getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#skipEditForm"), (RDFNode)ontModel.createTypedLiteral("true", (RDFDatatype)XSDDatatype.XSDboolean))) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return false;
    }

    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> getObjectPropertyList(Individual subject) {
        return this.getObjectPropertyList(subject.getURI());
    }

    @Override
    public List<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> getObjectPropertyList(String subjectUri) {
        String queryString = QueryUtils.subUriForQueryVar(OBJECT_PROPERTY_QUERY_STRING, "subject", subjectUri);
        Query query = null;
        try {
            query = QueryFactory.create((String)queryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for query string " + th.getMessage()));
            log.error((Object)queryString);
            return null;
        }
        log.debug((Object)("Object property query:\n" + query));
        final ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty> properties = new ArrayList<edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty>();
        this.getPropertyQueryResults(queryString, new ResultSetConsumer(){
            edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty propRegister = new edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty();
            {
                this.propRegister.setURI("");
            }

            @Override
            protected void processQuerySolution(QuerySolution qs) {
                Resource resource = qs.getResource("property");
                String uri = resource.getURI();
                Resource objType = qs.getResource("objType");
                String objTypeUri = objType.getURI();
                log.debug((Object)("Found populated object property " + uri + " with object type " + objType));
                edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty property = null;
                if (uri.equals(this.propRegister.getURI())) {
                    property = this.propRegister.clone();
                } else {
                    edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty newProperty = ObjectPropertyDaoJena.this.getObjectPropertyByURI(uri);
                    if (newProperty != null) {
                        this.propRegister = newProperty;
                        properties.add(newProperty);
                        property = newProperty.clone();
                    }
                }
                if (property != null) {
                    property.setRangeVClassURI(objTypeUri);
                    properties.add(property);
                }
            }
        });
        return properties;
    }

    @Override
    public String getCustomListViewConfigFileName(edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty op) {
        PropertyDao.FullPropertyKey key;
        String customListViewConfigFileName;
        if (this.customListViewConfigFileMap == null) {
            this.customListViewConfigFileMap = new HashMap<PropertyDao.FullPropertyKey, String>();
        }
        if (this.customListViewConfigFileMap.isEmpty()) {
            long start = System.currentTimeMillis();
            OntModel displayModel = this.getOntModelSelector().getDisplayModel();
            QueryExecution qexec = QueryExecutionFactory.create((Query)listViewConfigFileQuery, (Model)displayModel);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.next();
                String propertyUri = soln.getResource("property").getURI();
                RDFNode rangeNode = soln.get("range");
                String rangeUri = rangeNode != null ? ((Resource)rangeNode).getURI() : OWL.Thing.getURI();
                RDFNode domainNode = soln.get("domain");
                String domainUri = domainNode != null ? ((Resource)domainNode).getURI() : OWL.Thing.getURI();
                edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty prop = this.getObjectPropertyByURI(propertyUri);
                if (prop == null) {
                    if (op.getURI().equals(propertyUri)) {
                        log.warn((Object)("Can't find property for uri " + propertyUri));
                        continue;
                    }
                    log.debug((Object)("Can't find property for uri " + propertyUri));
                    continue;
                }
                String filename = soln.getLiteral("filename").getLexicalForm();
                PropertyDao.FullPropertyKey key2 = new PropertyDao.FullPropertyKey(domainUri, prop.getURI(), rangeUri);
                log.debug((Object)("putting " + key2 + " " + filename + " into list view map"));
                this.customListViewConfigFileMap.put(key2, filename);
            }
            if (this.customListViewConfigFileMap.isEmpty()) {
                this.customListViewConfigFileMap.put(new PropertyDao.FullPropertyKey(null, "http://www.w3.org/2002/07/owl#bottomObjectProperty", null), "nothing");
            }
            qexec.close();
        }
        if ((customListViewConfigFileName = this.customListViewConfigFileMap.get(key = new PropertyDao.FullPropertyKey(op))) == null) {
            log.debug((Object)("no list view found for " + key));
            key = new PropertyDao.FullPropertyKey(null, op.getURI(), op.getRangeVClassURI());
            customListViewConfigFileName = this.customListViewConfigFileMap.get(key);
        }
        if (customListViewConfigFileName == null) {
            log.debug((Object)("no list view found for " + key));
            key = new PropertyDao.FullPropertyKey(null, op.getURI(), null);
            customListViewConfigFileName = this.customListViewConfigFileMap.get(key);
        }
        return customListViewConfigFileName;
    }

    static {
        ArrayList<String> namespaceFilters = new ArrayList<String>();
        for (String namespace : EXCLUDED_NAMESPACES) {
            namespaceFilters.add("( !regex(str(?property), \"^" + namespace + "\" ))");
        }
        namespaceFilters.add("( ?property = vitro:primaryLink ||?property = vitro:additionalLink ||!regex(str(?property), \"^http://vitro.mannlib.cornell.edu/ns/vitro/0.7#\" ))");
        PROPERTY_FILTERS = StringUtils.join(namespaceFilters, (String)" && ");
        OBJECT_PROPERTY_QUERY_STRING = PREFIXES + "\nSELECT DISTINCT ?property ?objType WHERE { \n   ?subject ?property ?object . \n   ?object a ?objType . \n   FILTER ( \n       isURI(?object) && \n" + PROPERTY_FILTERS + "\n   ) \n} ORDER BY ?property ?objType";
        listViewConfigFileQuery = null;
        try {
            listViewConfigFileQuery = QueryFactory.create((String)LIST_VIEW_CONFIG_FILE_QUERY_STRING);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for LIST_VIEW_CONFIG_FILE_QUERY_STRING " + th.getMessage()));
            log.error((Object)LIST_VIEW_CONFIG_FILE_QUERY_STRING);
        }
    }
}

