/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.utils.http.HttpClientFactory;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.SingletonIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class SparqlGraph
implements GraphWithPerform {
    private String endpointURI;
    private String graphURI;
    private HttpClient httpClient;
    private static final Log log = LogFactory.getLog(SparqlGraph.class);
    private PrefixMapping prefixMapping = new PrefixMappingImpl();
    private GraphEventManager eventManager;
    private static final Capabilities capabilities = new Capabilities(){

        public boolean addAllowed() {
            return false;
        }

        public boolean addAllowed(boolean everyTriple) {
            return false;
        }

        public boolean canBeEmpty() {
            return true;
        }

        public boolean deleteAllowed() {
            return false;
        }

        public boolean deleteAllowed(boolean everyTriple) {
            return false;
        }

        public boolean findContractSafe() {
            return true;
        }

        public boolean handlesLiteralTyping() {
            return true;
        }

        public boolean iteratorRemoveAllowed() {
            return false;
        }

        public boolean sizeAccurate() {
            return true;
        }
    };

    public SparqlGraph(String endpointURI) {
        this(endpointURI, null);
    }

    public SparqlGraph(String endpointURI, String graphURI) {
        this.endpointURI = endpointURI;
        this.graphURI = graphURI;
        this.httpClient = HttpClientFactory.getHttpClient();
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public String getGraphURI() {
        return this.graphURI;
    }

    public void add(Triple arg0) throws AddDeniedException {
        this.performAdd(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String updateString) {
        HttpPost meth = new HttpPost(this.endpointURI);
        try {
            meth.addHeader("Content-Type", "application/x-www-form-urlencoded");
            meth.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("update", updateString))));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)meth, (HttpContext)new BasicHttpContext());
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode > 399) {
                    log.error((Object)("response " + statusCode + " to update. \n"));
                    throw new RuntimeException("Unable to perform SPARQL UPDATE: \n" + updateString);
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to perform SPARQL UPDATE", e);
        }
        finally {
            meth.abort();
        }
    }

    public void performAdd(Triple t) {
        String updateString = "INSERT DATA { " + (this.graphURI != null ? "GRAPH <" + this.graphURI + "> { " : "") + SparqlGraph.sparqlNodeUpdate(t.getSubject(), "") + " " + SparqlGraph.sparqlNodeUpdate(t.getPredicate(), "") + " " + SparqlGraph.sparqlNodeUpdate(t.getObject(), "") + " } " + (this.graphURI != null ? " } " : "");
        if (this.graphURI != null) {
            log.info((Object)("=====> update to graph " + this.graphURI));
        }
        log.info((Object)updateString);
        this.executeUpdate(updateString);
    }

    public void performDelete(Triple t) {
        String updateString = "DELETE DATA { " + (this.graphURI != null ? "GRAPH <" + this.graphURI + "> { " : "") + SparqlGraph.sparqlNodeUpdate(t.getSubject(), "") + " " + SparqlGraph.sparqlNodeUpdate(t.getPredicate(), "") + " " + SparqlGraph.sparqlNodeUpdate(t.getObject(), "") + " } " + (this.graphURI != null ? " } " : "");
        this.executeUpdate(updateString);
    }

    public void removeAll() {
        String updateString = "DELETE { ?s ?p ?o } WHERE { \n" + (this.getGraphURI() != null ? "GRAPH <" + this.getGraphURI() + "> { \n" : "") + "    ?s ?p ?o \n" + (this.getGraphURI() != null ? "} \n" : "") + "}";
        this.executeUpdate(updateString);
    }

    public void close() {
    }

    public boolean contains(Triple arg0) {
        return this.contains(arg0.getSubject(), arg0.getPredicate(), arg0.getObject());
    }

    public boolean contains(Node subject, Node predicate, Node object) {
        if (subject != null && subject.isBlank() || predicate != null && predicate.isBlank() || object != null && object.isBlank()) {
            return false;
        }
        StringBuilder containsQuery = new StringBuilder("ASK { \n");
        if (this.graphURI != null) {
            containsQuery.append("  GRAPH <").append(this.graphURI).append("> { ");
        }
        containsQuery.append(SparqlGraph.sparqlNode(subject, "?s")).append(" ").append(SparqlGraph.sparqlNode(predicate, "?p")).append(" ").append(SparqlGraph.sparqlNode(object, "?o"));
        if (this.graphURI != null) {
            containsQuery.append(" } \n");
        }
        containsQuery.append("\n}");
        boolean result = this.execAsk(containsQuery.toString());
        return result;
    }

    public void delete(Triple arg0) throws DeleteDeniedException {
        this.performDelete(arg0);
    }

    public ExtendedIterator<Triple> find(Triple triple) {
        return this.find(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void clear() {
        this.removeAll();
    }

    public void remove(Node subject, Node predicate, Node object) {
        for (Triple t : this.find(subject, predicate, object).toList()) {
            this.delete(t);
        }
    }

    public boolean dependsOn(Graph arg0) {
        return false;
    }

    public static String sparqlNode(Node node, String varName) {
        if (node == null || node.isVariable()) {
            return varName;
        }
        if (node.isBlank()) {
            return "<fake:blank>";
        }
        if (node.isURI()) {
            StringBuilder uriBuff = new StringBuilder();
            return uriBuff.append("<").append(node.getURI()).append(">").toString();
        }
        if (node.isLiteral()) {
            StringBuffer literalBuff = new StringBuffer();
            literalBuff.append("\"");
            SparqlGraph.pyString(literalBuff, node.getLiteralLexicalForm());
            literalBuff.append("\"");
            if (node.getLiteralDatatypeURI() != null) {
                literalBuff.append("^^<").append(node.getLiteralDatatypeURI()).append(">");
            } else if (!StringUtils.isEmpty((CharSequence)node.getLiteralLanguage())) {
                literalBuff.append("@").append(node.getLiteralLanguage());
            }
            return literalBuff.toString();
        }
        return varName;
    }

    public static String sparqlNodeUpdate(Node node, String varName) {
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel().replaceAll("\\W", "");
        }
        return SparqlGraph.sparqlNode(node, varName);
    }

    public static String sparqlNodeDelete(Node node, String varName) {
        if (node.isBlank()) {
            return "?" + node.getBlankNodeLabel().replaceAll("\\W", "");
        }
        return SparqlGraph.sparqlNode(node, varName);
    }

    public ExtendedIterator<Triple> find(Node subject, Node predicate, Node object) {
        if (!(this.isVar(subject) || this.isVar(predicate) || this.isVar(object))) {
            if (this.contains(subject, predicate, object)) {
                return new SingletonIterator((Object)new Triple(subject, predicate, object));
            }
            return WrappedIterator.create(Collections.emptyIterator());
        }
        StringBuilder findQuery = new StringBuilder("SELECT * WHERE { \n");
        if (this.graphURI != null) {
            findQuery.append("  GRAPH <").append(this.graphURI).append("> { ");
        }
        findQuery.append(SparqlGraph.sparqlNode(subject, "?s")).append(" ").append(SparqlGraph.sparqlNode(predicate, "?p")).append(" ").append(SparqlGraph.sparqlNode(object, "?o"));
        if (this.graphURI != null) {
            findQuery.append("  } ");
        }
        findQuery.append("\n}");
        String queryString = findQuery.toString();
        ResultSet rs = this.execSelect(queryString);
        ArrayList<Triple> triplist = new ArrayList<Triple>();
        while (rs.hasNext()) {
            QuerySolution soln = rs.nextSolution();
            Triple t = new Triple(this.isVar(subject) ? soln.get("?s").asNode() : subject, this.isVar(predicate) ? soln.get("?p").asNode() : predicate, this.isVar(object) ? soln.get("?o").asNode() : object);
            triplist.add(t);
        }
        return WrappedIterator.create(triplist.iterator());
    }

    private boolean isVar(Node node) {
        return node == null || node.isVariable() || node == Node.ANY;
    }

    public Capabilities getCapabilities() {
        return capabilities;
    }

    public GraphEventManager getEventManager() {
        if (this.eventManager == null) {
            this.eventManager = new SimpleEventManager((Graph)this);
        }
        return this.eventManager;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        return null;
    }

    public TransactionHandler getTransactionHandler() {
        return null;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isEmpty() {
        return !this.contains(null, null, null);
    }

    public boolean isIsomorphicWith(Graph arg0) {
        log.info((Object)"Hey dummy!");
        throw new UnsupportedOperationException("isIsomorphicWith() not supported by SPARQL graphs");
    }

    public int size() {
        int size = this.find(null, null, null).toList().size();
        return size;
    }

    private boolean execAsk(String queryStr) {
        Query askQuery = QueryFactory.create((String)queryStr);
        try (QueryExecution qe = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)askQuery);){
            boolean bl = qe.execAsk();
            return bl;
        }
    }

    private ResultSet execSelect(String queryStr) {
        Query askQuery = QueryFactory.create((String)queryStr);
        try (QueryExecution qe = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)askQuery);){
            ResultSetMem resultSetMem = new ResultSetMem(qe.execSelect());
            return resultSetMem;
        }
    }

    protected static void pyString(StringBuffer sbuff, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (c == '\n') {
                sbuff.append("\\n");
                continue;
            }
            if (c == '\t') {
                sbuff.append("\\t");
                continue;
            }
            if (c == '\r') {
                sbuff.append("\\r");
                continue;
            }
            if (c == '\f') {
                sbuff.append("\\f");
                continue;
            }
            if (c == '\b') {
                sbuff.append("\\b");
                continue;
            }
            if (c == '\u0007') {
                sbuff.append("\\a");
                continue;
            }
            sbuff.append(c);
        }
    }

    public String toString() {
        return "SparqlGraph[" + ToString.hashHex(this) + ", endpoint=" + this.endpointURI + ", name=" + ToString.modelName(this.graphURI) + "]";
    }
}

