/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.dao.jena.SparqlGraph;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class SparqlGraphMultilingual
extends SparqlGraph
implements GraphWithPerform {
    private static final Log log = LogFactory.getLog(SparqlGraphMultilingual.class);
    protected List<String> langs;

    public SparqlGraphMultilingual(String endpointURI, List<String> languages) {
        super(endpointURI);
        this.langs = languages;
    }

    @Override
    public void add(Triple arg0) throws AddDeniedException {
        this.performAdd(arg0);
    }

    @Override
    public void performAdd(Triple t) {
        super.performAdd(t);
    }

    @Override
    public ExtendedIterator<Triple> find(Node subject, Node predicate, Node object) {
        long startTime = System.currentTimeMillis();
        ExtendedIterator<Triple> rawResults = super.find(subject, predicate, object);
        long rawTime = System.currentTimeMillis() - startTime;
        ArrayList<Triple> tripList = new ArrayList<Triple>();
        while (rawResults.hasNext()) {
            tripList.add((Triple)rawResults.next());
        }
        if (tripList.size() == 0) {
            return WrappedIterator.create(tripList.iterator());
        }
        if (subject.isConcrete() && predicate.isConcrete() && !object.isConcrete()) {
            tripList.sort(new TripleSortByLang());
            LinkedList<Triple> tripl = new LinkedList<Triple>();
            if (!((Triple)tripList.get(0)).getObject().isLiteral()) {
                tripl.addAll(tripList);
            } else if (StringUtils.isEmpty((CharSequence)((Triple)tripList.get(0)).getObject().getLiteralLanguage())) {
                tripl.addAll(tripList);
            } else {
                Triple t;
                String lang = ((Triple)tripList.get(0)).getObject().getLiteralLanguage();
                Iterator iterator = tripList.iterator();
                while (iterator.hasNext() && lang.equals((t = (Triple)iterator.next()).getObject().getLiteralLanguage())) {
                    tripl.add(t);
                }
            }
            long filterTime = System.currentTimeMillis() - rawTime - startTime;
            if (filterTime > 1L) {
                log.info((Object)("raw time " + rawTime + " ; filter time " + filterTime));
            }
            return WrappedIterator.create(tripl.iterator());
        }
        if (rawTime > 9L) {
            log.info((Object)("raw time " + rawTime));
            log.info((Object)("^ " + subject + " : " + predicate + " : " + object));
        }
        return WrappedIterator.create(tripList.iterator());
    }

    @Override
    public String toString() {
        return "SparqlGraphMultilingual[" + ToString.hashHex(this) + ", endpoint=" + this.getEndpointURI() + ", name=" + ToString.modelName(this.getGraphURI()) + "]";
    }

    private class TripleSortByLang
    implements Comparator<Triple> {
        private TripleSortByLang() {
        }

        @Override
        public int compare(Triple t1, Triple t2) {
            int t2langPref;
            if (t1 == null || t2 == null) {
                return 0;
            }
            if (!t1.getObject().isLiteral() || !t2.getObject().isLiteral()) {
                return 0;
            }
            String t1lang = t1.getObject().getLiteral().language();
            String t2lang = t2.getObject().getLiteral().language();
            if (t1lang == null && t2lang == null) {
                return 0;
            }
            if (t1lang == null) {
                return 1;
            }
            if (t2lang == null) {
                return -1;
            }
            int t1langPref = SparqlGraphMultilingual.this.langs.indexOf(t1.getObject().getLiteral().language());
            if (t1langPref == -1) {
                t1langPref = Integer.MAX_VALUE;
            }
            if ((t2langPref = SparqlGraphMultilingual.this.langs.indexOf(t2.getObject().getLiteral().language())) == -1) {
                t2langPref = Integer.MAX_VALUE;
            }
            return t1langPref - t2langPref;
        }
    }
}

