/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.vocabulary.XSD;

public class EditN3GeneratorVTwo {
    static final Log log = LogFactory.getLog(EditN3GeneratorVTwo.class);

    public void subInMultiUris(Map<String, List<String>> varsToVals, List<String> n3targets) {
        if (varsToVals == null || varsToVals.isEmpty() || n3targets == null) {
            return;
        }
        for (int i = 0; i < n3targets.size(); ++i) {
            String result = n3targets.get(i);
            if (result == null) continue;
            Set<String> keySet = varsToVals.keySet();
            for (String key : keySet) {
                List<String> values = varsToVals.get(key);
                if (values == null) {
                    log.debug((Object)("skipping var " + key + " because value List is null"));
                    continue;
                }
                if (this.containsNullOrEmpty(values)) {
                    log.debug((Object)("skipping var " + key + " because it contains nulls or empty strings"));
                    continue;
                }
                log.debug((Object)("The original value String is " + values.toString()));
                String valueString = StringUtils.join(values, (String)">, <");
                valueString = "<" + valueString + ">";
                log.debug((Object)("The multiUri value String is " + valueString));
                result = this.subInNonBracketedURIS(key, valueString, result);
            }
            n3targets.set(i, result);
        }
    }

    private boolean containsNullOrEmpty(List<String> values) {
        if (values == null || values.isEmpty()) {
            return true;
        }
        for (String str : values) {
            if (!StringUtils.isBlank((CharSequence)str)) continue;
            return true;
        }
        return false;
    }

    public void subInUris(Map<String, String> varsToVals, List<String> targets) {
        if (varsToVals == null || varsToVals.isEmpty() || targets == null) {
            return;
        }
        for (int i = 0; i < targets.size(); ++i) {
            String result = targets.get(i);
            if (result == null) continue;
            for (String key : varsToVals.keySet()) {
                result = this.subInUris(key, varsToVals.get(key), result);
            }
            targets.set(i, result);
        }
    }

    public String subInUris(String var, String value, String target) {
        if (var == null || var.isEmpty() || value == null || value.isEmpty() || target == null) {
            return target;
        }
        return this.subInNonBracketedURIS(var, "<" + value + ">", target);
    }

    public void subInUris(String var, String value, List<String> targets) {
        if (targets == null) {
            return;
        }
        for (String target : targets) {
            this.subInUris(var, value, target);
        }
    }

    public void subInMultiLiterals(Map<String, List<Literal>> varsToVals, List<String> n3targets) {
        if (varsToVals == null || varsToVals.isEmpty() || n3targets == null) {
            return;
        }
        for (int i = 0; i < n3targets.size(); ++i) {
            String orginalN3 = n3targets.get(i);
            if (orginalN3 == null) continue;
            String newN3 = orginalN3;
            for (String key : varsToVals.keySet()) {
                newN3 = this.subInMultiLiterals(key, varsToVals.get(key), newN3);
            }
            n3targets.set(i, newN3);
        }
    }

    public void subInLiterals(Map<String, Literal> varsToVals, List<String> n3targets) {
        if (varsToVals == null || varsToVals.isEmpty() || n3targets == null) {
            return;
        }
        for (int i = 0; i < n3targets.size(); ++i) {
            String orginalN3 = n3targets.get(i);
            if (orginalN3 == null) continue;
            String newN3 = orginalN3;
            for (String key : varsToVals.keySet()) {
                newN3 = this.subInLiterals(key, varsToVals.get(key), newN3);
            }
            n3targets.set(i, newN3);
        }
    }

    protected String subInLiterals(String var, Literal literal, String target) {
        String varRegex = "\\?" + var + "(?=\\p{Punct}||\\p{Space}|&)";
        if (target == null) {
            log.error((Object)"subInLiterals was passed a null target");
            return "blankBecauseTargetOrValueWasNull";
        }
        if (var == null) {
            log.warn((Object)"subInLiterals was passed a null var name");
            return target;
        }
        if (literal == null) {
            log.debug((Object)("subInLiterals was passed a null value for var '" + var + "'; returning target: '" + target + "'"));
            return target;
        }
        try {
            if (literal.getValue() == null) {
                log.debug((Object)("value of literal for " + var + " was null"));
            }
        }
        catch (DatatypeFormatException ex) {
            log.debug((Object)("value for " + var + " " + ex.getMessage()));
        }
        String replacement = null;
        if (literal.getLexicalForm().length() == 0) {
            log.debug((Object)("empty string found on form for " + var + "."));
            replacement = ">::" + var + " was empty::<";
        } else {
            replacement = EditN3GeneratorVTwo.formatLiteral(literal);
        }
        String out = null;
        out = replacement != null ? target.replaceAll(varRegex, Matcher.quoteReplacement(replacement)) : target;
        if (out != null && out.length() > 0) {
            return out;
        }
        log.debug((Object)"After attempting to substitue in literals, the target N3 was empty");
        return target;
    }

    protected String subInMultiLiterals(String var, List<Literal> values, String n3) {
        if (n3 == null) {
            log.error((Object)"subInMultiLiterals was passed a null n3 String");
            return "blankBecauseTargetOrValueWasNull";
        }
        if (var == null) {
            log.warn((Object)"subInMultiLiterals was passed a null var name");
            return n3;
        }
        if (values == null) {
            log.debug((Object)("subInMultiLiterals was passed a null value for var '" + var + "'; returning target: '" + n3 + "'"));
            return n3;
        }
        String tmp = n3;
        ArrayList<String> n3Values = new ArrayList<String>(values.size());
        for (Literal value : values) {
            if (value != null) {
                n3Values.add(EditN3GeneratorVTwo.formatLiteral(value));
                continue;
            }
            log.debug((Object)("value of literal for " + var + " was null"));
        }
        String valueString = StringUtils.join(n3Values, (String)",");
        String varRegex = "\\?" + var + "(?=\\p{Punct}|\\p{Space}|$)";
        String out = null;
        out = valueString != null ? tmp.replaceAll(varRegex, Matcher.quoteReplacement(valueString)) : n3;
        return out;
    }

    protected String quoteForN3(String in) {
        return in;
    }

    protected String subInNonBracketedURIS(String var, String value, String target) {
        String varRegex = "\\?" + var + "(?=\\p{Punct}|\\p{Space}|$)";
        Object out = null;
        if ("".equals(value)) {
            return target.replaceAll(varRegex, ">::" + var + " was BLANK::< ");
        }
        String replaceWith = Matcher.quoteReplacement(value);
        return target.replaceAll(varRegex, replaceWith);
    }

    protected static String formatLiteral(Literal literal) {
        String datatype = literal.getDatatypeURI();
        String lang = literal.getLanguage();
        String s = literal.getLexicalForm();
        if (datatype != null) {
            if (datatype.equals(XSD.integer.getURI())) {
                try {
                    new BigInteger(s);
                    return s;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.decimal.getURI()) && s.indexOf(46) >= 0 && s.indexOf(101) == -1 && s.indexOf(69) == -1) {
                try {
                    BigDecimal d = new BigDecimal(s);
                    return s;
                }
                catch (NumberFormatException d) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.xdouble.getURI()) && (s.indexOf(101) >= 0 || s.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(s);
                    return s;
                }
                catch (NumberFormatException d) {
                    // empty catch block
                }
            }
        }
        StringBuffer sbuff = new StringBuffer();
        String quoteMarks = "\"";
        sbuff.append(quoteMarks);
        EditN3GeneratorVTwo.pyString(sbuff, s);
        sbuff.append(quoteMarks);
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        if (datatype != null) {
            sbuff.append("^^");
            sbuff.append(EditN3GeneratorVTwo.formatURI(datatype));
        }
        return sbuff.toString();
    }

    protected static void pyString(StringBuffer sbuff, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (c == '\n') {
                sbuff.append("\\n");
                continue;
            }
            if (c == '\t') {
                sbuff.append("\\t");
                continue;
            }
            if (c == '\r') {
                sbuff.append("\\r");
                continue;
            }
            if (c == '\f') {
                sbuff.append("\\f");
                continue;
            }
            if (c == '\b') {
                sbuff.append("\\b");
                continue;
            }
            if (c == '\u0007') {
                sbuff.append("\\a");
                continue;
            }
            sbuff.append(c);
        }
    }

    protected static String formatURI(String uriStr) {
        return "<" + uriStr + ">";
    }
}

