/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.vocabulary.XSD;

public class RDFSLabelGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(RDFSLabelGenerator.class);
    private String subjectUri = null;
    private String predicateUri = null;
    private Integer dataHash = null;
    private String literalName = "label";
    private String template = "rdfsLabelForm.ftl";

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = EditConfigurationVTwo.getConfigFromSession(session, (HttpServletRequest)vreq);
        if (editConfiguration == null) {
            this.log.debug((Object)"No editConfig in session. Making new editConfig.");
            editConfiguration = this.setupEditConfiguration(vreq, session);
        } else {
            this.log.debug((Object)"Edit Configuration object already exists and will be returned");
        }
        return editConfiguration;
    }

    private EditConfigurationVTwo setupEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        editConfiguration.setN3Required(this.generateN3Required(vreq));
        editConfiguration.setN3Optional(this.generateN3Optional());
        editConfiguration.setNewResources(new HashMap<String, String>());
        this.setUrisAndLiteralsInScope(editConfiguration);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        editConfiguration.setFilesOnForm(new ArrayList<String>());
        this.setSparqlQueries(editConfiguration);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri(vreq));
        this.prepareForUpdate(vreq, session, editConfiguration);
        editConfiguration.addValidator(new AntiXssValidation());
        this.setTemplate(editConfiguration, vreq);
        this.setEditKey(editConfiguration, vreq);
        return editConfiguration;
    }

    private void setEditKey(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        String editKey = EditConfigurationUtils.getEditKey(vreq);
        editConfiguration.setEditKey(editKey);
    }

    private void setTemplate(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setTemplate(this.template);
    }

    private void initProcessParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        String formUrl = EditConfigurationUtils.getFormUrlWithoutContext(vreq);
        this.subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        this.predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        editConfiguration.setFormUrl(formUrl);
        editConfiguration.setVarNameForSubject("subject");
        editConfiguration.setSubjectUri(this.subjectUri);
        editConfiguration.setEntityToReturnTo(this.subjectUri);
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setPredicateUri(this.predicateUri);
        this.initDataParameters(vreq, session);
        this.processDataPropForm(vreq, editConfiguration);
    }

    private void initDataParameters(VitroRequest vreq, HttpSession session) {
        this.dataHash = EditConfigurationUtils.getDataHash(vreq);
    }

    private void processDataPropForm(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        editConfiguration.setDatapropKey(EditConfigurationUtils.getDataHash(vreq));
        editConfiguration.setVarNameForObject(this.literalName);
    }

    private List<String> generateN3Required(VitroRequest vreq) {
        ArrayList<String> n3ForEdit = new ArrayList<String>();
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        String editString = "?subject <" + predicateUri + "> ?label .";
        n3ForEdit.add(editString);
        return n3ForEdit;
    }

    private List<String> generateN3Optional() {
        ArrayList<String> n3Inverse = new ArrayList<String>();
        return n3Inverse;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap<String, List<Literal>>());
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add(this.literalName);
        editConfiguration.setUrisOnform(urisOnForm);
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap<String, String>());
        editConfiguration.setSparqlForAdditionalUrisInScope(new HashMap<String, String>());
        editConfiguration.setSparqlForExistingLiterals(this.generateSparqlForExistingLiterals());
        editConfiguration.setSparqlForExistingUris(this.generateSparqlForExistingUris());
    }

    private HashMap<String, String> generateSparqlForExistingUris() {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    private HashMap<String, String> generateSparqlForExistingLiterals() {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    private void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        HashMap<String, FieldVTwo> fields = new HashMap();
        fields = this.getDataPropertyField(editConfiguration, vreq);
        editConfiguration.setFields(fields);
    }

    private Map<String, FieldVTwo> getDataPropertyField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, FieldVTwo> fields = new HashMap<String, FieldVTwo>();
        FieldVTwo field = new FieldVTwo();
        field.setName(this.literalName);
        String rangeDatatypeUri = this.getRangeDatatypeUri(editConfiguration, vreq);
        String rangeLang = this.getRangeLang(editConfiguration, vreq);
        List<String> validators = this.getFieldValidators(editConfiguration, vreq);
        field.setValidators(validators);
        field.setRangeDatatypeUri(rangeDatatypeUri);
        if (rangeDatatypeUri == null) {
            field.setRangeLang(rangeLang);
        }
        fields.put(field.getName(), field);
        return fields;
    }

    private String getRangeLang(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        String rangeLang = null;
        DataPropertyStatement dps = EditConfigurationUtils.getDataPropertyStatement(vreq, vreq.getSession(), this.dataHash, this.predicateUri);
        if (dps != null) {
            rangeLang = dps.getLanguage();
            if (rangeLang == null) {
                this.log.debug((Object)("no language attribute on rdfs:label statement for property " + this.predicateUri + "in RDFSLabelGenerator"));
                rangeLang = "";
            } else {
                this.log.debug((Object)("language attribute of [" + rangeLang + "] on rdfs:label statement for property " + this.predicateUri + "in RDFSLabelGenerator"));
            }
        }
        if (rangeLang != null && rangeLang.trim().length() == 0) {
            rangeLang = null;
        }
        return rangeLang;
    }

    private String getRangeDatatypeUri(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        Individual subject = EditConfigurationUtils.getSubjectIndividual(vreq);
        DataProperty prop = EditConfigurationUtils.getDataProperty(vreq);
        String rangeDatatypeUri = null;
        DataPropertyStatement dps = EditConfigurationUtils.getDataPropertyStatement(vreq, vreq.getSession(), this.dataHash, this.predicateUri);
        if (dps != null) {
            rangeDatatypeUri = dps.getDatatypeURI();
            if (rangeDatatypeUri == null) {
                this.log.debug((Object)("no range datatype uri set on rdfs:label statement for property " + this.predicateUri + "in RDFSLabelGenerator"));
            } else {
                this.log.debug((Object)("range datatype uri of [" + rangeDatatypeUri + "] on rdfs:label statement for property " + this.predicateUri + "in RDFSLabelGenerator"));
            }
        } else {
            this.log.debug((Object)("No incoming rdfs:label statement for property " + this.predicateUri + "; adding a new statement"));
            rangeDatatypeUri = XSD.xstring.getURI();
        }
        if (rangeDatatypeUri != null && rangeDatatypeUri.trim().length() == 0) {
            rangeDatatypeUri = null;
        }
        return rangeDatatypeUri;
    }

    private List<String> getFieldValidators(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        String rangeDatatypeUri;
        ArrayList<String> validatorList = new ArrayList<String>();
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        if (predicateUri.equals("http://www.w3.org/2000/01/rdf-schema#label") || predicateUri.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
            validatorList.add("nonempty");
        }
        if ((rangeDatatypeUri = this.getRangeDatatypeUri(editConfiguration, vreq)) != null && !rangeDatatypeUri.isEmpty()) {
            validatorList.add("datatype:" + rangeDatatypeUri);
        }
        return validatorList;
    }

    private void prepareForUpdate(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        OntModel model = ModelAccess.on(session.getServletContext()).getOntModel();
        if (editConfiguration.isDataPropertyUpdate()) {
            editConfiguration.prepareForDataPropUpdate((Model)model, vreq.getWebappDaoFactory().getDataPropertyDao());
        }
    }
}

