/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.controller;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.DirectRedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VitroModelSource;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.controller.ProcessRdfFormController;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="PostEditCleanupController", urlPatterns={"/postEditCleanupController"})
public class PostEditCleanupController
extends FreemarkerHttpServlet {
    private static Log log = LogFactory.getLog(PostEditCleanupController.class);

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        PostEditCleanupController.doPostEditCleanup(vreq);
        return PostEditCleanupController.doPostEditRedirect(vreq, null);
    }

    protected static ResponseValues doPostEditRedirect(VitroRequest vreq, String entityToReturnTo) {
        EditConfigurationVTwo editConfig = EditConfigurationVTwo.getConfigFromSession(vreq.getSession(), (HttpServletRequest)vreq);
        if (editConfig == null) {
            log.error((Object)"No edit configuration found in doPostEditRedirect()");
            return new RedirectResponseValues(UrlBuilder.getHomeUrl());
        }
        String returnURLParameter = vreq.getParameter("returnURL");
        if (returnURLParameter != null) {
            return new DirectRedirectResponseValues(returnURLParameter);
        }
        if (editConfig.getUrlToReturnTo() != null && !editConfig.getUrlToReturnTo().trim().isEmpty()) {
            return new DirectRedirectResponseValues(editConfig.getUrlToReturnTo());
        }
        if (entityToReturnTo == null) {
            MultiValueEditSubmission submission = new MultiValueEditSubmission(vreq.getParameterMap(), editConfig);
            entityToReturnTo = N3EditUtils.processEntityToReturnTo(editConfig, submission, vreq);
        }
        String urlPattern = ProcessRdfFormController.Utilities.getPostEditUrlPattern(vreq, editConfig);
        if (entityToReturnTo != null) {
            UrlBuilder.ParamMap paramMap = new UrlBuilder.ParamMap();
            paramMap.put("uri", entityToReturnTo);
            paramMap.put("extra", "true");
            String path = UrlBuilder.addParams(urlPattern, paramMap);
            path = path + PostEditCleanupController.getSpecialModelParam(vreq, editConfig);
            path = path + PostEditCleanupController.getPredicateAnchor((HttpServletRequest)vreq, editConfig);
            return new RedirectResponseValues(path);
        }
        if (!urlPattern.endsWith("individual") && !urlPattern.endsWith("entity")) {
            return new RedirectResponseValues(urlPattern);
        }
        if (editConfig.getSubjectUri() != null) {
            UrlBuilder.ParamMap paramMap = new UrlBuilder.ParamMap();
            paramMap.put("uri", editConfig.getSubjectUri());
            paramMap.put("extra", "true");
            String path = UrlBuilder.getPath(UrlBuilder.Route.INDIVIDUAL, paramMap);
            path = path + PostEditCleanupController.getSpecialModelParam(vreq, editConfig);
            path = path + PostEditCleanupController.getPredicateAnchor((HttpServletRequest)vreq, editConfig);
            return new RedirectResponseValues(path);
        }
        return new RedirectResponseValues(UrlBuilder.Route.LOGIN);
    }

    private static String getSpecialModelParam(VitroRequest vreq, EditConfigurationVTwo editConfig) {
        if (editConfig.getAboxModelId() != null && editConfig.getAboxModelId().equals(VitroModelSource.ModelName.DISPLAY.toString())) {
            return "&switchToDisplayModel=1";
        }
        return "";
    }

    public static void doPostEditCleanup(VitroRequest vreq) {
        EditConfigurationVTwo configuration = EditConfigurationVTwo.getConfigFromSession(vreq.getSession(), (HttpServletRequest)vreq);
        if (configuration == null) {
            return;
        }
        HttpSession session = vreq.getSession(false);
        if (session != null) {
            EditConfigurationVTwo editConfig = EditConfigurationVTwo.getConfigFromSession(session, (HttpServletRequest)vreq);
            MultiValueEditSubmission editSub = EditSubmissionUtils.getEditSubmissionFromSession(session, editConfig);
            EditSubmissionUtils.clearEditSubmissionInSession(session, editSub);
        }
    }

    public static String getPredicateAnchor(HttpServletRequest req, EditConfigurationVTwo config) {
        if (req == null || config == null) {
            return "";
        }
        String predicateLocalName = ProcessRdfFormController.Utilities.getPredicateLocalName(config);
        if (predicateLocalName != null && predicateLocalName.length() > 0) {
            String predicateAnchor = "#" + predicateLocalName;
            req.setAttribute("predicateAnchor", (Object)predicateAnchor);
            return predicateAnchor;
        }
        return "";
    }
}

