/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.solr;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineNotRespondingException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchQuery;
import edu.cornell.mannlib.vitro.webapp.searchengine.solr.SolrConversionUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;

public class SolrSearchEngine
implements SearchEngine {
    private HttpSolrServer queryEngine;
    private ConcurrentUpdateSolrServer updateEngine;

    @Override
    public void startup(Application application, ComponentStartupStatus css) {
        ServletContext ctx = application.getServletContext();
        String solrServerUrlString = ConfigurationProperties.getBean(ctx).getProperty("vitro.local.solr.url");
        if (solrServerUrlString == null) {
            css.fatal("Could not find vitro.local.solr.url in runtime.properties.  Vitro application needs the URL of a solr server that it can use to index its data. It should be something like http://localhost:${port}" + ctx.getContextPath() + "solr");
            return;
        }
        try {
            this.queryEngine = new HttpSolrServer(solrServerUrlString);
            this.queryEngine.setSoTimeout(10000);
            this.queryEngine.setConnectionTimeout(10000);
            this.queryEngine.setDefaultMaxConnectionsPerHost(100);
            this.queryEngine.setMaxTotalConnections(100);
            this.queryEngine.setMaxRetries(1);
            this.updateEngine = new ConcurrentUpdateSolrServer(solrServerUrlString, 100, 1);
            this.updateEngine.setConnectionTimeout(10000);
            this.updateEngine.setPollQueueTime(25);
            css.info("Set up the Solr search engine; URL = '" + solrServerUrlString + "'.");
        }
        catch (Exception e) {
            css.fatal("Could not set up the Solr search engine", e);
        }
    }

    @Override
    public void shutdown(Application application) {
        this.queryEngine.shutdown();
        this.updateEngine.shutdown();
    }

    @Override
    public void ping() throws SearchEngineException {
        try {
            this.queryEngine.ping();
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Solr server did not respond to ping.", (Exception)e);
        }
    }

    @Override
    public SearchInputDocument createInputDocument() {
        return new BaseSearchInputDocument();
    }

    @Override
    public void add(SearchInputDocument ... docs) throws SearchEngineException {
        this.add(Arrays.asList(docs));
    }

    @Override
    public void add(Collection<SearchInputDocument> docs) throws SearchEngineException {
        try {
            this.updateEngine.add(SolrConversionUtils.convertToSolrInputDocuments(docs), 100);
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Solr server failed to add documents " + docs, (Exception)e);
        }
    }

    @Override
    public void commit() throws SearchEngineException {
        try {
            this.updateEngine.commit();
            this.updateEngine.optimize();
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Failed to commit to Solr server.", (Exception)e);
        }
    }

    @Override
    public void commit(boolean wait) throws SearchEngineException {
        try {
            this.updateEngine.commit(wait, wait);
            this.updateEngine.optimize(wait, wait);
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Failed to commit to Solr server.", (Exception)e);
        }
    }

    @Override
    public void deleteById(String ... ids) throws SearchEngineException {
        this.deleteById(Arrays.asList(ids));
    }

    @Override
    public void deleteById(Collection<String> ids) throws SearchEngineException {
        try {
            this.updateEngine.deleteById(new ArrayList<String>(ids), 100);
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Solr server failed to delete documents: " + ids, (Exception)e);
        }
    }

    @Override
    public void deleteByQuery(String query) throws SearchEngineException {
        try {
            this.updateEngine.deleteByQuery(query, 100);
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Solr server failed to delete documents: " + query, (Exception)e);
        }
    }

    @Override
    public SearchQuery createQuery() {
        return new BaseSearchQuery();
    }

    @Override
    public SearchQuery createQuery(String queryText) {
        BaseSearchQuery query = new BaseSearchQuery();
        query.setQuery(queryText);
        return query;
    }

    @Override
    public SearchResponse query(SearchQuery query) throws SearchEngineException {
        try {
            SolrQuery solrQuery = SolrConversionUtils.convertToSolrQuery(query);
            QueryResponse response = this.queryEngine.query((SolrParams)solrQuery);
            return SolrConversionUtils.convertToSearchResponse(response);
        }
        catch (SolrServerException e) {
            throw this.appropriateException("Solr server failed to execute the query" + query, (Exception)((Object)e));
        }
    }

    @Override
    public int documentCount() throws SearchEngineException {
        SearchResponse response = this.query(this.createQuery("*:*"));
        return (int)response.getResults().getNumFound();
    }

    private SearchEngineException appropriateException(String message, Exception e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof SocketTimeoutException)) continue;
            return new SearchEngineNotRespondingException(message, e);
        }
        return new SearchEngineException(message, e);
    }
}

