/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.services.shortview;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewService;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.SparqlQueryDataGetter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class FakeApplicationOntologyService {
    private static final Log log = LogFactory.getLog(FakeApplicationOntologyService.class);
    public static final String FILE_OF_SHORT_VIEW_INFO = "/WEB-INF/resources/shortview_config.n3";
    private static final String NS = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#";
    private static final String HAS_TEMPLATE = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasTemplate";
    private static final String CUSTOM_VIEW = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#customViewForIndividual";
    private static final String APPLIES_TO = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#appliesToContext";
    private static final String HAS_DATA_GETTER = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasDataGetter";
    private static final String HAS_VIEW = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasCustomView";
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private final OntModel viewModel;
    private final Map<String, List<ViewSpec>> classUriToViewSpecs;
    private static final String PEOPLE_CLASSGROUP_URI = "http://vivoweb.org/ontology#vitroClassGrouppeople";

    public FakeApplicationOntologyService(ServletContext ctx) throws ShortViewConfigException {
        this.viewModel = this.createModelFromFile(ctx);
        Map<String, ViewSpec> viewSpecsByUri = this.createViewSpecs();
        this.classUriToViewSpecs = this.createClassMappings(viewSpecsByUri);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping: " + this.classUriToViewSpecs));
        }
    }

    public FakeApplicationOntologyService() {
        this.viewModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        this.classUriToViewSpecs = new HashMap<String, List<ViewSpec>>();
        log.debug((Object)"Created empty FakeApplicationOntologyService.");
    }

    private OntModel createModelFromFile(ServletContext ctx) throws ShortViewConfigException {
        InputStream stream = ctx.getResourceAsStream(FILE_OF_SHORT_VIEW_INFO);
        if (stream == null) {
            throw new ShortViewConfigException("The short view config file doesn't exist in the servlet context: '/WEB-INF/resources/shortview_config.n3'");
        }
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        try {
            m.read(stream, null, "N3");
        }
        catch (Exception e) {
            throw new ShortViewConfigException("Parsing error in the short view config file.", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.debug((Object)("Loaded " + m.size() + " statements"));
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ViewSpec> createViewSpecs() throws ShortViewConfigException {
        Property rdfType = this.viewModel.getProperty(RDF_TYPE);
        Property appliesTo = this.viewModel.getProperty(APPLIES_TO);
        Property dataGetter = this.viewModel.getProperty(HAS_DATA_GETTER);
        Property template = this.viewModel.getProperty(HAS_TEMPLATE);
        Resource customView = this.viewModel.getResource(CUSTOM_VIEW);
        try (ResIterator views = this.viewModel.listResourcesWithProperty(rdfType, (RDFNode)customView);){
            HashMap<String, ViewSpec> map = new HashMap<String, ViewSpec>();
            while (views.hasNext()) {
                Resource view = (Resource)views.next();
                List<String> contextNames = this.getDataPropertyValues(view, appliesTo, "context");
                List<ShortViewService.ShortViewContext> contexts = this.contextsFromNames(view, contextNames);
                List<String> dataGetterUris = this.getObjectPropertyValues(view, dataGetter, "data getter");
                String tn = this.getDataProperty(view, template);
                map.put(view.getURI(), new ViewSpec(view.getURI(), contexts, dataGetterUris, tn));
            }
            HashMap<String, ViewSpec> hashMap = map;
            return hashMap;
        }
    }

    private List<ShortViewService.ShortViewContext> contextsFromNames(Resource view, List<String> contextNames) throws ShortViewConfigException {
        ArrayList<ShortViewService.ShortViewContext> list = new ArrayList<ShortViewService.ShortViewContext>();
        for (String name : contextNames) {
            ShortViewService.ShortViewContext context = ShortViewService.ShortViewContext.fromString(name);
            if (context == null) {
                throw new ShortViewConfigException("Unrecognized context '" + name + "' for view '" + view.getURI() + "'");
            }
            list.add(context);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<ViewSpec>> createClassMappings(Map<String, ViewSpec> viewSpecsByUri) throws ShortViewConfigException {
        Property hasView = this.viewModel.getProperty(HAS_VIEW);
        try (StmtIterator stmts = this.viewModel.listStatements(null, hasView, (RDFNode)null);){
            HashMap<String, List<ViewSpec>> map = new HashMap<String, List<ViewSpec>>();
            while (stmts.hasNext()) {
                Statement s = (Statement)stmts.next();
                String classUri = s.getSubject().getURI();
                RDFNode node = s.getObject();
                if (!node.isResource()) {
                    throw new ShortViewConfigException("The hasCustomView property for '" + classUri + "' must be a resource.");
                }
                String viewUri = node.asResource().getURI();
                ViewSpec view = viewSpecsByUri.get(viewUri);
                if (view == null) {
                    throw new ShortViewConfigException("On '" + classUri + "', the view '" + viewUri + "' does not exist.");
                }
                if (!map.containsKey(classUri)) {
                    map.put(classUri, new ArrayList());
                }
                ((List)map.get(classUri)).add(view);
            }
            HashMap<String, List<ViewSpec>> hashMap = map;
            return hashMap;
        }
    }

    private String getDataProperty(Resource subject, Property predicate) throws ShortViewConfigException {
        Statement s = this.viewModel.getProperty(subject, predicate);
        if (s == null) {
            throw new ShortViewConfigException("The required property '" + predicate.getURI() + "' is not present for '" + subject.getURI() + "'");
        }
        RDFNode node = s.getObject();
        if (!node.isLiteral()) {
            throw new ShortViewConfigException("The value of '" + predicate.getURI() + "' for '" + subject.getURI() + "' must be a literal.");
        }
        return node.asLiteral().getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDataPropertyValues(Resource subject, Property predicate, String label) throws ShortViewConfigException {
        try (StmtIterator stmts = this.viewModel.listStatements(subject, predicate, (RDFNode)null);){
            ArrayList<String> list = new ArrayList<String>();
            while (stmts.hasNext()) {
                Statement stmt = (Statement)stmts.next();
                RDFNode node = stmt.getObject();
                if (!node.isLiteral()) {
                    throw new ShortViewConfigException("The " + label + " property for '" + subject.getURI() + "' must be a literal.");
                }
                list.add(node.asLiteral().getString());
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getObjectPropertyValues(Resource subject, Property predicate, String label) throws ShortViewConfigException {
        try (StmtIterator stmts = this.viewModel.listStatements(subject, predicate, (RDFNode)null);){
            ArrayList<String> list = new ArrayList<String>();
            while (stmts.hasNext()) {
                Statement stmt = (Statement)stmts.next();
                RDFNode node = stmt.getObject();
                if (!node.isResource()) {
                    throw new ShortViewConfigException("The " + label + " property for '" + subject.getURI() + "' must be a resource.");
                }
                list.add(node.asResource().getURI());
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }

    public TemplateAndDataGetters getShortViewProperties(VitroRequest vreq, Individual individual, String classUri, String contextName) {
        if (this.classUriToViewSpecs.containsKey(classUri)) {
            for (ViewSpec view : this.classUriToViewSpecs.get(classUri)) {
                for (ShortViewService.ShortViewContext context : view.getContexts()) {
                    if (!context.name().equalsIgnoreCase(contextName)) continue;
                    ArrayList<SparqlQueryDataGetter> dgList = new ArrayList<SparqlQueryDataGetter>();
                    for (String dgUri : view.getDataGetterUris()) {
                        dgList.add(new SparqlQueryDataGetter(vreq, (Model)this.viewModel, dgUri));
                    }
                    return new TemplateAndDataGetters(view.getTemplateName(), dgList.toArray(new DataGetter[0]));
                }
            }
        }
        if (ShortViewService.ShortViewContext.BROWSE.name().equals(contextName) && this.isClassInPeopleClassGroup(vreq.getWebappDaoFactory(), classUri)) {
            return new TemplateAndDataGetters("view-browse-people.ftl", new FakeVivoPeopleDataGetter(vreq, individual.getURI()));
        }
        return null;
    }

    private boolean isClassInPeopleClassGroup(WebappDaoFactory wadf, String classUri) {
        if (wadf == null) {
            log.debug((Object)"isClassInPeopleClassGroup: WebappDaoFactory is null.");
            return false;
        }
        VClassDao vcDao = wadf.getVClassDao();
        if (vcDao == null) {
            log.debug((Object)"isClassInPeopleClassGroup: VClassDao is null.");
            return false;
        }
        VClass vclass = vcDao.getVClassByURI(classUri);
        if (vclass == null) {
            log.debug((Object)"isClassInPeopleClassGroup: VClass is null.");
            return false;
        }
        String vclassGroupUri = vclass.getGroupURI();
        if (vclassGroupUri == null) {
            log.debug((Object)"isClassInPeopleClassGroup: vclassGroupUri is null.");
            return false;
        }
        boolean isPeople = PEOPLE_CLASSGROUP_URI.equals(vclassGroupUri);
        log.debug((Object)("isClassInPeopleClassGroup: isPeople = " + isPeople));
        return isPeople;
    }

    private static class FakeVivoPeopleDataGetter
    extends SparqlQueryDataGetter {
        private static String QUERY_STRING = "PREFIX obo: <http://purl.obolibrary.org/obo/> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#>  \nSELECT ?pt  \nWHERE {  \n    ?uri obo:ARG_2000028 ?vIndividual .  \n    ?vIndividual vcard:hasTitle ?vTitle . \n    ?vTitle vcard:title ?pt . \n} LIMIT 1";
        private static final String FAKE_VIVO_PEOPLE_DATA_GETTER_URI = "http://FakeVivoPeopleDataGetter";
        private static OntModel fakeDisplayModel = FakeVivoPeopleDataGetter.initializeFakeDisplayModel();
        private String individualUri;
        private VitroRequest vreq;
        private ServletContext ctx;

        private static OntModel initializeFakeDisplayModel() {
            OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
            Resource dataGetter = m.getResource(FAKE_VIVO_PEOPLE_DATA_GETTER_URI);
            Property queryProperty = m.getProperty("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#query");
            Property saveToVarProperty = m.getProperty("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar");
            m.add(dataGetter, queryProperty, QUERY_STRING);
            m.add(dataGetter, saveToVarProperty, "extra");
            return m;
        }

        public FakeVivoPeopleDataGetter(VitroRequest vreq, String individualUri) {
            super(vreq, (Model)fakeDisplayModel, FAKE_VIVO_PEOPLE_DATA_GETTER_URI);
            this.individualUri = individualUri;
            this.vreq = vreq;
            this.ctx = vreq.getSession().getServletContext();
        }

        @Override
        public Map<String, Object> getData(Map<String, Object> pageData) {
            HashMap<String, Object> parms = new HashMap<String, Object>();
            parms.put("uri", this.individualUri);
            return super.getData(parms);
        }
    }

    public class ShortViewConfigException
    extends Exception {
        public ShortViewConfigException(String message) {
            super(message);
        }

        public ShortViewConfigException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private class ViewSpec {
        private final String uri;
        private final List<ShortViewService.ShortViewContext> contexts;
        private final List<String> dataGetterUris;
        private final String templateName;

        public ViewSpec(String uri, List<ShortViewService.ShortViewContext> contexts, List<String> dataGetterUris, String templateName) {
            this.uri = uri;
            this.contexts = contexts;
            this.dataGetterUris = dataGetterUris;
            this.templateName = templateName;
        }

        public List<ShortViewService.ShortViewContext> getContexts() {
            return this.contexts;
        }

        public List<String> getDataGetterUris() {
            return this.dataGetterUris;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public String toString() {
            return "ViewSpec[uri='" + this.uri + "', contexts=" + this.contexts + ", dataGetterUris=" + this.dataGetterUris + ", templateName='" + this.templateName + "']";
        }
    }

    public static class TemplateAndDataGetters {
        private final String templateName;
        private final Set<DataGetter> dataGetters;

        public TemplateAndDataGetters(String templateName, DataGetter ... dataGetters) {
            this.templateName = templateName;
            this.dataGetters = new HashSet<DataGetter>(Arrays.asList(dataGetters));
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public Set<DataGetter> getDataGetters() {
            return this.dataGetters;
        }

        public String toString() {
            return "[template=" + this.templateName + ", dataGetters=" + this.dataGetters + "]";
        }
    }
}

