/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.PropertyType;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.WrappedInstance;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceWrapper {
    private static final Log log = LogFactory.getLog(InstanceWrapper.class);

    public static <T> WrappedInstance<T> wrap(Class<? extends T> concreteClass) throws InstanceWrapperException {
        T instance = InstanceWrapper.createInstance(concreteClass);
        HashSet<Method> validationMethods = new HashSet<Method>(InstanceWrapper.parseValidationAnnotations(concreteClass).values());
        Map<String, PropertyType.PropertyMethod> propertyMethods = new PropertyAnnotationsMap(concreteClass).byUri();
        return new WrappedInstance<T>(instance, propertyMethods, validationMethods);
    }

    private static <T> T createInstance(Class<? extends T> concreteClass) throws InstanceWrapperException {
        try {
            return concreteClass.newInstance();
        }
        catch (Exception e) {
            throw new InstanceWrapperException("Failed to create an instance.", e);
        }
    }

    private static Map<String, Method> parseValidationAnnotations(Class<?> clazz) throws InstanceWrapperException {
        if (Object.class.equals(clazz)) {
            return new HashMap<String, Method>();
        }
        Map<String, Method> methods = InstanceWrapper.parseValidationAnnotations(clazz.getSuperclass());
        for (Method method : clazz.getDeclaredMethods()) {
            String name = method.getName();
            if (methods.containsKey(name)) {
                Method m = methods.get(name);
                throw new InstanceWrapperException("Method " + name + " in " + method.getDeclaringClass().getName() + " overrides a validation method in " + m.getDeclaringClass().getName());
            }
            if (method.getAnnotation(Validation.class) == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new InstanceWrapperException("Validation method '" + method + "' should not have parameters.");
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                throw new InstanceWrapperException("Validation method '" + method + "' should return void.");
            }
            methods.put(name, method);
        }
        return methods;
    }

    public static class InstanceWrapperException
    extends Exception {
        public InstanceWrapperException(String message) {
            super(message);
        }

        public InstanceWrapperException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class PropertyAnnotationsMap {
        private Map<String, PropertyType.PropertyMethod> mapByUri = new HashMap<String, PropertyType.PropertyMethod>();
        private Map<String, PropertyType.PropertyMethod> mapByName = new HashMap<String, PropertyType.PropertyMethod>();

        public PropertyAnnotationsMap(Class<?> clazz) throws InstanceWrapperException {
            if (!Object.class.equals(clazz)) {
                this.populateTheMaps(clazz);
            }
        }

        private void populateTheMaps(Class<?> clazz) throws InstanceWrapperException {
            PropertyAnnotationsMap superMap = new PropertyAnnotationsMap(clazz.getSuperclass());
            this.mapByUri = superMap.byUri();
            this.mapByName = superMap.byName();
            for (Method method : clazz.getDeclaredMethods()) {
                String name = method.getName();
                Method matchByName = this.methodByName(name);
                if (matchByName != null) {
                    throw new InstanceWrapperException("Method " + name + " in " + clazz.getName() + " conflicts with a property method in " + matchByName.getDeclaringClass().getName());
                }
                Property annotation = method.getAnnotation(Property.class);
                if (annotation == null) continue;
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new InstanceWrapperException("Property method '" + method + "' should return void.");
                }
                if (method.getParameterTypes().length != 1) {
                    throw new InstanceWrapperException("Property method '" + method + "' must accept exactly one parameter.");
                }
                String uri = annotation.uri();
                Method matchByUri = this.methodByUri(uri);
                if (matchByUri != null) {
                    throw new InstanceWrapperException("Two property methods have the same URI value: " + matchByUri + ", and " + method);
                }
                if (annotation.minOccurs() < 0) {
                    throw new InstanceWrapperException("minOccurs must not be negative.");
                }
                if (annotation.maxOccurs() < annotation.minOccurs()) {
                    throw new InstanceWrapperException("maxOccurs must not be less than minOccurs.");
                }
                try {
                    PropertyType.PropertyMethod pm = PropertyType.createPropertyMethod(method, annotation);
                    this.mapByUri.put(uri, pm);
                    this.mapByName.put(name, pm);
                }
                catch (PropertyType.PropertyTypeException e) {
                    throw new InstanceWrapperException("Failed to create the PropertyMethod", e);
                }
            }
        }

        private Method methodByName(String name) {
            PropertyType.PropertyMethod pm = this.mapByName.get(name);
            return pm == null ? null : pm.getMethod();
        }

        private Method methodByUri(String name) {
            PropertyType.PropertyMethod pm = this.mapByUri.get(name);
            return pm == null ? null : pm.getMethod();
        }

        public Map<String, PropertyType.PropertyMethod> byUri() {
            return this.mapByUri;
        }

        public Map<String, PropertyType.PropertyMethod> byName() {
            return this.mapByName;
        }
    }
}

