/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.directives;

import edu.cornell.mannlib.vitro.webapp.web.directives.BaseTemplateDirectiveModel;
import edu.cornell.mannlib.vitro.webapp.web.widgets.Widget;
import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WidgetDirective
extends BaseTemplateDirectiveModel {
    private static final Log log = LogFactory.getLog(WidgetDirective.class);
    private static final String WIDGET_PACKAGE = "edu.cornell.mannlib.vitro.webapp.web.widgets";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String methodName;
        if (loopVars.length != 0) {
            throw new TemplateModelException("The dump directive doesn't allow loop variables.");
        }
        if (body != null) {
            throw new TemplateModelException("The dump directive doesn't allow nested content.");
        }
        Object nameParam = params.get("name");
        if (!(nameParam instanceof SimpleScalar)) {
            throw new TemplateModelException("Value of parameter 'name' must be a string.");
        }
        String widgetName = nameParam.toString();
        Object includeParam = params.get("include");
        if (includeParam == null) {
            methodName = "markup";
        } else {
            methodName = includeParam.toString();
            if (!"assets".equals(methodName)) {
                methodName = "markup";
            }
        }
        methodName = "do" + StringUtils.capitalize((String)methodName);
        try {
            String widgetClassName = "edu.cornell.mannlib.vitro.webapp.web.widgets." + StringUtils.capitalize((String)widgetName) + "Widget";
            Class<?> widgetClass = Class.forName(widgetClassName);
            Widget widget = (Widget)widgetClass.newInstance();
            Method method = widgetClass.getMethod(methodName, Environment.class, Map.class);
            String output = (String)method.invoke((Object)widget, env, params);
            String templateType = env.getDataModel().get("templateType").toString();
            if ("doMarkup".equals(methodName) && "body".equals(templateType)) {
                output = output + widgetClass.getMethod("doAssets", Environment.class, Map.class).invoke((Object)widget, env, params);
            }
            Writer out = env.getOut();
            out.write(output);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Widget " + widgetName + " not found."));
        }
        catch (IOException e) {
            log.error((Object)("Error writing output for widget " + widgetName), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error invoking widget " + widgetName), (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> help(String name) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("effect", "Add a reuseable block of markup and functionality to the template, with associated scripts and stylesheets injected into the page &lt;head&gt; element.");
        map.put("comments", "From a body template, insert widget directive in desired location with no include value or include=\"markup\". Both assets and markup will be included. From a page template, insert widget directive at top of template with include=\"assets\". Insert widget directive in desired location with no include value or include=\"markup\".");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "name of widget");
        params.put("include", "values: \"assets\" to include scripts and stylesheets associated with the widget; \"markup\" to include the markup. \"markup\" is default value, so does not need to be specified.");
        map.put("parameters", params);
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("<@" + name + " name=\"login\" /> (use in body and page templates where markup should be inserted)");
        examples.add("<@" + name + " name=\"login\" include=\"markup\" /> (same as example 1)");
        examples.add("<@" + name + " name=\"login\" include=\"assets\" /> (use at top of page template to get scripts and stylesheets inserted into the &lt;head&gt; element)");
        map.put("examples", examples);
        return map;
    }
}

