/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview;

import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.InvalidConfigurationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CustomListViewConfigFile {
    private static final Log log = LogFactory.getLog(CustomListViewConfigFile.class);
    private static final String TAG_CONSTRUCT = "query-construct";
    private static final String TAG_SELECT = "query-select";
    private static final String TAG_TEMPLATE = "template";
    private static final String TAG_POSTPROCESSOR = "postprocessor";
    private static final String TAG_COLLATED = "collated";
    private static final String TAG_CRITICAL = "critical-data-required";
    private static final String TAG_PRECISE = "precise-subquery";
    private final Element selectQueryElement;
    private final Set<String> constructQueries;
    private final String templateName;
    private final String postprocessorName;

    public CustomListViewConfigFile(Reader reader) throws InvalidConfigurationException {
        Document doc = this.parseDocument(reader);
        this.selectQueryElement = this.parseSelectQuery(doc);
        this.constructQueries = this.parseConstructQueries(doc);
        this.templateName = this.parseTemplateName(doc);
        this.postprocessorName = this.parsePostprocessorName(doc);
    }

    private Document parseDocument(Reader reader) throws InvalidConfigurationException {
        if (reader == null) {
            throw new InvalidConfigurationException("Config file reader is null.");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(reader));
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new InvalidConfigurationException("Problem with XML parser.", e);
        }
        catch (SAXException e) {
            throw new InvalidConfigurationException("Config file is not valid XML: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Unable to read config file.", e);
        }
    }

    private Element parseSelectQuery(Document doc) throws InvalidConfigurationException {
        Element element = this.getExactlyOneElement(doc, TAG_SELECT);
        this.elementMustNotBeEmpty(element);
        return element;
    }

    private Set<String> parseConstructQueries(Document doc) {
        HashSet<String> queries = new HashSet<String>();
        for (Element element : this.getElements(doc, TAG_CONSTRUCT)) {
            String content = element.getTextContent();
            if (content.trim().isEmpty()) continue;
            queries.add(content);
        }
        return queries;
    }

    private String parseTemplateName(Document doc) throws InvalidConfigurationException {
        Element element = this.getExactlyOneElement(doc, TAG_TEMPLATE);
        this.elementMustNotBeEmpty(element);
        return element.getTextContent();
    }

    private String parsePostprocessorName(Document doc) throws InvalidConfigurationException {
        Element element = this.getZeroOrOneElement(doc, TAG_POSTPROCESSOR);
        if (element == null) {
            return "";
        }
        return element.getTextContent();
    }

    private List<Element> getElements(Document doc, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nodes = doc.getElementsByTagName(tagName);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                list.add((Element)nodes.item(i));
            }
        }
        return list;
    }

    private Element getExactlyOneElement(Document doc, String tagName) throws InvalidConfigurationException {
        List<Element> elements = this.getElements(doc, tagName);
        if (elements.size() == 1) {
            return elements.get(0);
        }
        if (elements.isEmpty()) {
            throw new InvalidConfigurationException("Config file must contain a " + tagName + " element");
        }
        throw new InvalidConfigurationException("Config file may not contain more than one " + tagName + " element");
    }

    private Element getZeroOrOneElement(Document doc, String tagName) throws InvalidConfigurationException {
        List<Element> elements = this.getElements(doc, tagName);
        if (elements.size() == 1) {
            return elements.get(0);
        }
        if (elements.isEmpty()) {
            return null;
        }
        throw new InvalidConfigurationException("Config file may not contain more than one " + tagName + " element");
    }

    private void elementMustNotBeEmpty(Element element) throws InvalidConfigurationException {
        String contents = element.getTextContent();
        if (contents.trim().isEmpty()) {
            throw new InvalidConfigurationException("In a config file, the <" + element.getTagName() + "> element must not be empty.");
        }
    }

    private void removeChildElements(Element element, String tagName) {
        NodeList doomed = element.getElementsByTagName(tagName);
        for (int i = doomed.getLength() - 1; i >= 0; --i) {
            element.removeChild(doomed.item(i));
        }
    }

    public String getSelectQuery(boolean collated, boolean editing, boolean usePreciseSubquery) {
        Element cloned = (Element)this.selectQueryElement.cloneNode(true);
        if (!collated) {
            this.removeChildElements(cloned, TAG_COLLATED);
        }
        if (editing) {
            this.removeChildElements(cloned, TAG_CRITICAL);
        }
        if (!usePreciseSubquery) {
            this.removeChildElements(cloned, TAG_PRECISE);
        }
        return cloned.getTextContent();
    }

    public Set<String> getConstructQueries() {
        return this.constructQueries;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getPostprocessorName() {
        return this.postprocessorName;
    }

    public String toString() {
        return "CustomListViewConfigFile[selectQuery='" + this.formatXmlNode(this.selectQueryElement) + "', constructQueries=" + this.constructQueries + ", templateName='" + this.templateName + "', postprocessorName='" + this.postprocessorName + "']";
    }

    private String formatXmlNode(Node node) {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            t.transform(source, result);
            return sw.toString();
        }
        catch (TransformerException e) {
            return "Failed to format XML node: " + node.getTextContent();
        }
    }
}

