/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.edit;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ConstantFieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.SelectListGeneratorVTwo;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import edu.cornell.mannlib.vitro.webapp.web.beanswrappers.ReadOnlyBeansWrapper;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyStatementTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;

public class EditConfigurationTemplateModel
extends BaseTemplateModel {
    EditConfigurationVTwo editConfig;
    HashMap<String, Object> pageData = new HashMap();
    VitroRequest vreq;
    private Log log = LogFactory.getLog(EditConfigurationTemplateModel.class);
    private final I18nBundle i18n;

    public EditConfigurationTemplateModel(EditConfigurationVTwo editConfig, VitroRequest vreq) throws Exception {
        this.editConfig = editConfig;
        this.vreq = vreq;
        this.i18n = I18n.bundle((HttpServletRequest)vreq);
        this.retrieveEditData();
    }

    public String getEditKey() {
        return this.editConfig.getEditKey();
    }

    public boolean isUpdate() {
        return this.editConfig.isObjectPropertyUpdate();
    }

    public String getSubmitToUrl() {
        return this.getUrl(this.editConfig.getSubmitToUrl());
    }

    private void retrieveEditData() throws Exception {
        this.setFormTitle();
        this.setSubmitLabel();
        HashMap<String, Object> formSpecificData = this.editConfig.getFormSpecificData();
        if (formSpecificData != null) {
            this.pageData.putAll(formSpecificData);
        }
        this.populateDropdowns();
        this.populateGeneratedHtml();
    }

    private void populateDropdowns() throws Exception {
        WebappDaoFactory wdf = this.vreq.getWebappDaoFactory();
        for (String fieldName : this.editConfig.getFields().keySet()) {
            FieldVTwo field = this.editConfig.getField(fieldName);
            if (field.getFieldOptions() == null) {
                field.setOptions(new ConstantFieldOptions(new String[0]));
            }
            Map<String, String> optionsMap = SelectListGeneratorVTwo.getOptions(this.editConfig, fieldName, wdf);
            optionsMap = SelectListGeneratorVTwo.getSortedMap(optionsMap, field.getFieldOptions().getCustomComparator(), this.vreq);
            if (this.pageData.containsKey(fieldName)) {
                this.log.error((Object)("Check the edit configuration setup as pageData already contains " + fieldName + " and this will be overwritten now with empty collection"));
            }
            this.pageData.put(fieldName, optionsMap);
        }
    }

    private String getSelectedValue(String field) {
        String selectedValue = null;
        Map<String, List<String>> urisInScope = this.editConfig.getUrisInScope();
        if (urisInScope.containsKey(field)) {
            List<String> values = urisInScope.get(field);
            selectedValue = StringUtils.join(values, (String)",");
        }
        return selectedValue;
    }

    private void setFormTitle() {
        String predicateUri = this.editConfig.getPredicateUri();
        if (predicateUri != null) {
            if (EditConfigurationUtils.isObjectProperty(this.editConfig.getPredicateUri(), this.vreq)) {
                this.setObjectFormTitle();
            } else {
                this.setDataFormTitle();
            }
        }
    }

    private void setDataFormTitle() {
        String formTitle = "";
        DataProperty prop = EditConfigurationUtils.getDataProperty(this.vreq);
        if (prop != null) {
            formTitle = this.editConfig.isDataPropertyUpdate() ? this.i18n.text("change_text_for", new Object[0]) + " " + prop.getPublicName() : this.i18n.text("add_new_entry_for", new Object[0]) + " " + prop.getPublicName();
        }
        this.pageData.put("formTitle", formTitle);
    }

    private void setObjectFormTitle() {
        String formTitle = null;
        Individual objectIndividual = EditConfigurationUtils.getObjectIndividual(this.vreq);
        ObjectProperty prop = EditConfigurationUtils.getObjectProperty(this.vreq);
        Individual subject = EditConfigurationUtils.getSubjectIndividual(this.vreq);
        String propertyTitle = this.getObjectPropertyNameForDisplay();
        if (objectIndividual != null) {
            formTitle = this.i18n.text("change_entry_for", new Object[0]) + " " + propertyTitle;
        } else if (prop.getOfferCreateNewOption()) {
            this.log.debug((Object)("property set to offer \"create new\" option; custom form: [" + prop.getCustomEntryForm() + "]"));
            formTitle = this.i18n.text("add_an_entry_to", new Object[0]) + " " + propertyTitle + " " + this.i18n.text("for", new Object[0]) + " " + subject.getName();
        } else {
            formTitle = this.i18n.text("add_an_entry_to", new Object[0]) + " " + propertyTitle;
        }
        this.pageData.put("formTitle", formTitle);
    }

    public String getObjectPropertyNameForDisplay() {
        String propertyTitle = null;
        Individual objectIndividual = EditConfigurationUtils.getObjectIndividual(this.vreq);
        ObjectProperty prop = EditConfigurationUtils.getObjectProperty(this.vreq);
        Individual subject = EditConfigurationUtils.getSubjectIndividual(this.vreq);
        VClass rangeClass = EditConfigurationUtils.getRangeVClass(this.vreq);
        if (objectIndividual != null) {
            propertyTitle = prop.getDomainPublic();
        } else {
            WebappDaoFactory wdf = this.vreq.getWebappDaoFactory();
            if (prop.getOfferCreateNewOption()) {
                VClass classOfObjectFillers = null;
                if (rangeClass != null) {
                    classOfObjectFillers = rangeClass;
                } else if (prop.getRangeVClassURI() == null) {
                    List<VClass> classes = wdf.getVClassDao().getVClassesForProperty(subject.getVClassURI(), prop.getURI());
                    if (classes == null || classes.size() == 0 || classes.get(0) == null) {
                        classOfObjectFillers = wdf.getVClassDao().getTopConcept();
                    } else {
                        if (classes.size() > 1) {
                            this.log.debug((Object)"Found multiple classes when attempting to get range vclass.");
                        }
                        classOfObjectFillers = classes.get(0);
                    }
                } else {
                    classOfObjectFillers = wdf.getVClassDao().getVClassByURI(prop.getRangeVClassURI());
                    if (classOfObjectFillers == null) {
                        classOfObjectFillers = wdf.getVClassDao().getTopConcept();
                    }
                }
                propertyTitle = classOfObjectFillers.getName();
            } else {
                propertyTitle = prop.getDomainPublic();
            }
        }
        return propertyTitle;
    }

    private void setSubmitLabel() {
        String submitLabel = null;
        String predicateUri = this.editConfig.getPredicateUri();
        if (predicateUri != null) {
            if (EditConfigurationUtils.isObjectProperty(this.editConfig.getPredicateUri(), this.vreq)) {
                Individual objectIndividual = EditConfigurationUtils.getObjectIndividual(this.vreq);
                ObjectProperty prop = EditConfigurationUtils.getObjectProperty(this.vreq);
                submitLabel = objectIndividual != null ? this.i18n.text("save_changes", new Object[0]) : (prop.getOfferCreateNewOption() ? this.i18n.text("select_existing", new Object[0]) : this.i18n.text("save_entry", new Object[0]));
            } else {
                submitLabel = this.editConfig.isDataPropertyUpdate() ? this.i18n.text("save_changes", new Object[0]) : this.i18n.text("save_entry", new Object[0]);
            }
        }
        this.pageData.put("submitLabel", submitLabel);
    }

    public String getFormTitle() {
        return (String)this.pageData.get("formTitle");
    }

    public String getSubmitLabel() {
        return (String)this.pageData.get("submitLabel");
    }

    public Map<String, List<Literal>> getLiteralValues() {
        return this.editConfig.getLiteralsInScope();
    }

    public Map<String, List<String>> getObjectUris() {
        return this.editConfig.getUrisInScope();
    }

    public List<String> getLiteralStringValue(String key) {
        ArrayList<String> literalValues = new ArrayList<String>();
        Map<String, List<Literal>> literalsInScope = this.editConfig.getLiteralsInScope();
        if (literalsInScope.containsKey(key)) {
            List<Literal> ls = literalsInScope.get(key);
            for (Literal l : ls) {
                literalValues.add(l.getString());
            }
        }
        return literalValues;
    }

    public String dataLiteralValueFor(String dataLiteralName) {
        List<String> literalValues = this.getLiteralStringValue(dataLiteralName);
        return StringUtils.join(literalValues, (String)",");
    }

    public String testMethod(String testValue) {
        return testValue + "test";
    }

    public String getDataLiteralValuesAsString() {
        List<String> values = this.getDataLiteralValues();
        return StringUtils.join(values, (String)",");
    }

    public List<String> getDataLiteralValues() {
        String dataLiteral = this.getDataLiteral();
        List<String> literalValues = this.getLiteralStringValue(dataLiteral);
        return literalValues;
    }

    private String literalToString(Literal lit) {
        if (lit == null || lit.getValue() == null) {
            return "";
        }
        String value = lit.getValue().toString();
        if ("http://www.w3.org/2001/XMLSchema#anyURI".equals(lit.getDatatypeURI())) {
            try {
                value = URLDecoder.decode(value, "UTF8");
            }
            catch (UnsupportedEncodingException ex) {
                this.log.error((Object)ex);
            }
        }
        return value;
    }

    public Property getPredicateProperty() {
        String predicateUri = this.getPredicateUri();
        if (predicateUri != null) {
            if (EditConfigurationUtils.isObjectProperty(predicateUri, this.vreq)) {
                return EditConfigurationUtils.getObjectPropertyForPredicate(this.vreq, predicateUri);
            }
            return EditConfigurationUtils.getDataPropertyForPredicate(this.vreq, predicateUri);
        }
        return null;
    }

    public ObjectProperty getObjectPredicateProperty() {
        return EditConfigurationUtils.getObjectPropertyForPredicate(this.vreq, this.getPredicateUri());
    }

    public DataProperty getDataPredicateProperty() {
        return EditConfigurationUtils.getDataPropertyForPredicate(this.vreq, this.getPredicateUri());
    }

    public String getDataPredicatePublicDescription() {
        DataProperty dp = this.getDataPredicateProperty();
        return dp.getPublicDescription();
    }

    public String getPredicateUri() {
        return this.editConfig.getPredicateUri();
    }

    public String getSubjectUri() {
        return this.editConfig.getSubjectUri();
    }

    public String getSubjectName() {
        Individual subject = EditConfigurationUtils.getIndividual(this.vreq, this.getSubjectUri());
        return subject.getName();
    }

    public String getObjectUri() {
        return this.editConfig.getObject();
    }

    public String getDomainUri() {
        return EditConfigurationUtils.getDomainUri(this.vreq);
    }

    public String getRangeUri() {
        return EditConfigurationUtils.getRangeUri(this.vreq);
    }

    public String getDataLiteral() {
        List<String> literalsOnForm = this.editConfig.getLiteralsOnForm();
        String dataLiteralName = null;
        if (literalsOnForm.size() == 1) {
            dataLiteralName = literalsOnForm.get(0);
        }
        return dataLiteralName;
    }

    public String getVarNameForObject() {
        return this.editConfig.getVarNameForObject();
    }

    public String getPropertyPublicDescription() {
        return this.getObjectPredicateProperty().getPublicDescription();
    }

    public boolean getPropertySelectFromExisting() {
        return this.getObjectPredicateProperty().getSelectFromExisting();
    }

    public String getPropertyPublicDomainTitle() {
        ObjectProperty prop = EditConfigurationUtils.getObjectProperty(this.vreq);
        return prop.getDomainPublic();
    }

    public String getPropertyPublicName() {
        DataProperty prop = EditConfigurationUtils.getDataProperty(this.vreq);
        return prop.getPublicName();
    }

    public boolean getPropertyOfferCreateNewOption() {
        return this.getObjectPredicateProperty().getOfferCreateNewOption();
    }

    public String getPropertyName() {
        if (this.isObjectProperty()) {
            return this.getPropertyPublicDomainTitle().toLowerCase();
        }
        if (this.isDataProperty()) {
            return this.getPropertyPublicName();
        }
        return null;
    }

    public TemplateModel getObjectStatementDisplay() throws TemplateModelException {
        HashMap<String, String> statementDisplay = new HashMap<String, String>();
        String subjectUri = EditConfigurationUtils.getSubjectUri(this.vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(this.vreq);
        String objectUri = EditConfigurationUtils.getObjectUri(this.vreq);
        Map<String, String[]> params = this.vreq.getParameterMap();
        for (String key : params.keySet()) {
            String keyString = key;
            if (!keyString.startsWith("statement_")) continue;
            keyString = keyString.replaceFirst("statement_", "");
            String value = params.get(key)[0];
            statementDisplay.put(keyString, value);
        }
        if (statementDisplay.size() == 0) {
            return null;
        }
        String objectKey = this.vreq.getParameter("objectKey");
        statementDisplay.put(objectKey, objectUri);
        ObjectProperty predicate = new ObjectProperty();
        predicate.setURI(predicateUri);
        ObjectPropertyStatementTemplateModel osm = new ObjectPropertyStatementTemplateModel(subjectUri, predicate, objectKey, statementDisplay, null, this.vreq);
        ReadOnlyBeansWrapper wrapper = new ReadOnlyBeansWrapper();
        return wrapper.wrap(osm);
    }

    public TemplateModel getObjectPropertyStatementDisplayPropertyModel() throws TemplateModelException {
        Individual subject = EditConfigurationUtils.getSubjectIndividual(this.vreq);
        ObjectProperty op = EditConfigurationUtils.getObjectProperty(this.vreq);
        ArrayList<ObjectProperty> propList = new ArrayList<ObjectProperty>();
        propList.add(op);
        ObjectPropertyTemplateModel otm = ObjectPropertyTemplateModel.getObjectPropertyTemplateModel(op, subject, this.vreq, true, propList);
        ReadOnlyBeansWrapper wrapper = new ReadOnlyBeansWrapper();
        return wrapper.wrap(otm);
    }

    public String getDataStatementDisplay() {
        return this.getDataLiteralValuesFromParameter();
    }

    public String getCustomDeleteObjectUri() {
        return this.vreq.getParameter("deleteObjectUri");
    }

    public String getDeleteTemplate() {
        String templateName = this.vreq.getParameter("templateName");
        if (templateName == null || templateName.isEmpty()) {
            templateName = "propStatement-default.ftl";
        }
        return templateName;
    }

    private String getDataLiteralValuesFromParameter() {
        String dataValue = null;
        int dataHash = EditConfigurationUtils.getDataHash(this.vreq);
        DataPropertyStatement dps = EditConfigurationUtils.getDataPropertyStatement(this.vreq, this.vreq.getSession(), dataHash, EditConfigurationUtils.getPredicateUri(this.vreq));
        if (dps != null) {
            dataValue = dps.getData().trim();
        }
        return dataValue;
    }

    public Map<String, String> getOfferTypesCreateNew() {
        WebappDaoFactory wdf = this.vreq.getWebappDaoFactory();
        ObjectProperty op = wdf.getObjectPropertyDao().getObjectPropertyByURI(this.editConfig.getPredicateUri());
        Individual sub = wdf.getIndividualDao().getIndividualByURI(this.editConfig.getSubjectUri());
        VClass rangeClass = EditConfigurationUtils.getRangeVClass(this.vreq);
        List<VClass> vclasses = null;
        List<VClass> subjectVClasses = sub.getVClasses();
        if (subjectVClasses == null) {
            vclasses = wdf.getVClassDao().getAllVclasses();
        } else if (rangeClass != null) {
            ArrayList<VClass> rangeVClasses = new ArrayList<VClass>();
            vclasses = new ArrayList<VClass>();
            if (!rangeClass.isUnion()) {
                rangeVClasses.add(rangeClass);
            } else {
                rangeVClasses.addAll(rangeClass.getUnionComponents());
            }
            for (VClass rangeVClass : rangeVClasses) {
                if (rangeVClass.getGroupURI() != null) {
                    vclasses.add(rangeVClass);
                }
                List<String> subURIs = wdf.getVClassDao().getAllSubClassURIs(rangeVClass.getURI());
                for (String subClassURI : subURIs) {
                    VClass subClass = wdf.getVClassDao().getVClassByURI(subClassURI);
                    if (subClass == null || subClass.getGroupURI() == null) continue;
                    vclasses.add(subClass);
                }
            }
        } else {
            HashSet<String> vclassesURIs = new HashSet<String>();
            vclasses = new ArrayList<VClass>();
            for (VClass subjectVClass : subjectVClasses) {
                List<VClass> rangeVclasses = wdf.getVClassDao().getVClassesForProperty(subjectVClass.getURI(), op.getURI());
                if (rangeVclasses == null) continue;
                for (VClass v : rangeVclasses) {
                    if (vclassesURIs.contains(v.getURI()) || v.getGroupURI() == null) continue;
                    vclassesURIs.add(v.getURI());
                    vclasses.add(v);
                }
            }
        }
        if (vclasses.size() == 0) {
            List<VClass> allVClasses = wdf.getVClassDao().getAllVclasses();
            for (VClass v : allVClasses) {
                if (v.getGroupURI() == null) continue;
                vclasses.add(v);
            }
        }
        HashMap<String, String> types = new HashMap<String, String>();
        for (VClass vclass : vclasses) {
            String name = null;
            if (vclass.getPickListName() != null && vclass.getPickListName().length() > 0) {
                name = vclass.getPickListName();
            } else if (vclass.getName() != null && vclass.getName().length() > 0) {
                name = vclass.getName();
            } else if (vclass.getLocalNameWithPrefix() != null && vclass.getLocalNameWithPrefix().length() > 0) {
                name = vclass.getLocalNameWithPrefix();
            }
            if (name == null || name.length() <= 0) continue;
            types.put(vclass.getURI(), name);
        }
        return this.getSortedMap(types);
    }

    public Map<String, String> getSortedMap(Map<String, String> hmap) {
        ArrayList<String[]> objectsToSort = new ArrayList<String[]>(hmap.size());
        for (String key : hmap.keySet()) {
            String[] x = new String[]{key, hmap.get(key)};
            objectsToSort.add(x);
        }
        objectsToSort.sort(new MapComparator());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(objectsToSort.size());
        for (String[] pair : objectsToSort) {
            map.put(pair[0], pair[1]);
        }
        return map;
    }

    public boolean isDataProperty() {
        return EditConfigurationUtils.isDataProperty(this.getPredicateUri(), this.vreq);
    }

    public boolean isObjectProperty() {
        return EditConfigurationUtils.isObjectProperty(this.getPredicateUri(), this.vreq);
    }

    public String getUrlToReturnTo() {
        if (this.editConfig.getEntityToReturnTo() != null && !this.editConfig.getEntityToReturnTo().trim().isEmpty()) {
            UrlBuilder.ParamMap params = new UrlBuilder.ParamMap();
            params.put("uri", this.editConfig.getEntityToReturnTo());
            return UrlBuilder.getUrl(UrlBuilder.Route.INDIVIDUAL, params);
        }
        if (this.vreq.getParameter("urlPattern") != null) {
            return this.vreq.getParameter("urlPattern");
        }
        return UrlBuilder.Route.INDIVIDUAL.path();
    }

    public String getCurrentUrl() {
        return EditConfigurationUtils.getEditUrl(this.vreq) + "?" + this.vreq.getQueryString();
    }

    public String getMainEditUrl() {
        return EditConfigurationUtils.getEditUrl(this.vreq);
    }

    public String getCancelUrl() {
        String editKey = this.editConfig.getEditKey();
        String cancelURL = EditConfigurationUtils.getCancelUrlBase(this.vreq) + "?editKey=" + editKey + "&cancel=true";
        String returnURLParameter = this.vreq.getParameter("returnURL");
        if (returnURLParameter != null && !returnURLParameter.isEmpty()) {
            cancelURL = cancelURL + "&returnURL=" + returnURLParameter;
        }
        return cancelURL;
    }

    public String getDeleteProcessingUrl() {
        return this.vreq.getContextPath() + "/deletePropertyController";
    }

    public boolean isDeleteProhibited() {
        String deleteProhibited = this.vreq.getParameter("deleteProhibited");
        return deleteProhibited != null && !deleteProhibited.isEmpty();
    }

    public String getDatapropKey() {
        if (this.editConfig.getDatapropKey() == null) {
            return null;
        }
        return this.editConfig.getDatapropKey().toString();
    }

    public DataPropertyStatement getDataPropertyStatement() {
        int dataHash = EditConfigurationUtils.getDataHash(this.vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(this.vreq);
        return EditConfigurationUtils.getDataPropertyStatement(this.vreq, this.vreq.getSession(), dataHash, predicateUri);
    }

    public boolean getIncludeDeletionForm() {
        if (this.isDeleteProhibited()) {
            return false;
        }
        if (this.isObjectProperty()) {
            return this.editConfig.isObjectPropertyUpdate();
        }
        return this.editConfig.isDataPropertyUpdate();
    }

    public String getVitroNsProperty() {
        String vitroNsProp = this.vreq.getParameter("vitroNsProp");
        if (vitroNsProp == null) {
            vitroNsProp = "";
        }
        return vitroNsProp;
    }

    public HashMap<String, Object> getPageData() {
        return this.pageData;
    }

    public Map<String, List<String>> getExistingLiteralValues() {
        return EditConfigurationUtils.getExistingLiteralValues(this.vreq, this.editConfig);
    }

    public Map<String, List<String>> getExistingUriValues() {
        return this.editConfig.getUrisInScope();
    }

    public void populateGeneratedHtml() {
        HashMap<String, String> generatedHtml = new HashMap<String, String>();
        Map<String, FieldVTwo> fieldMap = this.editConfig.getFields();
        Set<String> keySet = fieldMap.keySet();
        for (String key : keySet) {
            FieldVTwo field = fieldMap.get(key);
            EditElementVTwo editElement = field.getEditElement();
            String fieldName = field.getName();
            if (editElement == null) continue;
            generatedHtml.put(fieldName, EditConfigurationUtils.generateHTMLForElement(this.vreq, fieldName, this.editConfig));
        }
        this.pageData.put("htmlForElements", generatedHtml);
    }

    private class MapComparator
    implements Comparator<String[]> {
        private MapComparator() {
        }

        @Override
        public int compare(String[] s1, String[] s2) {
            Collator collator = Collator.getInstance();
            if (s2 == null) {
                return 1;
            }
            if (s1 == null) {
                return -1;
            }
            if ("".equals(s1[0])) {
                return -1;
            }
            if ("".equals(s2[0])) {
                return 1;
            }
            if (s2[1] == null) {
                return 1;
            }
            if (s1[1] == null) {
                return -1;
            }
            return collator.compare(s1[1], s2[1]);
        }
    }
}

