/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.util;

import edu.cornell.mannlib.vedit.util.OperationUtils;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OperationUtils_CloneBeanTest
extends AbstractTestClass {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    Matcher<?> causedBy(Class<? extends Throwable> causeClass) {
        return new CausedByMatcher(causeClass);
    }

    @Test(expected=NullPointerException.class)
    public void nullArgument() {
        OperationUtils.cloneBean(null);
    }

    @Test(expected=NullPointerException.class)
    public void nullBean() {
        OperationUtils.cloneBean(null, SimpleSuccess.class, SimpleSuccess.class);
    }

    @Test(expected=NullPointerException.class)
    public void nullBeanClass() {
        OperationUtils.cloneBean((Object)new SimpleSuccess(), null, SimpleSuccess.class);
    }

    @Test(expected=NullPointerException.class)
    public void nullInterfaceClass() {
        OperationUtils.cloneBean((Object)new SimpleSuccess(), SimpleSuccess.class, null);
    }

    @Test(expected=IllegalAccessException.class)
    @Ignore(value="Why doesn't this throw an exception?")
    public void privateClass() {
        OperationUtils.cloneBean((Object)new PrivateClass());
    }

    @Test
    public void privateConstructor() {
        this.thrown.expect(this.causedBy(NoSuchMethodException.class));
        OperationUtils.cloneBean((Object)new PrivateConstructor());
    }

    @Test
    public void abstractClass() {
        this.thrown.expect(this.causedBy(InstantiationException.class));
        OperationUtils.cloneBean((Object)new ConcreteOfAbstractClass(), AbstractClass.class, AbstractClass.class);
    }

    @Test
    public void interfaceClass() {
        this.thrown.expect(this.causedBy(InstantiationException.class));
        OperationUtils.cloneBean((Object)new ConcreteOfInterfaceClass(), InterfaceClass.class, InterfaceClass.class);
    }

    @Test
    public void arrayClass() {
        this.thrown.expect(this.causedBy(NoSuchMethodException.class));
        OperationUtils.cloneBean((Object)new String[0]);
    }

    @Test
    public void primitiveTypeClass() {
        this.thrown.expect(this.causedBy(NoSuchMethodException.class));
        OperationUtils.cloneBean((Object)1, Integer.TYPE, Integer.TYPE);
    }

    @Test
    public void voidClass() {
        this.thrown.expect(this.causedBy(NoSuchMethodException.class));
        OperationUtils.cloneBean((Object)new Object(), Void.TYPE, Void.TYPE);
    }

    @Test
    public void noNullaryConstructor() {
        this.thrown.expect(this.causedBy(NoSuchMethodException.class));
        OperationUtils.cloneBean((Object)new NoNullaryConstructor(1));
    }

    @Test(expected=ExceptionInInitializerError.class)
    public void classThrowsExceptionWhenLoaded() {
        OperationUtils.cloneBean((Object)new ThrowsExceptionWhenLoaded());
    }

    @Test
    public void initializerThrowsException() {
        this.thrown.expect(this.causedBy(InvocationTargetException.class));
        OperationUtils.cloneBean((Object)"random object", InitializerThrowsException.class, InitializerThrowsException.class);
    }

    @Test
    public void wrongInterfaceClass() {
        this.thrown.expect(this.causedBy(IllegalArgumentException.class));
        OperationUtils.cloneBean((Object)new WrongConcreteClass(), WrongConcreteClass.class, WrongInterface.class);
    }

    @Test
    public void getThrowsException() {
        this.thrown.expect(this.causedBy(InvocationTargetException.class));
        OperationUtils.cloneBean((Object)new GetMethodThrowsException());
    }

    @Test
    public void setThrowsException() {
        this.thrown.expect(this.causedBy(InvocationTargetException.class));
        OperationUtils.cloneBean((Object)new SetMethodThrowsException());
    }

    @Test
    public void simpleSuccess() {
        this.expectSuccess(new SimpleSuccess().insertField("label", "a prize"));
    }

    @Test
    public void getButNoSet() {
        this.expectSuccess(new GetButNoSet().insertField("label", "shouldBeEqual"));
    }

    @Test
    public void getTakesParameters() {
        this.expectSuccess(new GetTakesParameters().insertField("label", "fine"));
    }

    @Test
    public void getReturnsVoid() {
        this.expectSuccess(new GetReturnsVoid().insertField("label", "fine"));
    }

    @Test
    public void getAndSetDontMatch() {
        this.expectSuccess(new GetAndSetDontMatch().insertField("label", "fine"));
    }

    @Test
    public void getIsStatic() {
        this.expectSuccess(new GetIsStatic().insertField("label", "fine").insertField("instanceJunk", "the junk"));
    }

    @Test
    public void getMethodIsPrivate() {
        this.expectSuccess(new GetMethodIsPrivate().insertField("label", "fine"));
    }

    @Test
    public void setMethodIsPrivate() {
        this.expectSuccess(new SetMethodIsPrivate().insertField("label", "fine"));
    }

    private void expectSuccess(BeanBase original) {
        BeanBase cloned = (BeanBase)OperationUtils.cloneBean((Object)original);
        Assert.assertEquals((String)"Simple success", (Object)original, (Object)cloned);
    }

    public static class SetMethodIsPrivate
    extends SimpleSuccess {
        public String getJunk() {
            return "the junk";
        }

        private void setJunk(String junk) {
            this.insertField("instanceJunk", junk);
        }
    }

    public static class GetMethodIsPrivate
    extends SimpleSuccess {
        private String getJunk() {
            return "the junk";
        }

        public void setJunk(String junk) {
            this.insertField("instanceJunk", junk);
        }
    }

    public static class GetIsStatic
    extends SimpleSuccess {
        public static String getJunk() {
            return "the junk";
        }

        public void setJunk(String junk) {
            this.insertField("instanceJunk", junk);
        }
    }

    public static class GetAndSetDontMatch
    extends SimpleSuccess {
        public String getJunk() {
            throw new UnsupportedOperationException();
        }

        public void setJunk(Integer junk) {
            throw new UnsupportedOperationException();
        }
    }

    public static class GetReturnsVoid
    extends SimpleSuccess {
        public void getJunk() {
            throw new UnsupportedOperationException();
        }

        public void setJunk(String junk) {
            throw new UnsupportedOperationException();
        }
    }

    public static class GetTakesParameters
    extends SimpleSuccess {
        public String getJunk(String why) {
            throw new UnsupportedOperationException();
        }

        public void setJunk(String junk) {
            throw new UnsupportedOperationException();
        }
    }

    public static class GetButNoSet
    extends SimpleSuccess {
        public String getJunk() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SimpleSuccess
    extends BeanBase {
        public String getLabel() {
            return (String)this.fields.get("label");
        }

        public void setLabel(String label) {
            this.insertField("label", label);
        }
    }

    public static abstract class BeanBase {
        protected final Map<String, Object> fields = new HashMap<String, Object>();

        public BeanBase insertField(String key, Object value) {
            if (value != null) {
                this.fields.put(key, value);
            }
            return this;
        }

        public int hashCode() {
            return this.fields.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            return this.fields.equals(((BeanBase)o).fields);
        }

        public String toString() {
            return this.getClass().getSimpleName() + this.fields;
        }
    }

    public static class SetMethodThrowsException {
        private String junk = "junk";

        public String getJunk() {
            return this.junk;
        }

        public void setJunk(String junk) {
            throw new UnsupportedOperationException();
        }
    }

    public static class GetMethodThrowsException {
        private String junk = "junk";

        public String getJunk() {
            throw new UnsupportedOperationException();
        }

        public void setJunk(String junk) {
            this.junk = junk;
        }
    }

    public static interface WrongInterface {
        public String getJunk();

        public void setJunk(String var1);
    }

    public static class WrongConcreteClass {
        private String junk = "junk";

        public String getJunk() {
            return this.junk;
        }

        private void setJunk(String junk) {
            this.junk = junk;
        }
    }

    public static class InitializerThrowsException {
        public InitializerThrowsException() {
            throw new IllegalStateException("Initializer throws exception");
        }
    }

    public static class ThrowsExceptionWhenLoaded {
        static {
            throw new IllegalArgumentException();
        }
    }

    public static class NoNullaryConstructor {
        public NoNullaryConstructor(int i) {
        }
    }

    public static class ConcreteOfInterfaceClass
    extends InterfaceClass {
    }

    public static abstract class InterfaceClass {
    }

    public static class ConcreteOfAbstractClass
    extends AbstractClass {
    }

    public static abstract class AbstractClass {
    }

    private static class PrivateConstructor {
        private PrivateConstructor() {
        }
    }

    private static class PrivateClass {
    }

    class CausedByMatcher
    extends BaseMatcher<Throwable> {
        private final Class<? extends Throwable> causeClass;

        public CausedByMatcher(Class<? extends Throwable> causeClass) {
            this.causeClass = causeClass;
        }

        public boolean matches(Object actualThrowable) {
            if (!(actualThrowable instanceof RuntimeException)) {
                return false;
            }
            Throwable cause = ((RuntimeException)actualThrowable).getCause();
            return this.causeClass.isInstance(cause);
        }

        public void describeTo(Description d) {
            d.appendText("RuntimeException caused by " + this.causeClass.getName());
        }
    }
}

