/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier.factory;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasPermission;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.HasPermissionFactory;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.PermissionRegistry;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class HasPermissionFactoryTest
extends AbstractTestClass {
    private static final String USER_URI = "http://userUri";
    private UserAccount user;
    private LoginStatusBean lsb;
    private PermissionSet emptyPublicPermissionSet;
    private PermissionSet publicPermissionSet1;
    private PermissionSet publicPermissionSet2;
    private PermissionSet emptyLoggedInPermissionSet;
    private PermissionSet loggedInPermissionSet1;
    private PermissionSet loggedInPermissionSet2;
    private Permission permissionP1a;
    private Permission permissionP1b;
    private Permission permissionP2;
    private Permission permissionLI1;
    private Permission permissionLI2a;
    private Permission permissionLI2b;
    private WebappDaoFactoryStub wdf;
    private UserAccountsDaoStub uaDao;
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    private HasPermissionFactory factory;
    private IdentifierBundle actualIds;
    private IdentifierBundle expectedIds;

    @Before
    public void setup() {
        this.user = new UserAccount();
        this.user.setUri(USER_URI);
        this.lsb = new LoginStatusBean(USER_URI, LoginStatusBean.AuthenticationSource.INTERNAL);
        this.uaDao = new UserAccountsDaoStub();
        this.uaDao.addUser(this.user);
        this.wdf = new WebappDaoFactoryStub();
        this.wdf.setUserAccountsDao(this.uaDao);
        this.ctx = new ServletContextStub();
        new ModelAccessFactoryStub().get(this.ctx).setWebappDaoFactory(this.wdf);
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(this.session);
        this.factory = new HasPermissionFactory((ServletContext)this.ctx);
        this.preparePermissions();
        this.preparePermissionSets();
    }

    private void preparePermissions() {
        this.permissionP1a = new MyPermission("permissionP1a");
        this.permissionP1b = new MyPermission("permissionP1b");
        this.permissionP2 = new MyPermission("permissionP2");
        this.permissionLI1 = new MyPermission("permissionLI1");
        this.permissionLI2a = new MyPermission("permissionLI2a");
        this.permissionLI2b = new MyPermission("permissionLI2b");
        PermissionRegistry.createRegistry((ServletContext)this.ctx, this.list(this.permissionP1a, this.permissionP1b, this.permissionP2, this.permissionLI1, this.permissionLI2a, this.permissionLI2b));
    }

    private void preparePermissionSets() {
        this.emptyPublicPermissionSet = new PermissionSet();
        this.emptyPublicPermissionSet.setUri("java:emptyPS");
        this.emptyPublicPermissionSet.setLabel("emptyPublicPermissionSet");
        this.emptyPublicPermissionSet.setForPublic(Boolean.valueOf(true));
        this.publicPermissionSet1 = new PermissionSet();
        this.publicPermissionSet1.setUri("java:publicPS1");
        this.publicPermissionSet1.setLabel("publicPermissionSet1");
        this.publicPermissionSet1.setForPublic(Boolean.valueOf(true));
        this.setPermissions(this.publicPermissionSet1, this.permissionP1a, this.permissionP1b);
        this.publicPermissionSet2 = new PermissionSet();
        this.publicPermissionSet2.setUri("java:publicPS2");
        this.publicPermissionSet2.setLabel("publicPermissionSet2");
        this.publicPermissionSet2.setForPublic(Boolean.valueOf(true));
        this.setPermissions(this.publicPermissionSet2, this.permissionP2);
        this.emptyLoggedInPermissionSet = new PermissionSet();
        this.emptyLoggedInPermissionSet.setUri("java:emptyPS");
        this.emptyLoggedInPermissionSet.setLabel("emptyLoggedInPermissionSet");
        this.loggedInPermissionSet1 = new PermissionSet();
        this.loggedInPermissionSet1.setUri("java:loggedInPS1");
        this.loggedInPermissionSet1.setLabel("loggedInPermissionSet1");
        this.setPermissions(this.loggedInPermissionSet1, this.permissionLI1);
        this.loggedInPermissionSet2 = new PermissionSet();
        this.loggedInPermissionSet2.setUri("java:loggedInPS2");
        this.loggedInPermissionSet2.setLabel("loggedInPermissionSet2");
        this.setPermissions(this.loggedInPermissionSet2, this.permissionLI2a, this.permissionLI2b);
        this.uaDao.addPermissionSet(this.emptyLoggedInPermissionSet);
        this.uaDao.addPermissionSet(this.loggedInPermissionSet1);
        this.uaDao.addPermissionSet(this.loggedInPermissionSet2);
    }

    @Test
    public void notLoggedInNoPublicSets() {
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[0]);
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"no public sets", (Object)this.expectedIds, (Object)this.actualIds);
    }

    @Test
    public void notLoggedInEmptyPublicSet() {
        this.uaDao.addPermissionSet(this.emptyPublicPermissionSet);
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[0]);
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"empty public set", (Object)this.expectedIds, (Object)this.actualIds);
    }

    @Test
    public void notLoggedInOnePublicSet() {
        this.uaDao.addPermissionSet(this.publicPermissionSet1);
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[]{this.id(this.permissionP1a), this.id(this.permissionP1b)});
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        this.assertEqualIds("one public set", this.expectedIds, this.actualIds);
    }

    @Test
    public void notLoggedInTwoPublicSets() {
        this.uaDao.addPermissionSet(this.publicPermissionSet1);
        this.uaDao.addPermissionSet(this.publicPermissionSet2);
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[]{this.id(this.permissionP1a), this.id(this.permissionP1b), this.id(this.permissionP2)});
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        this.assertEqualIds("two public sets", this.expectedIds, this.actualIds);
    }

    @Test
    public void loggedInNoSets() {
        LoginStatusBean.setBean((HttpSession)this.session, (LoginStatusBean)this.lsb);
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[0]);
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"no logged in sets", (Object)this.expectedIds, (Object)this.actualIds);
    }

    @Test
    public void loggedInEmptySet() {
        LoginStatusBean.setBean((HttpSession)this.session, (LoginStatusBean)this.lsb);
        this.user.setPermissionSetUris(this.list(this.emptyLoggedInPermissionSet.getUri()));
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[0]);
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        Assert.assertEquals((String)"empty logged in set", (Object)this.expectedIds, (Object)this.actualIds);
    }

    @Test
    public void loggedInOneSet() {
        LoginStatusBean.setBean((HttpSession)this.session, (LoginStatusBean)this.lsb);
        this.user.setPermissionSetUris(this.list(this.loggedInPermissionSet1.getUri()));
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[]{this.id(this.permissionLI1)});
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        this.assertEqualIds("one logged in set", this.expectedIds, this.actualIds);
    }

    @Test
    public void loggedInTwoSets() {
        LoginStatusBean.setBean((HttpSession)this.session, (LoginStatusBean)this.lsb);
        this.user.setPermissionSetUris(this.list(this.loggedInPermissionSet1.getUri(), this.loggedInPermissionSet2.getUri()));
        this.expectedIds = new ArrayIdentifierBundle(new Identifier[]{this.id(this.permissionLI1), this.id(this.permissionLI2a), this.id(this.permissionLI2b)});
        this.actualIds = this.factory.getIdentifierBundle((HttpServletRequest)this.req);
        this.assertEqualIds("two logged in sets", this.expectedIds, this.actualIds);
    }

    private void setPermissions(PermissionSet ps, Permission ... permissions) {
        ArrayList<String> uris = new ArrayList<String>();
        for (Permission p : permissions) {
            uris.add(p.getUri());
        }
        ps.setPermissionUris(uris);
    }

    private HasPermission id(Permission p) {
        return new HasPermission(p);
    }

    private <T> List<T> list(T ... elements) {
        ArrayList l = new ArrayList();
        Collections.addAll(l, elements);
        return l;
    }

    private void assertEqualIds(String message, IdentifierBundle expected, IdentifierBundle actual) {
        HashSet<HasPermission> expectedSet = new HashSet<HasPermission>();
        for (Identifier id : expected) {
            expectedSet.add((HasPermission)id);
        }
        HashSet<HasPermission> actualSet = new HashSet<HasPermission>();
        for (Identifier id : actual) {
            actualSet.add((HasPermission)id);
        }
        this.assertEqualSets(message, expectedSet, actualSet);
    }

    private static class MyPermission
    extends Permission {
        public MyPermission(String uri) {
            super(uri);
        }

        public boolean isAuthorized(RequestedAction whatToAuth) {
            return false;
        }
    }
}

