/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;
import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AuthenticatorStub
extends Authenticator {
    public static final String FACTORY_ATTRIBUTE_NAME = Authenticator.AuthenticatorFactory.class.getName();
    private final Map<String, UserAccount> usersByEmail = new HashMap<String, UserAccount>();
    private final Map<String, UserAccount> usersByExternalAuthId = new HashMap<String, UserAccount>();
    private final Map<String, List<String>> editingPermissions = new HashMap<String, List<String>>();
    private final Map<String, String> associatedUris = new HashMap<String, String>();
    private final List<String> recordedLogins = new ArrayList<String>();
    private final Map<String, String> newPasswords = new HashMap<String, String>();
    private HttpServletRequest request;

    private void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void addUser(UserAccount user) {
        this.usersByEmail.put(user.getEmailAddress(), user);
        String externalAuthId = user.getExternalAuthId();
        if (!externalAuthId.isEmpty()) {
            this.usersByExternalAuthId.put(user.getExternalAuthId(), user);
        }
    }

    public void addEditingPermission(String username, String personUri) {
        if (!this.editingPermissions.containsKey(username)) {
            this.editingPermissions.put(username, new ArrayList());
        }
        this.editingPermissions.get(username).add(personUri);
    }

    public void setAssociatedUri(String username, String individualUri) {
        this.associatedUris.put(username, individualUri);
    }

    public List<String> getRecordedLoginUsernames() {
        return this.recordedLogins;
    }

    public Map<String, String> getNewPasswordMap() {
        return this.newPasswords;
    }

    public UserAccount getAccountForInternalAuth(String emailAddress) {
        return this.usersByEmail.get(emailAddress);
    }

    public UserAccount getAccountForExternalAuth(String externalAuthId) {
        return this.usersByExternalAuthId.get(externalAuthId);
    }

    public boolean isUserPermittedToLogin(UserAccount userAccount) {
        return true;
    }

    public boolean md5HashIsNull(UserAccount userAccount) {
        if (userAccount != null) {
            return userAccount.getMd5Password().compareTo("") == 0 || userAccount.getMd5Password() == null;
        }
        return false;
    }

    public static String applyArgon2iEncodingStub(String raw) {
        Argon2 argon2 = Argon2Factory.create();
        try {
            return argon2.hash(200, 500, 1, raw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCurrentPasswordArgon2(UserAccount userAccount, String clearTextPassword) {
        if (userAccount == null) {
            return false;
        }
        if (clearTextPassword == null) {
            return false;
        }
        return AuthenticatorStub.verifyArgon2iHash((String)userAccount.getArgon2Password(), (String)clearTextPassword);
    }

    public boolean isCurrentPassword(UserAccount userAccount, String clearTextPassword) {
        if (userAccount == null) {
            return false;
        }
        return userAccount.getMd5Password().equals(Authenticator.applyMd5Encoding((String)clearTextPassword));
    }

    public List<String> getAssociatedIndividualUris(UserAccount userAccount) {
        ArrayList<String> uris = new ArrayList<String>();
        String emailAddress = userAccount.getEmailAddress();
        if (this.associatedUris.containsKey(emailAddress)) {
            uris.add(this.associatedUris.get(emailAddress));
        }
        if (this.editingPermissions.containsKey(emailAddress)) {
            uris.addAll((Collection<String>)this.editingPermissions.get(emailAddress));
        }
        return uris;
    }

    public void recordNewPassword(UserAccount userAccount, String newClearTextPassword) {
        this.newPasswords.put(userAccount.getEmailAddress(), newClearTextPassword);
    }

    public void recordLoginAgainstUserAccount(UserAccount userAccount, LoginStatusBean.AuthenticationSource authSource) throws Authenticator.LoginNotPermitted {
        if (!this.isUserPermittedToLogin(userAccount)) {
            throw new Authenticator.LoginNotPermitted();
        }
        this.recordedLogins.add(userAccount.getEmailAddress());
        LoginStatusBean lsb = new LoginStatusBean(userAccount.getUri(), authSource);
        LoginStatusBean.setBean((HttpSession)this.request.getSession(), (LoginStatusBean)lsb);
    }

    public void recordUserIsLoggedOut() {
        throw new RuntimeException("AuthenticatorStub.recordUserIsLoggedOut() not implemented.");
    }

    public boolean accountRequiresEditing(UserAccount userAccount) {
        throw new RuntimeException("AuthenticatorStub.accountRequiresEditing() not implemented.");
    }

    public static class Factory
    implements Authenticator.AuthenticatorFactory {
        private final AuthenticatorStub instance = new AuthenticatorStub();

        public AuthenticatorStub getInstance(HttpServletRequest request) {
            this.instance.setRequest(request);
            return this.instance;
        }
    }
}

