/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalysisContext;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalyzer;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestInfo;
import edu.cornell.mannlib.vitro.webapp.web.ContentType;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.beans.IndividualStub;
import stubs.edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalysisContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class IndividualRequestAnalyzerTest
extends AbstractTestClass {
    private static final String URL_HOME_PAGE = "http://vivo.mydomain.edu";
    private static final String URL_INDIVIDUAL_PAGE = "http://vivo.mydomain.edu/individual";
    private static final String DEFAULT_NAMESPACE = "http://vivo.mydomain.edu/individual/";
    private static final String ID_INDIVIDUAL_TEST = "testId";
    private static final String URI_INDIVIDUAL_TEST = "http://vivo.mydomain.edu/individual/testId";
    private static final String NETID_USER_TEST = "joeUser";
    private static final String ID_FILE_BYTESTREAM = "bytesId";
    private static final String URI_FILE_BYTESTREAM = "http://vivo.mydomain.edu/individual/bytesId";
    private static final String BYTESTREAM_FILENAME = "imageFilename.jpg";
    private static final String URL_BYTESTREAM_ALIAS = "http://vivo.mydomain.edu/file/bytesId/imageFilename.jpg";
    private IndividualRequestAnalyzer analyzer;
    private IndividualRequestAnalysisContextStub analysisContext;
    private HttpServletRequestStub req;
    private VitroRequest vreq;
    private IndividualRequestInfo requestInfo;
    private IndividualStub testIndividual;
    private IndividualStub bytestreamIndividual;

    @Before
    public void setup() {
        this.req = new HttpServletRequestStub();
        this.analysisContext = new IndividualRequestAnalysisContextStub(DEFAULT_NAMESPACE);
        this.testIndividual = new IndividualStub(URI_INDIVIDUAL_TEST);
        this.analysisContext.addIndividual(this.testIndividual);
        this.analysisContext.addProfilePage(NETID_USER_TEST, this.testIndividual);
        this.bytestreamIndividual = new IndividualStub(URI_FILE_BYTESTREAM);
        this.analysisContext.addIndividual(this.bytestreamIndividual);
        this.analysisContext.setAliasUrl(URI_FILE_BYTESTREAM, URL_BYTESTREAM_ALIAS);
    }

    @Test
    public void findIndividualByUriParameter() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URL_INDIVIDUAL_PAGE));
        this.req.addParameter("uri", URI_INDIVIDUAL_TEST);
        this.analyzeIt();
        this.assertDefaultRequestInfo("find by URI parameter", URI_INDIVIDUAL_TEST);
    }

    @Test
    public void findIndividualByNetIdParameter() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URL_INDIVIDUAL_PAGE));
        this.req.addParameter("netId", NETID_USER_TEST);
        this.analyzeIt();
        this.assertDefaultRequestInfo("find by netId parameter", URI_INDIVIDUAL_TEST);
    }

    @Test
    public void findIndividualByNetidParameter() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URL_INDIVIDUAL_PAGE));
        this.req.addParameter("netid", NETID_USER_TEST);
        this.analyzeIt();
        this.assertDefaultRequestInfo("find by netid parameter", URI_INDIVIDUAL_TEST);
    }

    @Test
    public void findIndividualByDisplayPath() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url("http://vivo.mydomain.edu/display/testId"));
        this.analyzeIt();
        this.assertDefaultRequestInfo("find by display path", URI_INDIVIDUAL_TEST);
    }

    @Test
    public void unrecognizedPath() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url("http://vivo.mydomain.edu/individual/this/that/theOther"));
        this.analyzeIt();
        this.assertNoIndividualRequestInfo("unrecognized path");
    }

    @Test
    public void findNoSuchIndividualByDisplayPath() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url("http://vivo.mydomain.edu/display/bogusID"));
        this.analyzeIt();
        this.assertNoIndividualRequestInfo("unrecognized ID");
    }

    @Test
    public void redirectAFileBytestreamIndividual() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url("http://vivo.mydomain.edu/display/bytesId"));
        this.analyzeIt();
        this.assertBytestreamRedirectInfo("bytestream redirect", URL_BYTESTREAM_ALIAS);
    }

    @Test
    public void redirectFromLinkedDataPathAcceptRdf() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URI_INDIVIDUAL_TEST));
        this.req.setHeader("accept", "application/rdf+xml");
        this.analyzeIt();
        this.assertRdfRedirectRequestInfo("by linked data path, accept RDF", this.redirectUrlForRdfStream(ID_INDIVIDUAL_TEST, ".rdf"));
    }

    @Test
    public void redirectFromLinkedDataPathAcceptN3() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URI_INDIVIDUAL_TEST));
        this.req.setHeader("accept", "text/n3");
        this.analyzeIt();
        this.assertRdfRedirectRequestInfo("by linked data path, accept N3", this.redirectUrlForRdfStream(ID_INDIVIDUAL_TEST, ".n3"));
    }

    @Test
    public void redirectFromLinkedDataPathAcceptTurtle() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URI_INDIVIDUAL_TEST));
        this.req.setHeader("accept", "text/turtle");
        this.analyzeIt();
        this.assertRdfRedirectRequestInfo("by linked data path, accept TTL", this.redirectUrlForRdfStream(ID_INDIVIDUAL_TEST, ".ttl"));
    }

    @Test
    public void redirectFromLinkedDataPathNoAccept() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URI_INDIVIDUAL_TEST));
        this.analyzeIt();
        this.assertRdfRedirectRequestInfo("by linked data path with no accept", "/display/testId");
    }

    @Test
    public void redirectFromLinkedDataPathAcceptStrange() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URI_INDIVIDUAL_TEST));
        this.req.setHeader("accept", "image/jpg");
        this.analyzeIt();
        this.assertRdfRedirectRequestInfo("by linked data path, accept a strange content type", "/display/testId");
    }

    @Test
    public void redirectFromLinkedDataPathAcceptGarbage() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URI_INDIVIDUAL_TEST));
        this.req.setHeader("accept", "a/b/c");
        this.analyzeIt();
        this.assertRdfRedirectRequestInfo("by linked data path, accept an unrecognized content type", "/display/testId");
    }

    @Test
    public void getRdfByUriAndFormatParameters() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URL_INDIVIDUAL_PAGE));
        this.req.addParameter("uri", URI_INDIVIDUAL_TEST);
        this.req.addParameter("format", "rdfxml");
        this.analyzeIt();
        this.assertLinkedDataRequestInfo("RDF by uri and format parameters", URI_INDIVIDUAL_TEST, ContentType.RDFXML);
    }

    @Test
    public void getN3ByUriAndFormatParameters() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URL_INDIVIDUAL_PAGE));
        this.req.addParameter("uri", URI_INDIVIDUAL_TEST);
        this.req.addParameter("format", "n3");
        this.analyzeIt();
        this.assertLinkedDataRequestInfo("N3 by uri and format parameters", URI_INDIVIDUAL_TEST, ContentType.N3);
    }

    @Test
    public void getTurtleByUriAndFormatParameters() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URL_INDIVIDUAL_PAGE));
        this.req.addParameter("uri", URI_INDIVIDUAL_TEST);
        this.req.addParameter("format", "ttl");
        this.analyzeIt();
        this.assertLinkedDataRequestInfo("Turtle by uri and format parameters", URI_INDIVIDUAL_TEST, ContentType.TURTLE);
    }

    @Test
    public void unrecognizedFormatParameter() {
        this.req.setRequestUrl(IndividualRequestAnalyzerTest.url(URL_INDIVIDUAL_PAGE));
        this.req.addParameter("uri", URI_INDIVIDUAL_TEST);
        this.req.addParameter("format", "bogus");
        this.analyzeIt();
        this.assertDefaultRequestInfo("unrecognized format means HTML response", URI_INDIVIDUAL_TEST);
    }

    @Test
    public void getRdfByStreamRequest() {
        this.req.setRequestUrl(this.absoluteUrlForRdfStream(ID_INDIVIDUAL_TEST, ".rdf"));
        this.analyzeIt();
        this.assertLinkedDataRequestInfo("RDF by stream request", URI_INDIVIDUAL_TEST, ContentType.RDFXML);
    }

    @Test
    public void getN3ByStreamRequest() {
        this.req.setRequestUrl(this.absoluteUrlForRdfStream(ID_INDIVIDUAL_TEST, ".n3"));
        this.analyzeIt();
        this.assertLinkedDataRequestInfo("N3 by stream request", URI_INDIVIDUAL_TEST, ContentType.N3);
    }

    @Test
    public void getTurtleByStreamRequest() {
        this.req.setRequestUrl(this.absoluteUrlForRdfStream(ID_INDIVIDUAL_TEST, ".ttl"));
        this.analyzeIt();
        this.assertLinkedDataRequestInfo("Turtle by stream request", URI_INDIVIDUAL_TEST, ContentType.TURTLE);
    }

    @Test
    public void unrecognizedFormatForRdfStreamRequest() {
        this.req.setRequestUrl(this.absoluteUrlForRdfStream(ID_INDIVIDUAL_TEST, ".bogus"));
        this.analyzeIt();
        this.assertNoIndividualRequestInfo("Unrecognized RDF stream request");
    }

    private String redirectUrlForRdfStream(String id, String extension) {
        return "/individual/" + id + "/" + id + extension;
    }

    private URL absoluteUrlForRdfStream(String id, String extension) {
        return IndividualRequestAnalyzerTest.url(DEFAULT_NAMESPACE + id + "/" + id + extension);
    }

    private void analyzeIt() {
        this.vreq = new VitroRequest((HttpServletRequest)this.req);
        this.analyzer = new IndividualRequestAnalyzer(this.vreq, (IndividualRequestAnalysisContext)this.analysisContext);
        this.requestInfo = this.analyzer.analyze();
    }

    private void assertDefaultRequestInfo(String message, String individualUri) {
        Assert.assertEquals((String)(message + ": expecting DEFAULT request type"), (Object)IndividualRequestInfo.Type.DEFAULT, (Object)this.requestInfo.getType());
        Assert.assertNotNull((String)(message + ": expected an individual"), (Object)this.requestInfo.getIndividual());
        Assert.assertEquals((String)(message + ": expected individual"), (Object)individualUri, (Object)this.requestInfo.getIndividual().getURI());
    }

    private void assertRdfRedirectRequestInfo(String message, String redirectUrl) {
        Assert.assertEquals((String)(message + ": expecting RDF_REDIRECT request type"), (Object)IndividualRequestInfo.Type.RDF_REDIRECT, (Object)this.requestInfo.getType());
        Assert.assertEquals((String)(message + ": expected redirect URL"), (Object)redirectUrl, (Object)this.requestInfo.getRedirectUrl());
    }

    private void assertBytestreamRedirectInfo(String message, String aliasUrl) {
        Assert.assertEquals((String)(message + ": expecting BYTESTREAM_REDIRECT request type"), (Object)IndividualRequestInfo.Type.BYTESTREAM_REDIRECT, (Object)this.requestInfo.getType());
        Assert.assertEquals((String)(message + ": expected alias URL"), (Object)aliasUrl, (Object)this.requestInfo.getRedirectUrl());
    }

    private void assertNoIndividualRequestInfo(String message) {
        Assert.assertEquals((String)(message + ": expecting NO_INDIVIDUAL request type"), (Object)IndividualRequestInfo.Type.NO_INDIVIDUAL, (Object)this.requestInfo.getType());
    }

    private void assertLinkedDataRequestInfo(String message, String individualUri, ContentType contentType) {
        Assert.assertEquals((String)(message + ": expecting LINKED_DATA request type"), (Object)IndividualRequestInfo.Type.LINKED_DATA, (Object)this.requestInfo.getType());
        Assert.assertNotNull((String)(message + ": expected an individual"), (Object)this.requestInfo.getIndividual());
        Assert.assertEquals((String)(message + ": expected individual"), (Object)individualUri, (Object)this.requestInfo.getIndividual().getURI());
        Assert.assertNotNull((String)(message + ": expected a content type"), (Object)this.requestInfo.getRdfFormat());
        Assert.assertEquals((String)(message + ": expected contentType"), (Object)contentType, (Object)this.requestInfo.getRdfFormat());
    }
}

