/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderTestBase;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.InstanceWrapper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.PropertyType;
import org.apache.jena.rdf.model.Statement;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationBeanLoader_PropertyTest
extends ConfigurationBeanLoaderTestBase {
    protected static final String OTHER_PROPERTY_URI = "http://mytest.edu/different_property";

    @Test
    public void propertyMethodHasNoParameter_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(NoParameterOnPropertyMethod.class)));
        this.expectSimpleFailure(NoParameterOnPropertyMethod.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "must accept exactly one parameter"));
    }

    @Test
    public void propertyMethodHasMultipleParameters_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(MultipleParametersOnPropertyMethod.class)));
        this.expectSimpleFailure(MultipleParametersOnPropertyMethod.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "must accept exactly one parameter"));
    }

    @Test
    public void propertyMethodHasInvalidParameter_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(InvalidParameterOnPropertyMethod.class)));
        this.expectSimpleFailure(InvalidParameterOnPropertyMethod.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "Failed to create the PropertyMethod"));
    }

    @Test
    public void propertyMethodDoesNotReturnVoid_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(PropertyMethodMustReturnVoid.class)));
        this.expectSimpleFailure(PropertyMethodMustReturnVoid.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "should return void"));
    }

    @Test
    public void propertyMethodNotAccessible_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(PropertyMethodIsPrivate.class)));
        this.model.add(ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "can't store in a private method."));
        this.expectSimpleFailure(PropertyMethodIsPrivate.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(PropertyType.PropertyTypeException.class, "Property method failed."));
    }

    @Test
    public void propertyMethodThrowsException_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(PropertyMethodFails.class)));
        this.model.add(ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "exception while loading."));
        this.expectSimpleFailure(PropertyMethodFails.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(PropertyType.PropertyTypeException.class, "Property method failed."));
    }

    @Test
    public void propertyMethodDuplicateUri_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(TwoMethodsWithSameUri.class)));
        this.expectSimpleFailure(TwoMethodsWithSameUri.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "methods have the same URI"));
    }

    @Test
    public void superclassContainsPropertyAnnotation_success() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(EmptyPropertyMethodSubclass.class)), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "Value")});
        EmptyPropertyMethodSubclass instance = (EmptyPropertyMethodSubclass)this.loader.loadInstance("http://mytest.edu/some_instance", EmptyPropertyMethodSubclass.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"Value", (Object)instance.value);
    }

    @Test
    public void propertyMethodOverridesPropertyMethod_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(PropertyMethodOverPropertyMethodSubclass.class)));
        this.expectSimpleFailure(PropertyMethodOverPropertyMethodSubclass.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "conflicts with a property method"));
    }

    @Test
    public void plainMethodOverridesPropertyMethod_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(PlainOverPropertyMethodSubclass.class)));
        this.expectSimpleFailure(PlainOverPropertyMethodSubclass.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "conflicts with a property method"));
    }

    @Test
    public void uriConflictsBetweenSubclassAndSuperclassPropertyMethods_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ConflictingUriPropertyMethodSubclass.class)));
        this.expectSimpleFailure(ConflictingUriPropertyMethodSubclass.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "Two property methods have the same URI"));
    }

    @Test
    public void propertyMethodSameNameButDoesNotOverride_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(DistinctPropertyMethodSubclass.class)), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "Value"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", OTHER_PROPERTY_URI, Float.valueOf(100.0f))});
        this.expectSimpleFailure(DistinctPropertyMethodSubclass.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "conflicts with a property method"));
    }

    public static class PlainOverPropertyMethodSubclass
    extends PropertyMethodSuperclass {
        public void propertySuper(Float f) {
        }
    }

    public static class PropertyMethodOverPropertyMethodSubclass
    extends EmptyPropertyMethodSubclass {
        @Override
        @Property(uri="http://mytest.edu/some_property")
        public void propertySuper(String v) {
        }
    }

    public static class ConflictingUriPropertyMethodSubclass
    extends PropertyMethodSuperclass {
        @Property(uri="http://mytest.edu/some_property")
        public void propertyConflict(String v) {
        }
    }

    public static class DistinctPropertyMethodSubclass
    extends PropertyMethodSuperclass {
        public float fvalue;

        @Property(uri="http://mytest.edu/different_property")
        public void propertySuper(Float f) {
            if ((double)this.fvalue != 0.0) {
                throw new RuntimeException("propertySub has already run.");
            }
            this.fvalue = f.floatValue();
        }
    }

    public static class EmptyPropertyMethodSubclass
    extends PropertyMethodSuperclass {
    }

    public static class PropertyMethodSuperclass {
        public String value = null;

        @Property(uri="http://mytest.edu/some_property")
        public void propertySuper(String v) {
            if (this.value != null) {
                throw new RuntimeException("propertySuper has already run.");
            }
            this.value = v;
        }
    }

    public static class TwoMethodsWithSameUri {
        @Property(uri="http://mytest.edu/some_property")
        public void firstProperty(String s) {
        }

        @Property(uri="http://mytest.edu/some_property")
        public void secondProperty(String s) {
        }
    }

    public static class PropertyMethodFails {
        @Property(uri="http://mytest.edu/some_property")
        public void methodThrowsException(String s) {
            throw new RuntimeException("property method fails.");
        }
    }

    public static class PropertyMethodIsPrivate {
        @Property(uri="http://mytest.edu/some_property")
        private void methodReturnIsNotVoid(String s) {
        }
    }

    public static class PropertyMethodMustReturnVoid {
        @Property(uri="http://mytest.edu/some_property")
        public String methodReturnIsNotVoid(String s) {
            return s;
        }
    }

    public static class InvalidParameterOnPropertyMethod {
        @Property(uri="http://mytest.edu/some_property")
        public void methodTakesInvalidParameters(byte b) {
        }
    }

    public static class MultipleParametersOnPropertyMethod {
        @Property(uri="http://mytest.edu/some_property")
        public void methodTakesMultipleParameters(String s, Float f) {
        }
    }

    public static class NoParameterOnPropertyMethod {
        @Property(uri="http://mytest.edu/some_property")
        public void methodTakesNoParameters() {
        }
    }
}

