/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.CustomListViewConfigFile;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.InvalidConfigurationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CustomListViewConfigFileTest
extends AbstractTestClass {
    private static final String XML_WITH_RICH_SELECT_CLAUSE = "<list-view-config><query-select>SELECT  <collated>collated1</collated>  <collated>collated2</collated>  <critical-data-required>critical</critical-data-required></query-select><template>template.ftl</template></list-view-config>";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private CustomListViewConfigFile configFile;

    @Test
    public void readerIsNull() throws InvalidConfigurationException {
        this.expectException("Config file reader is null.");
        this.configFile = new CustomListViewConfigFile(null);
    }

    @Test
    public void readerThrowsIOException() throws InvalidConfigurationException {
        this.expectException("Unable to read config file.");
        this.configFile = new CustomListViewConfigFile((Reader)new ExplodingReader());
    }

    @Test
    public void invalidXml() throws InvalidConfigurationException {
        this.suppressSyserr();
        this.expectException((Matcher<String>)CoreMatchers.containsString((String)"Config file is not valid XML:"));
        this.readConfigFile("<unbalancedTag>");
    }

    @Test
    public void selectQueryMissing() throws InvalidConfigurationException {
        this.expectException("Config file must contain a query-select element");
        this.readConfigFile("<list-view-config><template>template.ftl</template></list-view-config>");
    }

    @Test
    public void selectQueryMultiple() throws InvalidConfigurationException {
        this.expectException("Config file may not contain more than one query-select element");
        this.readConfigFile("<list-view-config><query-select>SELECT</query-select><query-select>ANOTHER</query-select><template>template.ftl</template></list-view-config>");
    }

    @Test
    public void selectQueryEmpty() throws InvalidConfigurationException {
        this.expectException("In a config file, the <query-select> element must not be empty.");
        this.readConfigFile("<list-view-config><query-select/><template>template.ftl</template></list-view-config>");
    }

    @Test
    public void templateNameMissing() throws InvalidConfigurationException {
        this.expectException("Config file must contain a template element");
        this.readConfigFile("<list-view-config><query-select>SELECT</query-select></list-view-config>");
    }

    @Test
    public void templateNameMultiple() throws InvalidConfigurationException {
        this.expectException("Config file may not contain more than one template element");
        this.readConfigFile("<list-view-config><query-select>SELECT</query-select><template>template.ftl</template><template>another.ftl</template></list-view-config>");
    }

    @Test
    public void templateNameEmpty() throws InvalidConfigurationException {
        this.expectException("In a config file, the <template> element must not be empty.");
        this.readConfigFile("<list-view-config><query-select>SELECT</query-select><template> </template></list-view-config>");
    }

    @Test
    public void postprocessorNameMultiple() throws InvalidConfigurationException {
        this.expectException("Config file may not contain more than one postprocessor element");
        this.readConfigFile("<list-view-config><query-select>SELECT</query-select><template>template.ftl</template><postprocessor>ONE</postprocessor><postprocessor>TWO</postprocessor></list-view-config>");
    }

    @Test
    public void minimalSuccess() throws InvalidConfigurationException {
        this.readConfigFile("<list-view-config><query-select>SELECT</query-select><template>template.ftl</template></list-view-config>");
        this.assertConfigFile(true, false, "SELECT", this.constructs(new String[0]), "template.ftl", "");
    }

    @Test
    public void maximalSuccess() throws InvalidConfigurationException {
        this.readConfigFile("<list-view-config><query-select>SELECT</query-select><query-construct>CONSTRUCT ONE</query-construct><query-construct>CONSTRUCT TWO</query-construct><template>template.ftl</template><postprocessor>post.processor.name</postprocessor></list-view-config>");
        this.assertConfigFile(true, false, "SELECT", this.constructs("CONSTRUCT ONE", "CONSTRUCT TWO"), "template.ftl", "post.processor.name");
    }

    @Test
    public void postprocessorEmptyIsOK() throws InvalidConfigurationException {
        this.readConfigFile("<list-view-config><query-select>SELECT</query-select><query-construct>CONSTRUCT</query-construct><template>template.ftl</template><postprocessor></postprocessor></list-view-config>");
        this.assertConfigFile(true, false, "SELECT", this.constructs("CONSTRUCT"), "template.ftl", "");
    }

    @Test
    public void selectCollatedEditing() throws InvalidConfigurationException {
        this.readConfigFile(XML_WITH_RICH_SELECT_CLAUSE);
        this.assertConfigFile(true, true, "SELECT  collated1  collated2  ", this.constructs(new String[0]), "template.ftl", "");
    }

    @Test
    public void selectCollatedNotEditing() throws InvalidConfigurationException {
        this.readConfigFile(XML_WITH_RICH_SELECT_CLAUSE);
        this.assertConfigFile(true, false, "SELECT  collated1  collated2  critical", this.constructs(new String[0]), "template.ftl", "");
    }

    @Test
    public void selectNotCollatedEditing() throws InvalidConfigurationException {
        this.readConfigFile(XML_WITH_RICH_SELECT_CLAUSE);
        this.assertConfigFile(false, true, "SELECT      ", this.constructs(new String[0]), "template.ftl", "");
    }

    @Test
    public void selectNotCollatedNotEditing() throws InvalidConfigurationException {
        this.readConfigFile(XML_WITH_RICH_SELECT_CLAUSE);
        this.assertConfigFile(false, false, "SELECT      critical", this.constructs(new String[0]), "template.ftl", "");
    }

    private void expectException(String message) {
        this.thrown.expect(InvalidConfigurationException.class);
        this.thrown.expectMessage(message);
    }

    private void expectException(Matcher<String> matcher) {
        this.thrown.expect(InvalidConfigurationException.class);
        this.thrown.expectMessage(matcher);
    }

    private void readConfigFile(String xmlString) throws InvalidConfigurationException {
        StringReader reader = new StringReader(xmlString);
        this.configFile = new CustomListViewConfigFile((Reader)reader);
    }

    private String[] constructs(String ... constructQueries) {
        return constructQueries;
    }

    private void assertConfigFile(boolean collated, boolean editing, String selectQuery, String[] constructQueries, String templateName, String postprocessorName) {
        Assert.assertEquals((String)"select query", (Object)selectQuery, (Object)this.configFile.getSelectQuery(collated, editing, true));
        Assert.assertEquals((String)"construct queries", new HashSet<String>(Arrays.asList(constructQueries)), (Object)this.configFile.getConstructQueries());
        Assert.assertEquals((String)"template name", (Object)templateName, (Object)this.configFile.getTemplateName());
        Assert.assertEquals((String)"postprocessor name", (Object)postprocessorName, (Object)this.configFile.getPostprocessorName());
    }

    private class ExplodingReader
    extends Reader {
        private ExplodingReader() {
        }

        @Override
        public int read(char[] arg0, int arg1, int arg2) throws IOException {
            throw new IOException("ExplodingReader threw an exception.");
        }

        @Override
        public void close() throws IOException {
        }
    }
}

