/*
 * Decompiled with CFR 0.152.
 */
package stubs.edu.cornell.mannlib.vitro.webapp.dao;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectPropertyStatementDaoStub
implements ObjectPropertyStatementDao {
    Set<CanonicalObjectPropertyStatement> statements = new HashSet<CanonicalObjectPropertyStatement>();

    public void addObjectPropertyStatement(String s, String p, String o) {
        this.statements.add(new CanonicalObjectPropertyStatement(s, p, o));
    }

    public int insertNewObjectPropertyStatement(ObjectPropertyStatement stmt) {
        if (stmt == null) {
            throw new NullPointerException("objPropertyStmt may not be null.");
        }
        this.statements.add(new CanonicalObjectPropertyStatement(stmt));
        return 0;
    }

    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectPropertyStatement stmt) {
        ArrayList<ObjectPropertyStatement> list = new ArrayList<ObjectPropertyStatement>();
        for (CanonicalObjectPropertyStatement cStmt : this.statements) {
            if (!cStmt.matches(stmt)) continue;
            list.add(cStmt);
        }
        return list;
    }

    public void deleteObjectPropertyStatement(ObjectPropertyStatement objPropertyStmt) {
        throw new RuntimeException("ObjectPropertyStatementDaoStub.deleteObjectPropertyStatement() not implemented.");
    }

    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectProperty objectProperty) {
        throw new RuntimeException("ObjectPropertyStatementDaoStub.getObjectPropertyStatements() not implemented.");
    }

    public List<ObjectPropertyStatement> getObjectPropertyStatements(ObjectProperty objectProperty, int startIndex, int endIndex) {
        throw new RuntimeException("ObjectPropertyStatementDaoStub.getObjectPropertyStatements() not implemented.");
    }

    public Individual fillExistingObjectPropertyStatements(Individual entity) {
        throw new RuntimeException("ObjectPropertyStatementDaoStub.fillExistingObjectPropertyStatements() not implemented.");
    }

    public List<Map<String, String>> getObjectPropertyStatementsForIndividualByProperty(String subjectUri, String propertyUri, String objectKey, String domainUri, String rangeUri, String query, Set<String> constructQueries, String sortDir) {
        throw new RuntimeException("ObjectPropertyStatementDaoStub.getObjectPropertyStatementsForIndividualByProperty() not implemented.");
    }

    public Map<String, String> getMostSpecificTypesInClassgroupsForIndividual(String subjectUri) {
        throw new RuntimeException("ObjectPropertyStatementDaoStub.getMostSpecificTypesInClassgroupsForIndividual() not implemented.");
    }

    public void resolveAsFauxPropertyStatements(List<ObjectPropertyStatement> list) {
        throw new RuntimeException("ObjectPropertyStatementDaoStub.resolveAsFauxPropertyStatements() not implemented.");
    }

    private static class CanonicalObjectPropertyStatement
    implements ObjectPropertyStatement {
        final String s;
        final String p;
        final String o;

        CanonicalObjectPropertyStatement(String s, String p, String o) {
            if (s == null) {
                throw new NullPointerException("statment subject may not be null.");
            }
            if (p == null) {
                throw new NullPointerException("statement predicate may not be null.");
            }
            if (o == null) {
                throw new NullPointerException("statement object may not be null.");
            }
            this.s = s;
            this.p = p;
            this.o = o;
        }

        CanonicalObjectPropertyStatement(ObjectPropertyStatement stmt) {
            this(stmt.getSubjectURI(), stmt.getPropertyURI(), stmt.getObjectURI());
        }

        public String getSubjectURI() {
            return this.s;
        }

        public void setSubjectURI(String subjectURI) {
            throw new UnsupportedOperationException();
        }

        public String getObjectURI() {
            return this.o;
        }

        public void setObjectURI(String objectURI) {
            throw new UnsupportedOperationException();
        }

        public Individual getSubject() {
            return null;
        }

        public void setSubject(Individual subject) {
            throw new UnsupportedOperationException();
        }

        public ObjectProperty getProperty() {
            return null;
        }

        public void setProperty(ObjectProperty property) {
            throw new UnsupportedOperationException();
        }

        public Individual getObject() {
            return null;
        }

        public void setObject(Individual object) {
            throw new UnsupportedOperationException();
        }

        public String getPropertyURI() {
            return this.p;
        }

        public void setPropertyURI(String URI2) {
            throw new UnsupportedOperationException();
        }

        public PropertyInstance toPropertyInstance() {
            return null;
        }

        public boolean matches(ObjectPropertyStatement stmt) {
            String otherS = stmt.getSubjectURI();
            String otherP = stmt.getPropertyURI();
            String otherO = stmt.getObjectURI();
            return !(otherS != null && !otherS.equals(this.s) || otherP != null && !otherP.equals(this.p) || otherO != null && !otherO.equals(this.o));
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!other.getClass().equals(this.getClass())) {
                return false;
            }
            CanonicalObjectPropertyStatement that = (CanonicalObjectPropertyStatement)other;
            return this.s.equals(that.s) && this.o.equals(that.o) && this.p.equals(that.p);
        }

        public int hashCode() {
            return this.s.hashCode() ^ this.o.hashCode() ^ this.p.hashCode();
        }
    }
}

