/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.RoleRestrictedProperty;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import java.util.Objects;
import org.apache.jena.rdf.model.ResourceFactory;

public class FauxProperty
extends BaseResourceBean
implements ResourceBean,
RoleRestrictedProperty {
    private String contextUri;
    private String configUri;
    private String rangeURI;
    private String domainURI;
    private String baseLabel;
    private String rangeLabel;
    private String domainLabel;
    private String groupURI;
    private String publicDescription;
    private int displayTier;
    private int displayLimit;
    private boolean collateBySubclass;
    private boolean selectFromExisting;
    private boolean offerCreateNewOption;
    private String customEntryForm;
    private String customListView;

    public FauxProperty(String domainURI, String baseURI, String rangeURI) {
        super(Objects.requireNonNull(baseURI, "baseURI may not be null"));
        this.rangeURI = rangeURI;
        this.domainURI = domainURI;
    }

    public FauxProperty() {
    }

    public String getContextUri() {
        return this.contextUri;
    }

    public void setContextUri(String contextUri) {
        this.contextUri = contextUri;
    }

    public String getConfigUri() {
        return this.configUri;
    }

    public void setConfigUri(String configUri) {
        this.configUri = configUri;
    }

    public String getBaseURI() {
        return this.getURI();
    }

    public void setBaseURI(String baseURI) {
        this.setURI(baseURI);
    }

    public String getRangeURI() {
        return this.rangeURI;
    }

    public void setRangeURI(String rangeURI) {
        this.rangeURI = rangeURI;
    }

    public String getBaseLabel() {
        return this.baseLabel == null ? this.localName(this.getBaseURI()) : this.baseLabel;
    }

    public void setBaseLabel(String baseLabel) {
        this.baseLabel = baseLabel;
    }

    public String getRangeLabel() {
        return this.rangeLabel == null ? this.localName(this.rangeURI) : this.rangeLabel;
    }

    public void setRangeLabel(String rangeLabel) {
        this.rangeLabel = rangeLabel;
    }

    public String getDomainURI() {
        return this.domainURI;
    }

    public void setDomainURI(String domainURI) {
        this.domainURI = domainURI;
    }

    public String getDomainLabel() {
        return this.domainLabel == null ? (this.domainURI == null ? "null" : this.localName(this.domainURI)) : this.domainLabel;
    }

    public void setDomainLabel(String domainLabel) {
        this.domainLabel = domainLabel;
    }

    public String getGroupURI() {
        return this.groupURI;
    }

    public void setGroupURI(String groupURI) {
        this.groupURI = groupURI;
    }

    public String getDisplayName() {
        return this.getPickListName();
    }

    public void setDisplayName(String displayName) {
        this.setPickListName(displayName);
    }

    public String getPublicDescription() {
        return this.publicDescription;
    }

    public void setPublicDescription(String publicDescription) {
        this.publicDescription = publicDescription;
    }

    public int getDisplayTier() {
        return this.displayTier;
    }

    public void setDisplayTier(int displayTier) {
        this.displayTier = displayTier;
    }

    public int getDisplayLimit() {
        return this.displayLimit;
    }

    public void setDisplayLimit(int displayLimit) {
        this.displayLimit = displayLimit;
    }

    public boolean isCollateBySubclass() {
        return this.collateBySubclass;
    }

    public void setCollateBySubclass(boolean collateBySubclass) {
        this.collateBySubclass = collateBySubclass;
    }

    public boolean isSelectFromExisting() {
        return this.selectFromExisting;
    }

    public void setSelectFromExisting(boolean selectFromExisting) {
        this.selectFromExisting = selectFromExisting;
    }

    public boolean isOfferCreateNewOption() {
        return this.offerCreateNewOption;
    }

    public void setOfferCreateNewOption(boolean offerCreateNewOption) {
        this.offerCreateNewOption = offerCreateNewOption;
    }

    public String getCustomEntryForm() {
        return this.customEntryForm;
    }

    public void setCustomEntryForm(String customEntryForm) {
        this.customEntryForm = customEntryForm;
    }

    public String getCustomListView() {
        return this.customListView;
    }

    public void setCustomListView(String customListView) {
        this.customListView = customListView;
    }

    private String localName(String uriString) {
        try {
            return ResourceFactory.createResource((String)uriString).getLocalName();
        }
        catch (Exception e) {
            return uriString;
        }
    }

    public String toString() {
        return "FauxProperty[domainURI=" + this.domainURI + ", baseUri=" + this.getURI() + ", baseLabel=" + this.baseLabel + ", rangeURI=" + this.rangeURI + ", rangeLabel=" + this.rangeLabel + ", domainLabel=" + this.domainLabel + ", pickListName=" + this.getPickListName() + ", contextUri=" + this.contextUri + ", configUri=" + this.configUri + ", groupURI=" + this.groupURI + "publicDescription=" + this.publicDescription + ", displayTier=" + this.displayTier + ", displayLimit=" + this.displayLimit + ", collateBySubclass=" + this.collateBySubclass + ", selectFromExisting=" + this.selectFromExisting + ", offerCreateNewOption=" + this.offerCreateNewOption + ", customEntryForm=" + this.customEntryForm + ", customListView=" + this.customListView + "]";
    }

    @Override
    public String getDomainVClassURI() {
        return this.getDomainURI();
    }

    @Override
    public String getRangeVClassURI() {
        return this.getRangeURI();
    }
}

