/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationPropertiesSmokeTests
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ConfigurationPropertiesSmokeTests.class);
    private static final String PROPERTY_DEFAULT_NAMESPACE = "Vitro.defaultNamespace";
    private static final String PROPERTY_LANGUAGE_SELECTABLE = "languages.selectableLocales";
    private static final String PROPERTY_LANGUAGE_FORCE = "languages.forceLocale";
    private static final String PROPERTY_LANGUAGE_FILTER = "RDFService.languageFilter";
    private static final String VIVO_BUNDLE_PREFIX = "vivo_all_";
    private static final String VITRO_BUNDLE_PREFIX = "all_";
    private static final String PROPERTY_ARGON2_TIME = "argon2.time";
    private static final String PROPERTY_ARGON2_MEMORY = "argon2.memory";
    private static final String PROPERTY_ARGON2_PARALLELISM = "argon2.parallelism";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        ConfigurationProperties props = ConfigurationProperties.getBean(ctx);
        StartupStatus ss = StartupStatus.getBean(ctx);
        this.checkDefaultNamespace(ctx, props, ss);
        this.checkMultipleRPFs(ctx, props, ss);
        this.checkLanguages(ctx, props, ss);
        this.checkEncryptionParameters(props, ss);
    }

    private void checkDefaultNamespace(ServletContext ctx, ConfigurationProperties props, StartupStatus ss) {
        String ns = props.getProperty(PROPERTY_DEFAULT_NAMESPACE);
        if (ns == null || ns.isEmpty()) {
            ss.fatal(this, "runtime.properties does not contain a value for 'Vitro.defaultNamespace'");
            return;
        }
        try {
            new URI(ns);
        }
        catch (URISyntaxException e) {
            ss.fatal(this, "Vitro.defaultNamespace '" + ns + "' is not a valid URI. " + (e.getMessage() != null ? e.getMessage() : ""));
            return;
        }
        String suffix = "/individual/";
        if (!ns.endsWith(suffix)) {
            ss.warning(this, "Default namespace does not match the expected form (does not end with '" + suffix + "'): '" + ns + "'");
        }
    }

    private void checkMultipleRPFs(ServletContext ctx, ConfigurationProperties props, StartupStatus ss) {
        String rpfStatus = props.getProperty("rp.multiple");
        if (rpfStatus.equals("both")) {
            ss.warning(this, "Deprecation warning: Files matching the name 'runtime.properties' were found in both vivo.home and vivo.home/config. Using the file in vivo.home. Future releases may require runtime.properties be placed in vivo.home/config.");
        }
        if (rpfStatus.equals("home")) {
            ss.warning(this, "Deprecation warning: runtime.properties was found in the vivo.home directory. The recommended directory for runtime.properties is now vivo.home/config. Future releases may require runtime.properties be placed in vivo.home/config.");
        }
    }

    private void checkLanguages(ServletContext ctx, ConfigurationProperties props, StartupStatus ss) {
        String selectString = props.getProperty(PROPERTY_LANGUAGE_SELECTABLE);
        boolean selectableLanguages = StringUtils.isNotBlank((CharSequence)selectString);
        String forceString = props.getProperty(PROPERTY_LANGUAGE_FORCE);
        boolean forceLanguage = StringUtils.isNotBlank((CharSequence)forceString);
        String filterString = props.getProperty(PROPERTY_LANGUAGE_FILTER, "false");
        boolean languageFilter = Boolean.valueOf(filterString);
        String i18nDirPath = ctx.getRealPath("/i18n");
        if (i18nDirPath == null) {
            throw new IllegalStateException("Application does not have an /i18n directory.");
        }
        List<String> i18nNames = null;
        i18nNames = this.geti18nNames(i18nDirPath);
        log.debug((Object)("i18nNames: " + i18nNames));
        if (i18nNames.isEmpty()) {
            ss.fatal(this, "The application found no files in '" + i18nDirPath + "' .");
        } else {
            ss.info(this, "Base language files loaded: " + i18nNames);
        }
        if (selectableLanguages) {
            List<String> selectableLanguagesList = Arrays.asList(selectString.split("\\s*,\\s*"));
            for (String language : selectableLanguagesList) {
                String vivoBundle = VIVO_BUNDLE_PREFIX + language + ".properties";
                String vitroBundle = VITRO_BUNDLE_PREFIX + language + ".properties";
                if (i18nNames.contains(vivoBundle) || i18nNames.contains(vitroBundle)) continue;
                ss.warning(this, language + " was found in the value for " + PROPERTY_LANGUAGE_SELECTABLE + " but no corresponding language file was found.");
            }
        }
        if (selectableLanguages && forceLanguage) {
            ss.warning(this, String.format("Problem with Language setup - runtime.properties specifies a forced locale (%s = %s), and also a list of selectable languages (%s = %s). These options are incompatible.", PROPERTY_LANGUAGE_FORCE, forceString, PROPERTY_LANGUAGE_SELECTABLE, selectString));
        }
        if (selectableLanguages && !languageFilter) {
            ss.warning(this, String.format("Problem with Language setup - languages.selectableLocales in runtime.properties includes one or more additional languages (%s = %s), but runtime.properties has disabled language filtering (%s = %s). This will likely result in a mix of languages in the application.", PROPERTY_LANGUAGE_SELECTABLE, selectString, PROPERTY_LANGUAGE_FILTER, filterString));
        }
    }

    private List<String> geti18nNames(String i18nBaseDirPath) {
        try {
            return Files.walk(Paths.get(i18nBaseDirPath, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(p -> p.toString()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find language files", e);
        }
    }

    private void checkEncryptionParameters(ConfigurationProperties props, StartupStatus ss) {
        this.failIfNotPresent(props, ss, PROPERTY_ARGON2_TIME);
        this.failIfNotPresent(props, ss, PROPERTY_ARGON2_MEMORY);
        this.failIfNotPresent(props, ss, PROPERTY_ARGON2_PARALLELISM);
    }

    private void failIfNotPresent(ConfigurationProperties props, StartupStatus ss, String name) {
        String value = props.getProperty(name);
        if (value == null || value.isEmpty()) {
            ss.fatal(this, "runtime.properties does not contain a value for '" + name + "'");
            return;
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

