/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ajax;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.web.images.PlaceholderUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoreProfileInfo
extends AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog(MoreProfileInfo.class);
    private static final String PARAMETER_PROFILE_URI = "uri";
    private final ObjectPropertyStatementDao opsDao;
    private final String profileUri;

    public MoreProfileInfo(HttpServlet servlet, VitroRequest vreq, HttpServletResponse resp) {
        super(servlet, vreq, resp);
        this.opsDao = vreq.getWebappDaoFactory().getObjectPropertyStatementDao();
        this.profileUri = this.getStringParameter(PARAMETER_PROFILE_URI, "");
    }

    @Override
    public String prepareResponse() throws IOException {
        log.debug((Object)("profile URI is '" + this.profileUri + "'"));
        if (this.profileUri.isEmpty()) {
            return "[]";
        }
        Individual profileInd = this.indDao.getIndividualByURI(this.profileUri);
        if (profileInd == null) {
            log.debug((Object)"no such individual");
            return "[]";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imageUrl", this.getFullImageUrl(profileInd));
        map.put("classLabel", this.getMostSpecificTypeLabel(profileInd.getURI()));
        ArrayNode jsonArray = JsonNodeFactory.instance.arrayNode();
        ObjectNode jsonObj = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : map.entrySet()) {
            jsonObj.put((String)entry.getKey(), (String)entry.getValue());
        }
        jsonArray.add((JsonNode)jsonObj);
        String response = jsonArray.toString();
        log.debug((Object)("response is '" + response + "'"));
        return response;
    }

    private String getMostSpecificTypeLabel(String uri) {
        Map<String, String> types = this.opsDao.getMostSpecificTypesInClassgroupsForIndividual(uri);
        if (types.isEmpty()) {
            return "";
        }
        return types.values().iterator().next();
    }

    private String getFullImageUrl(Individual ind) {
        String path = ind.getThumbUrl();
        if (path == null || path.isEmpty()) {
            path = PlaceholderUtil.getPlaceholderImagePathForIndividual(this.vreq, ind.getURI());
        }
        return UrlBuilder.getUrl(path);
    }
}

