/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.user;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UserAccountsPasswordBasePage
extends UserAccountsPage {
    private static final Log log = LogFactory.getLog(UserAccountsPasswordBasePage.class);
    private static final String PARAMETER_SUBMIT = "submit";
    private static final String PARAMETER_USER = "user";
    private static final String PARAMETER_KEY = "key";
    private static final String PARAMETER_NEW_PASSWORD = "newPassword";
    private static final String PARAMETER_CONFIRM_PASSWORD = "confirmPassword";
    private static final String ERROR_NO_PASSWORD = "errorPasswordIsEmpty";
    private static final String ERROR_WRONG_PASSWORD_LENGTH = "errorPasswordIsWrongLength";
    private static final String ERROR_PASSWORDS_DONT_MATCH = "errorPasswordsDontMatch";
    protected boolean submit;
    protected String userEmail = "";
    protected String key = "";
    protected String newPassword = "";
    protected String confirmPassword = "";
    protected UserAccount userAccount;
    private String bogusMessage = "";
    private String errorCode = "";
    private boolean loggedIn;

    protected UserAccountsPasswordBasePage(VitroRequest vreq) {
        super(vreq);
        this.parseRequestParameters();
        this.validateUserAccountInfo();
        if (this.isSubmit() && !this.isBogus()) {
            this.validateParameters();
        }
    }

    private void parseRequestParameters() {
        this.submit = this.isFlagOnRequest(PARAMETER_SUBMIT);
        this.userEmail = this.getStringParameter(PARAMETER_USER, "");
        this.key = this.getStringParameter(PARAMETER_KEY, "");
        this.newPassword = this.getStringParameter(PARAMETER_NEW_PASSWORD, "");
        this.confirmPassword = this.getStringParameter(PARAMETER_CONFIRM_PASSWORD, "");
    }

    public boolean isSubmit() {
        return this.submit;
    }

    private void validateUserAccountInfo() {
        this.userAccount = this.userAccountsDao.getUserAccountByEmail(this.userEmail);
        if (this.userAccount == null) {
            log.warn((Object)("Password request for '" + this.userEmail + "' is bogus: no such user"));
            this.bogusMessage = this.i18n.text("account_no_longer_exists", new Object[0]);
            return;
        }
        if (this.userAccount.getPasswordLinkExpires() == 0L) {
            log.info((Object)("Password request for '" + this.userEmail + "' is bogus: password change is not pending."));
            this.bogusMessage = this.passwordChangeNotPendingMessage();
            return;
        }
        if (this.userAccount.isExternalAuthOnly()) {
            log.info((Object)("Password request for '" + this.userEmail + "' is bogus: account is external auth only."));
            this.bogusMessage = this.passwordChangeNotPendingMessage();
            return;
        }
        Date expirationDate = new Date(this.userAccount.getPasswordLinkExpires());
        if (expirationDate.before(new Date())) {
            log.info((Object)("Password request for '" + this.userEmail + "' is bogus: expiration date has passed."));
            this.bogusMessage = this.passwordChangeNotPendingMessage();
            return;
        }
        String expectedKey = this.userAccount.getPasswordLinkExpiresHash();
        if (!this.key.equals(expectedKey)) {
            log.warn((Object)("Password request for '" + this.userEmail + "' is bogus: key (" + this.key + ") doesn't match expected key (" + expectedKey + ")"));
            this.bogusMessage = this.passwordChangeNotPendingMessage();
            return;
        }
        UserAccount currentUser = LoginStatusBean.getCurrentUser((HttpServletRequest)this.vreq);
        if (currentUser != null) {
            this.loggedIn = true;
            String currentUserEmail = currentUser.getEmailAddress();
            if (!this.userEmail.equals(currentUserEmail)) {
                log.info((Object)("Password request for '" + this.userEmail + "' when already logged in as '" + currentUserEmail + "'"));
                this.bogusMessage = this.alreadyLoggedInMessage(currentUserEmail);
            }
        }
    }

    public boolean isBogus() {
        return !this.bogusMessage.isEmpty();
    }

    public String getBogusMessage() {
        return this.bogusMessage;
    }

    private void validateParameters() {
        if (this.newPassword.isEmpty()) {
            this.errorCode = ERROR_NO_PASSWORD;
        } else if (!this.checkPasswordLength(this.newPassword)) {
            this.errorCode = ERROR_WRONG_PASSWORD_LENGTH;
        } else if (!this.newPassword.equals(this.confirmPassword)) {
            this.errorCode = ERROR_PASSWORDS_DONT_MATCH;
        }
    }

    public boolean isValid() {
        return this.errorCode.isEmpty();
    }

    public final ResponseValues showPage() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("minimumLength", 6);
        body.put("maximumLength", 12);
        body.put("userAccount", this.userAccount);
        body.put(PARAMETER_KEY, this.userAccount.getPasswordLinkExpiresHash());
        body.put(PARAMETER_NEW_PASSWORD, this.newPassword);
        body.put(PARAMETER_CONFIRM_PASSWORD, this.confirmPassword);
        body.put("formUrls", this.buildUrlsMap());
        if (!this.errorCode.isEmpty()) {
            body.put(this.errorCode, Boolean.TRUE);
        }
        return new TemplateResponseValues(this.templateName(), body);
    }

    public String getSuccessMessage() {
        if (this.loggedIn) {
            return this.i18n.text("password_saved", new Object[0]);
        }
        return this.i18n.text("password_saved_please_login", new Object[0]);
    }

    protected abstract String alreadyLoggedInMessage(String var1);

    protected abstract String passwordChangeNotPendingMessage();

    protected abstract String templateName();
}

