/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.forwarder.PageForwarder;
import edu.cornell.mannlib.vedit.forwarder.impl.UrlForwarder;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vedit.validator.impl.IntValidator;
import edu.cornell.mannlib.vedit.validator.impl.XMLNameValidator;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionListener;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.edit.utils.RoleLevelOptionsSetup;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.DatatypeDao;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatapropRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)DatapropRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        VClass domain;
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        EditProcessObject epo = super.createEpo(request);
        epo.setBeanClass(DataProperty.class);
        VitroRequest vreq = new VitroRequest(request);
        WebappDaoFactory wadf = ModelAccess.on(this.getServletContext()).getWebappDaoFactory();
        DatatypeDao dDao = wadf.getDatatypeDao();
        DataPropertyDao dpDao = wadf.getDataPropertyDao();
        epo.setDataAccessObject(dpDao);
        OntologyDao ontDao = wadf.getOntologyDao();
        DataProperty objectForEditing = null;
        String action = null;
        if (epo.getAction() == null) {
            action = "insert";
            epo.setAction("insert");
        } else {
            action = epo.getAction();
        }
        if (epo.getUseRecycledBean()) {
            objectForEditing = (DataProperty)epo.getNewBean();
        } else {
            String uri = request.getParameter("uri");
            if (uri != null) {
                try {
                    objectForEditing = dpDao.getDataPropertyByURI(uri);
                    epo.setOriginalBean(objectForEditing);
                    action = "update";
                    epo.setAction("update");
                }
                catch (NullPointerException e) {
                    log.error((Object)"Need to implement 'record not found' error message.");
                }
            } else {
                action = "insert";
                epo.setAction("insert");
                objectForEditing = new DataProperty();
                epo.setOriginalBean(objectForEditing);
            }
        }
        Object[] simpleMaskPair = new Object[]{"URI", objectForEditing.getURI()};
        epo.getSimpleMask().add(simpleMaskPair);
        LinkedList<XMLNameValidator> lnList = new LinkedList<XMLNameValidator>();
        lnList.add(new XMLNameValidator());
        epo.getValidatorMap().put("LocalName", lnList);
        LinkedList<IntValidator> vlist = new LinkedList<IntValidator>();
        vlist.add(new IntValidator(0, 99));
        epo.getValidatorMap().put("StatusId", vlist);
        try {
            Class[] args = new Class[]{String.class};
            epo.setGetMethod(dpDao.getClass().getDeclaredMethod("getDataPropertyByURI", args));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"DatapropRetryController could not find the getDataPropertyByURI method in the facade");
        }
        epo.setPostInsertPageForwarder(new DataPropertyInsertPageForwarder());
        epo.setPostDeletePageForwarder(new UrlForwarder("listDatatypeProperties"));
        ArrayList<PropertyRestrictionListener> changeListenerList = new ArrayList<PropertyRestrictionListener>();
        changeListenerList.add(new PropertyRestrictionListener());
        epo.setChangeListenerList(changeListenerList);
        FormObject foo = new FormObject();
        foo.setErrorMap(epo.getErrMsgMap());
        epo.setFormObject(foo);
        FormUtils.populateFormFromBean(objectForEditing, action, foo);
        HashMap<String, List<Option>> optionMap = new HashMap<String, List<Option>>();
        List<Option> namespaceList = FormUtils.makeOptionListFromBeans(ontDao.getAllOntologies(), "URI", "Name", objectForEditing.getNamespace() == null ? "" : objectForEditing.getNamespace(), null, objectForEditing.getNamespace() != null);
        namespaceList.add(0, new Option(vreq.getUnfilteredWebappDaoFactory().getDefaultNamespace(), "default"));
        optionMap.put("Namespace", namespaceList);
        List<Option> domainOptionList = FormUtils.makeVClassOptionList(vreq.getUnfilteredWebappDaoFactory(), objectForEditing.getDomainClassURI());
        if (objectForEditing.getDomainClassURI() != null && (domain = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(objectForEditing.getDomainClassURI())) != null && domain.isAnonymous()) {
            domainOptionList.add(0, new Option(domain.getURI(), domain.getName(), true));
        }
        domainOptionList.add(0, new Option("", "(none specified)"));
        optionMap.put("DomainClassURI", domainOptionList);
        List<Option> datatypeOptionList = FormUtils.makeOptionListFromBeans(dDao.getAllDatatypes(), "Uri", "Name", objectForEditing.getRangeDatatypeURI(), null);
        datatypeOptionList.add(0, new Option("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", "XML literal (allows XHTML markup)"));
        datatypeOptionList.add(0, new Option(null, "untyped (use if language tags desired)"));
        optionMap.put("RangeDatatypeURI", datatypeOptionList);
        List<Option> groupOptList = FormUtils.makeOptionListFromBeans(vreq.getUnfilteredWebappDaoFactory().getPropertyGroupDao().getPublicGroups(true), "URI", "Name", objectForEditing.getGroupURI() == null ? "" : objectForEditing.getGroupURI(), null, objectForEditing.getGroupURI() != null);
        HashMap<String, Option> hashMap = new HashMap<String, Option>();
        groupOptList = this.getSortedList(hashMap, groupOptList, vreq);
        groupOptList.add(0, new Option("", "none"));
        optionMap.put("GroupURI", groupOptList);
        optionMap.put("HiddenFromDisplayBelowRoleLevelUsingRoleUri", RoleLevelOptionsSetup.getDisplayOptionsList(objectForEditing));
        optionMap.put("ProhibitedFromUpdateBelowRoleLevelUsingRoleUri", RoleLevelOptionsSetup.getUpdateOptionsList(objectForEditing));
        optionMap.put("HiddenFromPublishBelowRoleLevelUsingRoleUri", RoleLevelOptionsSetup.getPublishOptionsList(objectForEditing));
        foo.setOptionLists(optionMap);
        request.setAttribute("functional", (Object)objectForEditing.getFunctional());
        if (objectForEditing.getURI() != null) {
            objectForEditing.setFunctional(false);
        }
        foo.setErrorMap(epo.getErrMsgMap());
        request.setAttribute("colspan", (Object)"4");
        request.setAttribute("scripts", (Object)"/templates/edit/formBasic.js");
        request.setAttribute("formJsp", (Object)"/templates/edit/specific/dataprop_retry.jsp");
        request.setAttribute("title", (Object)"Data Property Editing Form");
        request.setAttribute("_action", (Object)action);
        request.setAttribute("unqualifiedClassName", (Object)"DatatypeProperty");
        this.setRequestAttributes(request, epo);
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)"DatatypeRetryController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    class DataPropertyInsertPageForwarder
    implements PageForwarder {
        DataPropertyInsertPageForwarder() {
        }

        @Override
        public void doForward(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) {
            String newPropertyUrl = "datapropEdit?uri=";
            DataProperty p = (DataProperty)epo.getNewBean();
            try {
                newPropertyUrl = newPropertyUrl + URLEncoder.encode(p.getURI(), "UTF-8");
            }
            catch (Exception e) {
                log.error((Object)(this.getClass().getName() + " could not use UTF-8 encoding to encode new URL"));
            }
            try {
                response.sendRedirect(newPropertyUrl);
            }
            catch (IOException ioe) {
                log.error((Object)"DataPropertyInsertPageForwarder could not send redirect.");
            }
        }
    }
}

